/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.InstanceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.DatabasePropertyDialogUDB;

public class DataBaseUDB
extends StorageObject {
    public static final String[] OPTIONAL_YES_NO_STATES = new String[]{"", "YES", "NO"};
    public static final String COMPATIBILITY = "COMPATIBILITY";
    public static final String SYSTEM = "SYSTEM";
    public static final String IDENTITY = "IDENTITY";
    public static final int MAXIMUM_COMMENT_LENGTH = 30;
    protected static String[] availableCollatingSequences = new String[]{"", "COMPATIBILITY", "SYSTEM", "IDENTITY"};
    private static Set yesNoSet = null;
    private String automaticStorage = "";
    private String onPath = "";
    private String dbPathOn = "";
    private String alias = "";
    private String codeset = "";
    private String territory = "";
    private String collatingSequence = "";
    private int segmentNumber = 0;
    private int defaultExtentSize = 0;
    private InstanceUDB instance = null;
    private TableSpaceUDB catalogTableSpace = null;
    private TableSpaceUDB userTableSpace = null;
    private TableSpaceUDB temporaryTableSpace = null;
    public static final String TYPE_NAME = "DB";
    public static final String OLD_TYPE_NAME = "Database";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public void setAutomaticStorage(String autoStorage) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(OPTIONAL_YES_NO_STATES));
        }
        if (yesNoSet.contains(autoStorage)) {
            this.automaticStorage = autoStorage;
            this.fireDataFieldChange();
        }
    }

    public String getAutomaticStorage() {
        return this.automaticStorage;
    }

    public static String[] getAutomaticStorageChoices() {
        return OPTIONAL_YES_NO_STATES;
    }

    public void setOnPath(String path) {
        this.onPath = path;
        this.fireDataFieldChange();
    }

    public String getOnPath() {
        return this.onPath;
    }

    public void setDBPathOn(String path) {
        this.dbPathOn = path;
        this.fireDataFieldChange();
    }

    public String getDBPathOn() {
        return this.dbPathOn;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.fireDataFieldChange();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setCodeSet(String codeset) {
        this.codeset = codeset;
        this.fireDataFieldChange();
    }

    public String getCodeSet() {
        return this.codeset;
    }

    public void setTerritory(String territory) {
        this.territory = territory;
        this.fireDataFieldChange();
    }

    public String getTerritory() {
        return this.territory;
    }

    public static String[] getAvailableCollatingSequences() {
        return availableCollatingSequences;
    }

    public void setCollatingSequence(String collatingSequence) {
        this.collatingSequence = collatingSequence;
        this.fireDataFieldChange();
    }

    public String getCollatingSequence() {
        return this.collatingSequence;
    }

    public void setSegmentNumber(int number) {
        this.segmentNumber = number;
        this.fireDataFieldChange();
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public void setDefaultExtentSize(int size) {
        this.defaultExtentSize = size;
        this.fireDataFieldChange();
    }

    public int getDefaultExtentSize() {
        return this.defaultExtentSize;
    }

    @Override
    public void setCommentInRDBMS(String comment) {
        super.setCommentInRDBMS(comment);
        this.fireDataFieldChange();
    }

    public boolean checkComment(String comment) {
        return comment.length() <= 30;
    }

    public void setInstance(InstanceUDB instance) {
        this.instance = instance;
        this.fireDataFieldChange();
    }

    public InstanceUDB getInstance() {
        return this.instance;
    }

    public void setCatalogTableSpace(TableSpaceUDB tablespace) {
        this.catalogTableSpace = tablespace;
        if (tablespace != null) {
            tablespace.setDBDefOnly(true);
        }
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getCatalogTableSpace() {
        return this.catalogTableSpace;
    }

    public void setUserTableSpace(TableSpaceUDB tablespace) {
        this.userTableSpace = tablespace;
        if (tablespace != null) {
            tablespace.setDBDefOnly(true);
        }
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getUserTableSpace() {
        return this.userTableSpace;
    }

    public void setTemporaryTableSpace(TableSpaceUDB tablespace) {
        this.temporaryTableSpace = tablespace;
        if (tablespace != null) {
            tablespace.setDBDefOnly(true);
        }
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getTemporaryTableSpace() {
        return this.temporaryTableSpace;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DatabasePropertyDialogUDB dialog = new DatabasePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }
}

