/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RedoLogGroupOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.DatabasePropertyDialogOraclev9i;

public class DataBaseOraclev9i
extends DataBaseOracle {
    protected String forceLogging = "NO";
    protected String extentManagement = EXTENT_MANAMEGENT_TYPES[0];
    protected static Set extentManagementSet = null;
    protected static final String[] EXTENT_MANAMEGENT_TYPES = new String[]{"Dictionary", "Local"};
    protected String passForSYS = "";
    protected String passForSYSTEM = "";
    protected String timeZone = "";
    protected TemporaryTablespaceOraclev9i tempTablespace = null;
    protected UndoTablespaceOraclev9i undoTablespace = null;

    public DataBaseOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DatabasePropertyDialogOraclev9i dialog = new DatabasePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    protected boolean checkExtentManagement(String value) {
        if (extentManagementSet == null) {
            extentManagementSet = new HashSet();
            extentManagementSet.addAll(Arrays.asList(DataBaseOraclev9i.getExtentManagementTypes()));
        }
        return extentManagementSet.contains(value);
    }

    public static String[] getExtentManagementTypes() {
        return EXTENT_MANAMEGENT_TYPES;
    }

    public String getExtentManagement() {
        return this.extentManagement;
    }

    public void setExtentManagement(String extentManagement) {
        if (this.checkExtentManagement(extentManagement)) {
            this.extentManagement = extentManagement;
            this.fireDataFieldChange();
        }
    }

    public String getForceLogging() {
        return this.forceLogging;
    }

    public void setForceLogging(String forceLogging) {
        if (ConstantsOracle.checkYesNo(forceLogging)) {
            this.forceLogging = forceLogging;
            this.fireDataFieldChange();
        }
    }

    public String getPassForSYS() {
        return this.passForSYS;
    }

    public void setPassForSYS(String passForSYS) {
        this.passForSYS = passForSYS;
    }

    public String getPassForSYSTEM() {
        return this.passForSYSTEM;
    }

    public void setPassForSYSTEM(String passForSYSTEM) {
        this.passForSYSTEM = passForSYSTEM;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public TemporaryTablespaceOraclev9i getTempTablespace() {
        return this.tempTablespace;
    }

    public void setTempTablespace(TemporaryTablespaceOraclev9i tempTablespace) {
        if (this.tempTablespace != tempTablespace) {
            this.tempTablespace = tempTablespace;
            this.fireDataFieldChange();
        }
    }

    public UndoTablespaceOraclev9i getUndoTablespace() {
        return this.undoTablespace;
    }

    public void setUndoTablespace(UndoTablespaceOraclev9i undoTablespace) {
        if (this.undoTablespace != undoTablespace) {
            this.undoTablespace = undoTablespace;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        DataBaseOraclev9i dbOracle = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev9i)targetDesign).getDataBaseSet().getByName(this.getName());
        if (storageObject != null) {
            if (storageObject.isRawObject()) {
                dbOracle = (DataBaseOraclev9i)storageObject;
            }
        } else {
            dbOracle = (DataBaseOraclev9i)((StorageDesignOraclev9i)targetDesign).getDataBaseSet().createDataBase();
        }
        if (dbOracle != null) {
            dbOracle.setName(this.getName());
            for (DataFileOraclev9i dataFile : this.getDataFiles()) {
                DataFileOraclev9i targetDataFile = (DataFileOraclev9i)((StorageDesignOraclev9i)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetDataFile == null) {
                    DataFileOraclev9i newDataFile = (DataFileOraclev9i)((StorageDesignOraclev9i)targetDesign).getDataFileSet().createDataFile();
                    newDataFile.setName(dataFile.getName());
                    newDataFile.setDataBase(dbOracle);
                    newDataFile.setRawObject(true);
                    ((StorageDesignOraclev9i)targetDesign).getDataFileSet().add(newDataFile);
                    dbOracle.getDataFiles().add(newDataFile);
                    continue;
                }
                targetDataFile.setDataBase(dbOracle);
                ((StorageDesignOraclev9i)targetDesign).getDataFileSet().add(targetDataFile);
                dbOracle.getDataFiles().add(targetDataFile);
            }
            for (RedoLogGroupOraclev9i logGroup : this.getRedoLogGroups()) {
                RedoLogGroupOraclev9i targetLogGroup = (RedoLogGroupOraclev9i)((StorageDesignOraclev9i)targetDesign).getRedoLogGroupSet().getByName(logGroup.getName());
                if (targetLogGroup == null) {
                    RedoLogGroupOraclev9i newLogGroup = (RedoLogGroupOraclev9i)((StorageDesignOraclev9i)targetDesign).getRedoLogGroupSet().createRedoLogGroup();
                    newLogGroup.setName(logGroup.getName());
                    newLogGroup.setDataBase(dbOracle);
                    newLogGroup.setRawObject(true);
                    ((StorageDesignOraclev9i)targetDesign).getRedoLogGroupSet().add(newLogGroup);
                    dbOracle.getRedoLogGroups().add(newLogGroup);
                    continue;
                }
                targetLogGroup.setDataBase(dbOracle);
                ((StorageDesignOraclev9i)targetDesign).getRedoLogGroupSet().add(targetLogGroup);
                dbOracle.getRedoLogGroups().add(targetLogGroup);
            }
            dbOracle.setControlFileReuse(this.getControlFileReuse());
            dbOracle.setMaxDataFiles(this.getMaxDataFiles());
            dbOracle.setMaxInstances(this.getMaxInstances());
            dbOracle.setCharacterSet(this.getCharacterSet());
            dbOracle.setNationalCharacterSet(this.getNationalCharacterSet());
            dbOracle.setPassForSYS(this.getPassForSYS());
            dbOracle.setPassForSYSTEM(this.getPassForSYSTEM());
            dbOracle.setTimeZone(this.getTimeZone());
            dbOracle.setMaxLogFiles(this.getMaxLogFiles());
            dbOracle.setMaxLogMembers(this.getMaxLogMembers());
            dbOracle.setMaxLogHistory(this.getMaxLogHistory());
            dbOracle.setArchiveLog(this.getArchiveLog());
            dbOracle.setForceLogging(this.getForceLogging());
            dbOracle.setExtentManagement(this.getExtentManagement());
            if (this.getTempTablespace() != null) {
                TemporaryTablespaceOraclev9i tempTableSpace = (TemporaryTablespaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTemporaryTablespaceSet().getByName(this.getTempTablespace().getName());
                if (tempTableSpace == null) {
                    TemporaryTablespaceOraclev9i newTablespace = (TemporaryTablespaceOraclev9i)((StorageDesignOraclev9i)this.getStorageDesign()).getTemporaryTablespaceSet().createTemporaryTablespace();
                    newTablespace.setName(this.getTempTablespace().getName());
                    newTablespace.setRawObject(true);
                    dbOracle.setTempTablespace(newTablespace);
                } else {
                    dbOracle.setTempTablespace(tempTableSpace);
                }
            }
            if (this.getUndoTablespace() != null) {
                UndoTablespaceOraclev9i undoTabSpace = (UndoTablespaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getUndoTablespaceSet().getByName(this.getUndoTablespace().getName());
                if (undoTabSpace == null) {
                    UndoTablespaceOraclev9i newUndoTabSpace = (UndoTablespaceOraclev9i)((StorageDesignOraclev9i)this.getStorageDesign()).getUndoTablespaceSet().createTablespace();
                    newUndoTabSpace.setName(this.getUndoTablespace().getName());
                    newUndoTabSpace.setRawObject(true);
                    dbOracle.setUndoTablespace(newUndoTabSpace);
                } else {
                    dbOracle.setUndoTablespace(undoTabSpace);
                }
            }
            dbOracle.setComment(this.getComment());
            dbOracle.setRawObject(false);
        }
    }
}

