/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.sqlserver;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDDecimalSqlServer
extends MDPackedSized {
    private String name = "DECIMAL";

    @Override
    public String getName() {
        return this.name;
    }

    public void setNumericSynonym() {
        this.name = "NUMERIC";
    }

    @Override
    public String getMaxSize() {
        return "17";
    }

    @Override
    public MDDataType deepCopy() {
        MDDecimalSqlServer copy = new MDDecimalSqlServer();
        copy.setPrecision(this.getPrecision());
        copy.setScale(this.getScale());
        if (this.getName().equals("NUMERIC")) {
            copy.setNumericSynonym();
        }
        return copy;
    }

    @Override
    public int getByteSize() {
        int size = 0;
        if (this.getPrecision() >= 1 && this.getPrecision() <= 9) {
            size = 5;
        } else if (this.getPrecision() >= 10 && this.getPrecision() <= 19) {
            size = 9;
        } else if (this.getPrecision() >= 20 && this.getPrecision() <= 28) {
            size = 13;
        } else if (this.getPrecision() >= 29 && this.getPrecision() <= 38) {
            size = 17;
        }
        return size;
    }

    @Override
    public int getMaxPrecision() {
        return 28;
    }
}

