/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHAlias
extends RowHandler {
    public static final String OBJECT_TYPE = "ALIASES";

    public RHAlias(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createAlias(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    private void createAlias(VarFileLine line) {
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        if (storageDesign != null) {
            int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
            if (testCool == 1000) {
                String nameOfReference = this.getField(line, "ALIAS_REF_NAME");
                ModelObject objectReferend = this.searchObjectForAlias(nameOfReference);
                if (objectReferend != null) {
                    if (objectReferend instanceof Table) {
                        Table table = (Table)objectReferend;
                        TableProxyDB2 tableProxy = (TableProxyDB2)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxy != null) {
                            AliasDB2 alias = this.fillElements(line, storageDesign);
                            alias.setTable(tableProxy);
                            this.cleanUp(line, alias);
                        }
                    } else if (objectReferend instanceof AliasDB2) {
                        AliasDB2 alias = this.fillElements(line, storageDesign);
                        AliasDB2 another = (AliasDB2)objectReferend;
                        alias.setAnotherAlias(another);
                        this.cleanUp(line, alias);
                    } else if (objectReferend instanceof TableView) {
                        TableView view = (TableView)objectReferend;
                        TableViewProxyDB2 viewProxy = (TableViewProxyDB2)storageDesign.getTableViewProxySet().getProxy(view.getObjectID());
                        if (viewProxy != null) {
                            AliasDB2 alias = this.fillElements(line, storageDesign);
                            alias.setView(viewProxy);
                            this.cleanUp(line, alias);
                        }
                    }
                }
            } else {
                AliasDB2 alias = this.fillElements(line, storageDesign);
                String tableKey = this.getField(line, "ALIAS_TABLE_ID");
                if (!tableKey.equalsIgnoreCase("0")) {
                    TableProxyDB2 tableProxy;
                    Table table = (Table)this.getCreatedObject(tableKey);
                    if (table != null && (tableProxy = (TableProxyDB2)storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null) {
                        alias.setTable(tableProxy);
                    }
                } else {
                    TableViewProxyDB2 viewProxy;
                    TableView tableView;
                    String tableViewKey = this.getField(line, "ALIAS_VIEW_ID");
                    if (!tableViewKey.equalsIgnoreCase("0") && (tableView = (TableView)this.getCreatedObject(tableViewKey)) != null && (viewProxy = (TableViewProxyDB2)storageDesign.getTableViewProxySet().getProxy(tableView.getObjectID())) != null) {
                        alias.setView(viewProxy);
                    }
                }
                this.cleanUp(line, alias);
            }
        }
    }

    private ModelObject searchObjectForAlias(String nameObject) {
        ModelObject objectForAlias = null;
        Map allObjects = this.getAllCreatedObjects();
        Collection allObjectsCollection = allObjects.values();
        for (ModelObject objectCreated : allObjectsCollection) {
            if (!(objectCreated instanceof Table) && !(objectCreated instanceof TableView) && !(objectCreated instanceof SynonymDB2) || !objectCreated.getName().equalsIgnoreCase(nameObject)) continue;
            objectForAlias = objectCreated;
        }
        return objectForAlias;
    }

    private AliasDB2 fillElements(VarFileLine line, StorageDesignDB2v70 storageDesign) {
        AliasDB2 alias = storageDesign.getAliasSet().createAlias();
        alias.setName(this.getField(line, "ALIAS_NAME"));
        this.fillCommontOn(line, alias);
        this.fillOwner(line, alias);
        return alias;
    }

    private void cleanUp(VarFileLine line, AliasDB2 alias) {
        this.addCreatedObject(this.getField(line, "general_id"), alias);
        this.removeSelectedLine(line);
    }

    private void fillCommontOn(VarFileLine line, AliasDB2 alias) {
        String commentKey = this.getField(line, "ALIAS_COMMENT");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(commentKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            alias.setCommentInRDBMS(comment);
            alias.setComment(comment);
        }
    }

    private void fillOwner(VarFileLine line, AliasDB2 alias) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            String ownerName = this.getField(line, "ALIAS_OWNER");
            Owner owner = (Owner)this.getAllCreatedObjects().get(ownerName);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)alias.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(ownerName);
                this.addCreatedObject(ownerName, owner);
            }
            alias.setOwner(owner);
        } else {
            String key = this.getField(line, "ALIAS_OWNER");
            Owner owner = (Owner)this.getCreatedObject(key);
            alias.setOwner(owner);
        }
    }
}

