/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODODomain
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DOMAIN";
    private static final Logger LOGGER = new Logger(ODODomain.class);
    PreparedStatement val_statement;

    public ODODomain(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        Statement nvstatement = null;
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            ODObject odTable;
            String ivid;
            String id;
            String tableName;
            ResultSet rs;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                if (nvstatement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid    ");
                    buffer.append("from ci_domains a,sdd_folder_members b, i$sdd_wa_context cc ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    buffer.append(" order by name ");
                    nvstatement = sqlConnection.prepareStatement(buffer.toString());
                }
                rs = null;
                try {
                    nvstatement.setString(1, odNext.getIrid());
                    nvstatement.setString(2, odNext.ivid);
                    nvstatement.setString(3, odNext.wa_irid);
                    rs = nvstatement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODODomain.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    if (this.getDesign().getDomainSet().getByName(tableName) == null) {
                        odTable = new ODObject(true, tableName, OBJECT_TYPE, id);
                    } else {
                        odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                        odTable.setStatus("Name exist");
                    }
                    odTable.ivid = ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    odTable.containerType = odNext.containerType;
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            rs = null;
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select  a.NAME,a.ID,a.ivid ");
                buffer.append("from ci_domains a,sdd_folder_members b ");
                buffer.append("where ");
                buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                buffer.append(" and b.PARENT_IVID = ? ");
                buffer.append("AND EXISTS \n");
                buffer.append("(SELECT 1 \n");
                buffer.append("FROM ci_domains F, \n");
                buffer.append("  I$sdd_Wa_Context C \n");
                buffer.append("WHERE a.Irid        = F.Irid \n");
                buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                buffer.append("AND C.Workarea_Irid = ? \n");
                buffer.append(")");
                buffer.append(" and a.ivid = ");
                buffer.append(" (select ivid from i$sdd_object_versions v ");
                buffer.append("  where ");
                buffer.append("  a.id = v.irid and ");
                buffer.append("  branch_id = ? ");
                buffer.append("  and sequence_in_branch  is not null");
                buffer.append("  and wastebasket='N' ");
                buffer.append("  and sequence_in_branch = ");
                buffer.append("   ( ");
                buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                buffer.append("     where ");
                buffer.append("     v2.irid = a.id");
                buffer.append("     and branch_id = ? ");
                buffer.append("     and sequence_in_branch  is not null ");
                buffer.append("     and wastebasket='N' ");
                buffer.append("   ) ");
                buffer.append("  )");
                buffer.append(" order by name ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODODomain.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                if (this.getDesign().getDomainSet().getByName(tableName) == null) {
                    odTable = new ODObject(true, tableName, OBJECT_TYPE, id);
                } else {
                    odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                    odTable.setStatus("Name exist");
                }
                odTable.ivid = ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                odTable.branch = odNext.branch;
                odTable.containerType = odNext.containerType;
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (nvstatement != null) {
            nvstatement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        this.val_statement = null;
        for (ODObject odObject : selectedObjects) {
            if (!OBJECT_TYPE.equalsIgnoreCase(odObject.getType())) continue;
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT b.ID,b.COLUMN_PRECISION,b.DATATYPE,b.DESCRIPTION,b.MAXIMUM_COLUMN_LENGTH,b.DEFAULT_VALUE,b.UNIT_OF_MEASURE ");
                buffer.append("FROM ci_domains b ");
                buffer.append("WHERE b.IVID = ?");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            String id = odObject.getIrid();
            ResultSet rs = null;
            try {
                statement.setString(1, odObject.ivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODODomain.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    String dtype;
                    String precision = rs.getString("COLUMN_PRECISION");
                    String datatype = rs.getString("DATATYPE");
                    String maxColumnLength = rs.getString("MAXIMUM_COLUMN_LENGTH");
                    String comment = rs.getString("DESCRIPTION");
                    String def_value = rs.getString("DEFAULT_VALUE");
                    String unit_of_measure = rs.getString("UNIT_OF_MEASURE");
                    String domainName = odObject.getName();
                    Domain domain = ODODomain.getDomain(this.getDesign().getDomainSet(), id);
                    if (domain == null && (domain = (Domain)this.getDesign().getDomainSet().getByName(domainName)) != null) {
                        domain.setImportedId(id);
                    }
                    if (domain != null) {
                        domain.setDefaultValues();
                    } else {
                        domain = this.getDesign().getDomainSet().createDomain();
                        domain.setObjectID(id);
                    }
                    domain.setName(domainName);
                    domain.setName(odObject.getName());
                    domain.setFileName(this.getDesign().getName() + "_Domains");
                    domain.setComment(comment);
                    if (def_value != null) {
                        domain.setDefaultValue(def_value);
                    }
                    if (unit_of_measure != null) {
                        domain.setUnitOfMeasure(unit_of_measure);
                    }
                    this.getExtractionHandler().addToImportedObjects(id, domain);
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                    LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype);
                    if (logDatatype == null && (dtype = MappingDatatypeNameLogicalDataType.getDesignerMappedName(nameDatatype)) != null) {
                        nameDatatype = dtype;
                        logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype.toUpperCase());
                    }
                    if (logDatatype != null) {
                        domain.setLogicalDatatype(logDatatype);
                        if (!nameDatatype.equalsIgnoreCase("UNKNOWN")) {
                            if (nameDatatype.toUpperCase().indexOf("CHAR") <= -1) {
                                if (nameDatatype.toUpperCase().indexOf("TIMESTAMP") > -1) {
                                    if (precision != null) {
                                        domain.setDataTypeParameter("precision", precision);
                                    }
                                } else {
                                    if (maxColumnLength != null) {
                                        domain.setDataTypeParameter("precision", maxColumnLength);
                                    }
                                    if (precision != null) {
                                        domain.setDataTypeParameter("scale", precision);
                                    }
                                }
                            } else if (maxColumnLength != null) {
                                domain.setDataTypeParameter("size", maxColumnLength);
                            }
                        }
                    } else {
                        LOGGER.warn("ODOType.initStructuredTypeAttributes() - Unable to find Logical DataType for: " + datatype);
                    }
                    this.setValues(sqlConnection, domain, id, odObject.ivid);
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.val_statement != null) {
            this.val_statement.close();
        }
    }

    private void setValues(Connection sqlConnection, Domain domain, String id, String ivid) throws Exception {
        if (this.val_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("low_value").append(',');
            buffer.append("HIGH_VALUE").append(",meaning ");
            buffer.append("FROM").append(' ');
            buffer.append("ci_attribute_values").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("domain_reference").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("radio_sequence");
            this.val_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.val_statement.setString(1, id);
            this.val_statement.setString(2, ivid);
            rs = this.val_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODODomain.setValues():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                ConstraintEnumeration valueList;
                String beginValue = rs.getString("low_value");
                String endValue = rs.getString("HIGH_VALUE");
                String description = rs.getString(3);
                if (endValue != null) {
                    AVT avt = new AVT(beginValue, endValue, description);
                    domain.addAVT(avt);
                    continue;
                }
                if (domain.getValueList() == null) {
                    valueList = new ConstraintEnumeration();
                    domain.setValueList(valueList);
                } else {
                    valueList = domain.getValueList();
                }
                valueList.add(beginValue, description);
            }
            rs.close();
        }
    }

    public static Domain getDomain(DomainSet set, String id) {
        Domain domain = (Domain)set.getObjectByID(id);
        if (domain == null) {
            domain = (Domain)set.getObjectByImportedID(id);
        }
        return domain;
    }
}

