/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k12;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHTableSQLServerv2k5;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.IndexProxySqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSQLServerv2k12
extends MOHTableSQLServerv2k5 {
    private static final Logger LOGGER = new Logger(MOHTableSQLServerv2k12.class);

    public MOHTableSQLServerv2k12(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    protected void initIndexes(Connection sqlConnection, Table table, String tableId, String db, String dboSchema) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k12.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("i.name, i.index_id, i.type,i.type_desc,i.is_primary_key, ");
            buffer.append("i.is_unique_constraint,i.is_unique, ");
            buffer.append("i.ignore_dup_key,i.fill_factor,i.is_padded,i.allow_row_locks, ");
            buffer.append("i.allow_page_locks,i.data_space_id,ds.name ds_name,ds.type ds_type, ");
            buffer.append("s.no_recompute AS [NoAutomaticRecomputation] ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.indexes i INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ");
            buffer.append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND  ");
            buffer.append("s.object_id = i.object_id ");
            buffer.append("WHERE").append(' ');
            buffer.append("i.object_id = ").append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("i.is_primary_key = 0 ");
            buffer.append("AND").append(' ');
            buffer.append("i.is_unique_constraint = 0 ");
            buffer.append("AND").append(' ');
            buffer.append("i.type<>3 and i.name is not null ");
            buffer.append("union select i.name, i.index_id, ");
            buffer.append("i.type,i.type_desc,i.is_primary_key,i.is_unique_constraint,i.is_unique, ");
            buffer.append("i.ignore_dup_key,i.fill_factor,i.is_padded,i.allow_row_locks, i.allow_page_locks, ");
            buffer.append("i.data_space_id,ds.name ds_name,ds.type ds_type,s.no_recompute AS [NoAutomaticRecomputation]  ");
            buffer.append("from sys.xml_indexes i INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ");
            buffer.append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND ");
            buffer.append("s.object_id = i.object_id ");
            buffer.append("where  i.object_id = ").append(tableId).append(' ');
            buffer.append("and i.is_primary_key = 0 ");
            buffer.append("and i.is_unique_constraint = 0 ");
            buffer.append("and i.using_xml_index_id is null ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initIndexes():", e);
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String indId = rs.getString(2);
                String indTypeDesc = rs.getString(4);
                String unique = rs.getString(7);
                String ignoreDupKeys = rs.getString(8);
                int fillFactor = rs.getInt(9);
                String isPadIndex = rs.getString(10);
                String allow_row_locks = rs.getString(11);
                String allow_page_locks = rs.getString(12);
                String ds_name = rs.getString(14);
                String ds_type = rs.getString(15);
                String statsNoRecompute = rs.getString(16);
                if (name != null) {
                    Properties props = new Properties();
                    props.setProperty("name", name);
                    props.setProperty("indId", indId);
                    props.setProperty("indTypeDesc", indTypeDesc);
                    props.setProperty("unique", unique);
                    props.setProperty("ignoreDupKeys", ignoreDupKeys);
                    props.setProperty("fillFactor", String.valueOf(fillFactor));
                    props.setProperty("isPadIndex", isPadIndex);
                    props.setProperty("allow_row_locks", allow_row_locks);
                    props.setProperty("allow_page_locks", allow_page_locks);
                    props.setProperty("ds_name", ds_name);
                    props.setProperty("ds_type", ds_type);
                    props.setProperty("statsNoRecompute", statsNoRecompute != null ? statsNoRecompute : "");
                    list.add(props);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
        }
        if (statement != null) {
            statement.close();
        }
        for (Properties props : list) {
            String name = props.getProperty("name");
            String indId = props.getProperty("indId");
            String indTypeDesc = props.getProperty("indTypeDesc");
            String unique = props.getProperty("unique");
            String ignoreDupKeys = props.getProperty("ignoreDupKeys");
            int fillFactor = Integer.parseInt(props.getProperty("fillFactor"));
            String isPadIndex = props.getProperty("isPadIndex");
            String allow_row_locks = props.getProperty("allow_row_locks");
            String allow_page_locks = props.getProperty("allow_page_locks");
            String ds_name = props.getProperty("ds_name");
            String ds_type = props.getProperty("ds_type");
            String statsNoRecompute = props.getProperty("statsNoRecompute");
            Index index = table.createIndex();
            index.setName(name);
            this.stampModelObject((ModelObject)index, dboSchema, name);
            if ("1".equalsIgnoreCase(unique)) {
                index.setIndexState("Unique Plain Index");
            }
            this.initKeyColumns(index, table, tableId, indId, db, sqlConnection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesign storage = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storage = (StorageDesignSqlServer)storageDesign;
            }
            if (storage != null) {
                IndexProxySqlServerv2k12 proxy = (IndexProxySqlServerv2k12)storage.getIndexProxySet().getProxy(index.getObjectID());
                if (proxy != null) {
                    PartitionSchemeSqlServerv2k5 partSchema;
                    if (indTypeDesc.indexOf("NONCLUSTERED") > -1) {
                        proxy.setClustered(false);
                    } else if (indTypeDesc.indexOf("CLUSTERED") > -1) {
                        proxy.setClustered(true);
                    } else {
                        proxy.setClustered(false);
                    }
                    if (indTypeDesc.indexOf("COLUMNSTORE") > -1) {
                        proxy.setColumnstoreIndex(true);
                    } else {
                        proxy.setColumnstoreIndex(false);
                    }
                    proxy.setFillFactor(fillFactor);
                    if ("1".equalsIgnoreCase(statsNoRecompute)) {
                        proxy.setRecomputeStatistics("ON");
                    } else {
                        proxy.setRecomputeStatistics("OFF");
                    }
                    proxy.setIgnoreDupKey(ignoreDupKeys);
                    if ("1".equalsIgnoreCase(isPadIndex)) {
                        proxy.setPadIndex("YES");
                    } else {
                        proxy.setPadIndex("NO");
                    }
                    DataBaseSqlServer database = (DataBaseSqlServer)((StorageDesignSqlServer)storage).getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = ((StorageDesignSqlServer)storage).getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    if (ds_type.equalsIgnoreCase("FG")) {
                        FileGroupSqlServer group = (FileGroupSqlServer)database.getFilegroups().getByName(ds_name);
                        if (group == null) {
                            group = ((StorageDesignSqlServer)storage).getFileGroupSet().createFileGroup();
                            group.setName(ds_name);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, proxy, ds_name);
                        }
                        proxy.setFilegroup(group);
                    }
                    if (ds_type.equalsIgnoreCase("PS") && (partSchema = this.getPartitionSchemaByName(ds_name, database)) != null) {
                        proxy.setPartitionScheme(partSchema);
                    }
                    if (proxy.isPrimaryXmlIndex()) {
                        this.initSecondaryXMLIndex(sqlConnection, db, tableId, indId, proxy);
                    }
                    if ("0".equals(allow_page_locks)) {
                        proxy.setAllowPageLocks("OFF");
                    }
                    if ("0".equals(allow_row_locks)) {
                        proxy.setAllowRowLocks("OFF");
                    }
                    this.initIncludeColumns(sqlConnection, db, tableId, indId, table, proxy);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
        }
    }

    @Override
    protected void initUniqueKeys(Connection sqlConnection, Table table, String tableId, String db, String dboSchema) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHTableSQLServerv2k12.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("i").append('.');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("index_id ");
            buffer.append(',').append(' ');
            buffer.append("i").append('.');
            buffer.append("TYPE").append(' ');
            buffer.append(',').append(' ');
            buffer.append("i.type_desc,is_primary_key,is_unique_constraint,is_unique, ");
            buffer.append("ignore_dup_key,fill_factor,is_padded,allow_row_locks,allow_page_locks, ");
            buffer.append("i.data_space_id,ds.name ds_name,ds.type ds_type,s.no_recompute AS [NoAutomaticRecomputation] ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.indexes i").append(' ');
            buffer.append("INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ").append(' ');
            buffer.append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND s.object_id = i.object_id ");
            buffer.append("WHERE").append(' ');
            buffer.append("i.object_id").append(' ').append('=').append(' ').append(tableId).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("(is_primary_key = 1 or is_unique_constraint = 1)");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableSqlServer.initUniqueKeys():", e);
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String indId = rs.getString(2);
                String indTypeDesc = rs.getString(4);
                String xtype = rs.getString(5);
                int fillFactor = rs.getInt(9);
                String is_padded = rs.getString(10);
                String allow_row_locks = rs.getString(11);
                String allow_page_locks = rs.getString(12);
                String ds_name = rs.getString(14);
                String ds_type = rs.getString(15);
                String StatRecompute = rs.getString(16);
                Properties props = new Properties();
                props.setProperty("name", name);
                props.setProperty("indId", indId);
                props.setProperty("indTypeDesc", indTypeDesc);
                props.setProperty("xtype", xtype);
                props.setProperty("fillFactor", String.valueOf(fillFactor));
                props.setProperty("is_padded", is_padded);
                props.setProperty("allow_row_locks", allow_row_locks);
                props.setProperty("allow_page_locks", allow_page_locks);
                props.setProperty("ds_name", ds_name);
                props.setProperty("ds_type", ds_type);
                props.setProperty("StatRecompute", StatRecompute != null ? StatRecompute : "");
                list.add(props);
            }
        }
        for (Properties props : list) {
            PartitionSchemeSqlServerv2k5 partSchema;
            FileGroupSqlServer group;
            DataBaseSqlServer database;
            IndexProxy proxy;
            String name = props.getProperty("name");
            String indId = props.getProperty("indId");
            String indTypeDesc = props.getProperty("indTypeDesc");
            String xtype = props.getProperty("xtype");
            int fillFactor = Integer.parseInt(props.getProperty("fillFactor"));
            String is_padded = props.getProperty("is_padded");
            String allow_row_locks = props.getProperty("allow_row_locks");
            String allow_page_locks = props.getProperty("allow_page_locks");
            String ds_name = props.getProperty("ds_name");
            String ds_type = props.getProperty("ds_type");
            String StatRecompute = props.getProperty("StatRecompute");
            Index key = table.createIndex();
            key.setName(name);
            this.stampModelObject((ModelObject)key, dboSchema, name);
            this.initKeyColumns(key, table, tableId, indId, db, sqlConnection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesignSqlServer storage = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storage = (StorageDesignSqlServer)storageDesign;
            }
            if ("1".equalsIgnoreCase(xtype)) {
                key.setIndexState("Primary Constraint");
                if (storage != null) {
                    proxy = (PKProxySqlServerv2k5)storage.getPKProxySet().getProxy(key.getObjectID());
                    if (proxy != null) {
                        if (indTypeDesc.indexOf("NONCLUSTERED") > -1) {
                            proxy.setClustered(false);
                        } else if (indTypeDesc.indexOf("CLUSTERED") > -1) {
                            proxy.setClustered(true);
                        } else {
                            proxy.setClustered(false);
                        }
                        ((PKProxySqlServerv2k5)proxy).setFillFactor(fillFactor);
                        database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                        if (database == null) {
                            database = storage.getDataBaseSet().createDataBase();
                            database.setName(db);
                            this.stampModelObject((ModelObject)database, "", db);
                        }
                        if (ds_type.equalsIgnoreCase("FG")) {
                            group = (FileGroupSqlServer)database.getFilegroups().getByName(ds_name);
                            if (group == null) {
                                group = storage.getFileGroupSet().createFileGroup();
                                group.setName(ds_name);
                                group.setDataBase(database);
                                this.stampModelObject((ModelObject)group, proxy, ds_name);
                            }
                            ((PKProxySqlServer)proxy).setFilegroup(group);
                        }
                        if (ds_type.equalsIgnoreCase("PS") && (partSchema = this.getPartitionSchemaByName(ds_name, database)) != null) {
                            ((PKProxySqlServerv2k5)proxy).setPartitionScheme(partSchema);
                        }
                        if ("0".equals(allow_page_locks)) {
                            ((PKProxySqlServerv2k5)proxy).setAllowPageLocks("OFF");
                        }
                        if ("0".equals(allow_row_locks)) {
                            ((PKProxySqlServerv2k5)proxy).setAllowRowLocks("OFF");
                        }
                        if ("1".equals(is_padded)) {
                            ((PKProxySqlServerv2k5)proxy).setPadIndex("YES");
                        }
                        if (!"0".equals(StatRecompute)) continue;
                        ((PKProxySqlServerv2k5)proxy).setRecomputeStatistics("NO");
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            key.setIndexState("Unique Constraint");
            if (storage != null) {
                proxy = (UniqueProxySqlServerv2k5)storage.getUniqueProxySet().getProxy(key.getObjectID());
                if (proxy != null) {
                    if (indTypeDesc.indexOf("NONCLUSTERED") > -1) {
                        proxy.setClustered(false);
                    } else if (indTypeDesc.indexOf("CLUSTERED") > -1) {
                        proxy.setClustered(true);
                    } else {
                        proxy.setClustered(false);
                    }
                    ((UniqueProxySqlServerv2k5)proxy).setFillFactor(fillFactor);
                    database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    if (ds_type.equalsIgnoreCase("FG")) {
                        group = (FileGroupSqlServer)database.getFilegroups().getByName(ds_name);
                        if (group == null) {
                            group = storage.getFileGroupSet().createFileGroup();
                            group.setName(ds_name);
                            group.setDataBase(database);
                            this.stampModelObject((ModelObject)group, proxy, ds_name);
                        }
                        ((UniqueProxySqlServer)proxy).setFilegroup(group);
                    }
                    if (ds_type.equalsIgnoreCase("PS") && (partSchema = this.getPartitionSchemaByName(ds_name, database)) != null) {
                        ((UniqueProxySqlServerv2k5)proxy).setPartitionScheme(partSchema);
                    }
                    if ("0".equals(allow_page_locks)) {
                        ((UniqueProxySqlServerv2k5)proxy).setAllowPageLocks("OFF");
                    }
                    if ("0".equals(allow_row_locks)) {
                        ((UniqueProxySqlServerv2k5)proxy).setAllowRowLocks("OFF");
                    }
                    if ("1".equals(is_padded)) {
                        ((UniqueProxySqlServerv2k5)proxy).setPadIndex("YES");
                    }
                    if (!"0".equals(StatRecompute)) continue;
                    ((UniqueProxySqlServerv2k5)proxy).setRecomputeStatistics("NO");
                    continue;
                }
                LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                continue;
            }
            LOGGER.error("Unable to find Storage Design!");
        }
        if (statement != null) {
            statement.close();
        }
    }
}

