/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSensitiveTypeOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SENSITIVE TYPE";
    protected boolean dbaUser;
    private static final Logger LOGGER = new Logger(MOHSensitiveTypeOracle.class);

    public MOHSensitiveTypeOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        if (this.dbaUser) {
            try {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignOraclev12c) {
                    boolean found = false;
                    Statement statement = sqlConnection.createStatement();
                    Statement column_statement = null;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("NAME").append(',').append(' ');
                    buffer.append("USER_COMMENT").append(' ');
                    buffer.append("FROM").append(' ').append("DBA_SENSITIVE_COLUMN_TYPES");
                    String sql = buffer.toString();
                    ResultSet rs = statement.executeQuery(sql);
                    if (rs != null) {
                        while (rs.next()) {
                            String name = rs.getString(1);
                            String comment = rs.getString(2);
                            SensitiveType sensitiveType = (SensitiveType)storageDesign.getAppView().getSensitiveTypeSet().getByName(name);
                            if (sensitiveType == null) {
                                sensitiveType = storageDesign.getAppView().getSensitiveTypeSet().createSensitiveType();
                                sensitiveType.setName(name);
                            }
                            if (comment != null && !"".equalsIgnoreCase(comment)) {
                                sensitiveType.setDescription(comment);
                            }
                            found = true;
                            if (column_statement == null) {
                                buffer = new StringBuffer();
                                buffer.append("SELECT").append(' ').append("SCHEMA_NAME").append(',').append(' ');
                                buffer.append("TABLE_NAME").append(',').append(' ');
                                buffer.append("COLUMN_NAME").append(',').append(' ');
                                buffer.append("USER_COMMENT").append(' ');
                                buffer.append("FROM").append(' ').append("DBA_SENSITIVE_DATA").append(' ');
                                buffer.append("WHERE").append(' ').append("SENSITIVE_TYPE").append(' ').append('=').append(' ').append('?').append(' ');
                                String csql = buffer.toString();
                                column_statement = sqlConnection.prepareStatement(csql);
                            }
                            column_statement.setString(1, name);
                            ResultSet rsColumns = column_statement.executeQuery();
                            if (rsColumns == null) continue;
                            while (rsColumns.next()) {
                                Column column;
                                String schemaName = rsColumns.getString(1);
                                String tableName = rsColumns.getString(2);
                                String columnName = rsColumns.getString(3);
                                String sensitiveDesc = rsColumns.getString(4);
                                Table table = null;
                                table = schemaName != null && !"".equalsIgnoreCase(schemaName) ? storageDesign.getPhysicalDesign().getTableSet().getBySchemaAndName(schemaName, tableName) : (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(tableName);
                                if (table == null || (column = (Column)table.getElementByName(columnName)) == null) continue;
                                column.setSensitiveType(sensitiveType);
                                column.setContainsSensitiveInformation(Boolean.TRUE);
                                if (sensitiveDesc == null || "".equalsIgnoreCase(sensitiveDesc)) continue;
                                column.setSensitiveTypeDescription(sensitiveDesc);
                            }
                            rsColumns.close();
                        }
                        rs.close();
                    }
                    if (column_statement != null) {
                        column_statement.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (found) {
                        storageDesign.getAppView().saveSensitiveTypes();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("MOHSensitiveTypeOracle.generate():", e);
            }
        }
    }
}

