/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.headless;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import javax.ide.util.MetaClass;
import oracle.dbtools.crest.headless.DDLCommandProcessor;
import oracle.dbtools.crest.headless.DMReportsCommandProcessor;
import oracle.dbtools.crest.headless.HeadlessResources;
import oracle.dbtools.crest.headless.HeadlessStarter;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ide.cmd.ExitCommand;

public class HeadlessRunner
extends IdeRunner {
    public static final String COMMAND_DDL = "ddl";
    public static final String COMMAND_DM_REPORTS = "dmreports";
    private static Map<String, CommandDefinition> s_cmds = new TreeMap<String, CommandDefinition>();
    private DefaultHeadlessCore m_core = new DefaultHeadlessCore();

    private MetaClass<? extends HeadlessCommandProcessor> getMetaClassFor(Class cls) {
        return new MetaClass(cls.getClassLoader(), cls.getName());
    }

    private void addCommandDefinitions() {
        CommandDefinition cdDDL = new CommandDefinition(COMMAND_DDL, HeadlessResources.getString("DDL_COMMAND_DESC"), this.getMetaClassFor(DDLCommandProcessor.class));
        s_cmds.put(cdDDL.getCommandID(), cdDDL);
        CommandDefinition cdDMReports = new CommandDefinition(COMMAND_DM_REPORTS, HeadlessResources.getString("DDL_COMMAND_DESC"), this.getMetaClassFor(DMReportsCommandProcessor.class));
        s_cmds.put(cdDMReports.getCommandID(), cdDMReports);
    }

    public void runCommand(IdeStarter starter) {
        if (Extension.isDataModeler()) {
            this.printMessage(HeadlessResources.format("PRODUCT_VERSION", Extension.getBuildVersion()));
            this.printMessage(HeadlessResources.getString("PRODUCT_COPYRIGHT"));
            this.printMessage("");
        }
        this.addCommandDefinitions();
        HeadlessStarter headless = (HeadlessStarter)starter;
        String cmd = headless.getCommand();
        String[] args = headless.getArguments();
        if (cmd == null || cmd.toUpperCase().equals("HELP") || cmd.toUpperCase().equals("-HELP") || cmd.equals("?") || cmd.equals("-?")) {
            if (args == null || args.length == 0) {
                this.exit(false, this.getUsageLines(HeadlessResources.getString("COMMAND_HELP_LIST")));
            } else {
                CommandDefinition def = s_cmds.get(args[0]);
                if (def == null) {
                    this.exit(true, this.getUsageLines(HeadlessResources.format("COMMAND_NOT_FOUND", cmd)));
                } else {
                    HeadlessCommandProcessor processor = null;
                    try {
                        processor = def.createCommand();
                        this.exit(false, processor.getUsageString());
                    }
                    catch (Throwable e) {
                        if (e instanceof ThreadDeath) {
                            throw (ThreadDeath)e;
                        }
                        this.exit(true, HeadlessResources.format("COMMAND_NOT_CREATED", cmd));
                    }
                }
            }
        } else {
            CommandDefinition def = s_cmds.get(cmd);
            if (def == null) {
                this.exit(true, this.getUsageLines(HeadlessResources.format("COMMAND_NOT_FOUND", cmd)));
            }
            HeadlessCommandProcessor processor = null;
            try {
                processor = def.createCommand();
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                this.exit(true, HeadlessResources.format("COMMAND_NOT_CREATED", cmd));
            }
            try {
                HeadlessCoreWrapper core = new HeadlessCoreWrapper(this.m_core);
                HeadlessTask task = processor.parseCommandArguments((HeadlessCore)core, args);
                if (task != null) {
                    core.setOutputEnabled(false);
                    RaptorTaskDescriptor desc = task.getDescriptor();
                    desc.addListener((IRaptorTaskListener)new HeadlessTaskListener());
                    RaptorTaskManager.getInstance().addTask((RaptorTask)task);
                } else {
                    this.exit(false, HeadlessResources.getString("MESSAGE_SUCCESS"));
                }
            }
            catch (InvalidCommandArgumentException e) {
                this.exit(true, e.getLocalizedMessage());
            }
        }
    }

    private String[] getUsageLines(String initialMsg) {
        String[] lines = new String[s_cmds.size() + 1];
        lines[0] = initialMsg;
        int i = 1;
        for (CommandDefinition def : s_cmds.values()) {
            lines[i++] = HeadlessResources.format("COMMAND_USAGE_FORMAT", def.getCommandID(), def.getDescription());
        }
        return lines;
    }

    private void exit(boolean isError, String ... lines) {
        ExitCommand.shutdown();
        if (isError) {
            this.m_core.printErrorMessage(lines);
            System.exit(1);
        } else {
            this.m_core.printMessage(lines);
            System.exit(0);
        }
    }

    private void printMessage(String ... lines) {
        this.m_core.printMessage(lines);
    }

    private static final class DefaultHeadlessCore
    extends HeadlessCore {
        PrintWriter m_out = new PrintWriter(System.out);
        PrintWriter m_err = new PrintWriter(System.out);

        private DefaultHeadlessCore() {
        }

        public boolean isOutputEnabled() {
            return true;
        }

        protected PrintWriter getOutputWriter() {
            return this.m_out;
        }

        protected PrintWriter getErrorWriter() {
            return this.m_err;
        }
    }

    private static class CommandDefinition {
        private String m_id;
        private String m_desc;
        private MetaClass<? extends HeadlessCommandProcessor> m_class;

        private CommandDefinition(String id, String desc, MetaClass<? extends HeadlessCommandProcessor> cls) {
            this.m_id = id;
            this.m_desc = desc;
            this.m_class = cls;
        }

        HeadlessCommandProcessor createCommand() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            return (HeadlessCommandProcessor)this.m_class.newInstance();
        }

        String getCommandID() {
            return this.m_id;
        }

        String getDescription() {
            return this.m_desc;
        }
    }

    private static final class HeadlessCoreWrapper
    extends HeadlessCore {
        private DefaultHeadlessCore m_core;
        private boolean m_enabled = true;

        HeadlessCoreWrapper(DefaultHeadlessCore core) {
            this.m_core = core;
        }

        void setOutputEnabled(boolean enabled) {
            this.m_enabled = enabled;
        }

        public boolean isOutputEnabled() {
            return this.m_enabled;
        }

        protected PrintWriter getOutputWriter() {
            return this.m_core.m_out;
        }

        protected PrintWriter getErrorWriter() {
            return this.m_core.m_err;
        }
    }

    private class HeadlessTaskListener
    extends RaptorTaskAdapter {
        private HeadlessTaskListener() {
        }

        public void taskFailed(RaptorTaskEvent event) {
            StringWriter writer = new StringWriter();
            Throwable t = event.getThrowable();
            if (t != null) {
                t.printStackTrace(new PrintWriter(writer));
            }
            HeadlessRunner.this.exit(true, HeadlessResources.getString("MESSAGE_FAILURE"), writer.getBuffer().toString());
        }

        public void taskFinished(RaptorTaskEvent event) {
            HeadlessRunner.this.exit(false, HeadlessResources.getString("MESSAGE_SUCCESS"));
        }

        public void messageChanged(RaptorTaskEvent event) {
            RaptorTaskDescriptor desc = event.getTaskDescriptor();
            String msg = desc.getMessage();
            HeadlessRunner.this.m_core.printMessage(new String[]{msg});
        }

        public void progressChanged(RaptorTaskEvent event) {
        }
    }
}

