/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListController;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;

public abstract class DataModelerChangeListWindow
extends ChangeListWindow {
    protected boolean first = true;

    public String getTitleName() {
        if (!Extension.isDataModeler()) {
            return Messages.getString("DataModelerChangeListWindow.PendingChangesExtension");
        }
        return Messages.getString("DataModelerChangeListWindow.PendingChanges");
    }

    public DataModelerChangeListWindow(ChangeList[] changeLists, String viewId) {
        super(changeLists, viewId);
    }

    protected void initialize() {
        super.initialize();
    }

    public void postInitialization() {
        if (this.isVisible()) {
            this.refresh();
            this.first = false;
        } else {
            this.first = true;
        }
    }

    public void activate() {
        super.activate();
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        if (this.isVisible() && this.first) {
            this.refresh();
            this.first = false;
        }
    }

    public void refresh() {
        super.refresh();
    }

    protected Controller createController() {
        return new CtrlA_Controller();
    }

    class CtrlA_Controller
    extends ChangeListController {
        CtrlA_Controller() {
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 22) {
                action.setEnabled(false);
                return true;
            }
            if (context.getView() instanceof ChangeListWindow && cmdId == 51) {
                action.setEnabled(!((ChangeListWindow)context.getView()).getContextChangeList().isBusy());
                return true;
            }
            return super.update(action, context);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 22) {
                action.setEnabled(false);
                return true;
            }
            if (context.getView() instanceof ChangeListWindow && cmdId == 51) {
                if (DataModelerChangeListWindow.this.authenticate()) {
                    ((ChangeListWindow)context.getView()).getContextChangeList().refresh();
                }
                return true;
            }
            return super.handleEvent(action, context);
        }
    }

    public class VersioningTreeNodeSelectionChange
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath newPath = e.getNewLeadSelectionPath();
            DefaultMutableTreeNode newNode = null;
            IdeAction actionSVNCompareLastLocal = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareLastLocalCommand"));
            IdeAction actionSVNTextCompareLastLocal = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLastLocalCommand"));
            IdeAction actionSVNOperationCompareLatest = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.compare-latest"));
            IdeAction actionSVNTextCompareLatest = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLatestCommand"));
            IdeAction actionSVNVersionHistory = IdeAction.get((int)Ide.findOrCreateCmdID((String)"DataModelingAddin.VersionHistory"));
            if (newPath != null) {
                newNode = (DefaultMutableTreeNode)newPath.getLastPathComponent();
            }
            if (newNode != null) {
                File currentFile = ((VersioningTreeNode)newNode).getFilePath();
                StorableObjectStatus storableObjectStatus = ((VersioningTreeNode)newNode).getStorableObjectStatus();
                if (currentFile.isDirectory() || storableObjectStatus == null) {
                    if (actionSVNCompareLastLocal != null) {
                        actionSVNCompareLastLocal.setEnabled(false);
                    }
                    if (actionSVNTextCompareLastLocal != null) {
                        actionSVNTextCompareLastLocal.setEnabled(false);
                    }
                    if (actionSVNOperationCompareLatest != null) {
                        actionSVNOperationCompareLatest.setEnabled(false);
                    }
                    if (actionSVNTextCompareLatest != null) {
                        actionSVNTextCompareLatest.setEnabled(false);
                    }
                    if (actionSVNVersionHistory != null) {
                        actionSVNVersionHistory.setEnabled(false);
                    }
                } else {
                    if (actionSVNCompareLastLocal != null) {
                        actionSVNCompareLastLocal.setEnabled(true);
                    }
                    if (actionSVNTextCompareLastLocal != null) {
                        actionSVNTextCompareLastLocal.setEnabled(true);
                    }
                    if (actionSVNOperationCompareLatest != null) {
                        actionSVNOperationCompareLatest.setEnabled(true);
                    }
                    if (actionSVNTextCompareLatest != null) {
                        actionSVNTextCompareLatest.setEnabled(true);
                    }
                    if (actionSVNVersionHistory != null) {
                        actionSVNVersionHistory.setEnabled(true);
                    }
                }
            }
        }
    }
}

