/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChangeListTreePanel;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.UpdateableAction;
import oracle.dbtools.crest.fcp.vcs.svn.DataModelerChangeListScopeComboBoxRenderer;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNIncomingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.svn.SVNUnversionedFilesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOSGiController;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNAddPropertyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNResloveUpdateConflict;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionHistoryCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.vop.BaseVersionOperationPanel;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public abstract class DataModelerChangeList
extends AsynchronousChangeList {
    private static final Logger LOGGER = new Logger(DataModelerChangeList.class);
    protected IChangeListPanel panel;
    protected DataModelerChangeListWindow window;
    protected DataModelerChangeList dependantChangeList;
    protected DataModelerChangeList secondDependantChangeList;
    protected boolean autoRefreshDependantChangeList;
    protected boolean autoRefreshSecondDependantChangeList;
    protected boolean refreshWhenNotVisible;
    protected JPopupMenu popupMenu;
    protected static final JComboBox scopeComboBox = DataModelerChangeList.createScopeComboBox();
    protected static Color defaultScopeComboBoxForeground = scopeComboBox.getForeground();
    public static final String OPENING_BRACKET_CONFLICTS = " (";
    public static final String CLOSING_BRACKET_CONFLICTS = ")";
    public static final String OPENING_SQ_BRACKET = " [";
    public static final String CLOSING_SQ_BRACKET = "]";
    public static final String SYSTEM_TYPES = "System Types";
    boolean versionedOnly = true;
    boolean dataModelerChangesTimerTaskUpdatable = true;

    public DataModelerChangeList(String modeId) {
        super((Object)modeId);
        this.addScopeComboBoxListener();
        BaseVersionOperationPanel panel = (BaseVersionOperationPanel)this.createChangeListPanel();
        this.initializeVersionOperationPanel(panel);
        this.layoutPanel(panel);
        this.installPopupMenu();
    }

    protected IChangeListPanel createChangeListPanel() {
        this.panel = new ChangeListTreePanel(this);
        return this.panel;
    }

    protected void installPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.addActions();
        IdeAction defaultCompareAction = this.addCompareActions();
        if (this.isHaveResolveConflictItem()) {
            this.popupMenu.add(new JMenuItem(SVNResloveUpdateConflict.getResolveAction(this, SVNResloveUpdateConflict.RESOLVE_TREE_CONFLICT)));
            this.popupMenu.add(new JMenuItem(SVNResloveUpdateConflict.getResolveAction(this, SVNResloveUpdateConflict.RESOLVE_CONFLICT)));
            this.popupMenu.add(new JMenuItem(SVNResloveUpdateConflict.getResolveAction(this, SVNResloveUpdateConflict.RESOLVE_CONFLICT_AS_TEXT)));
        }
        this.addAdditionalActions();
        this.addPopupMenu(this.getPanel(), this.popupMenu, defaultCompareAction);
    }

    public void addPopupMenu(final IChangeListPanel changeListPanel, final JPopupMenu popupMenu, final IdeAction defaultAction) {
        changeListPanel.getUnderlyingComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && changeListPanel.hasSelection()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DataModelerChangeList.this.updateActions(popupMenu);
                if (e.isPopupTrigger() && changeListPanel.hasSelection()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        if (defaultAction != null && defaultAction.isEnabled()) {
                            defaultAction.performAction();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn(ex);
                    }
                }
            }
        });
    }

    private void updateActions(JPopupMenu menu) {
        for (int i = 0; i < menu.getComponents().length; ++i) {
            Action action;
            Component component = menu.getComponents()[i];
            if (component instanceof JMenu) {
                this.updateActions(((JMenu)component).getPopupMenu());
                continue;
            }
            if (!(component instanceof JMenuItem) || (action = ((JMenuItem)component).getAction()) == null) continue;
            if (action instanceof IdeAction) {
                ((IdeAction)action).updateAction();
                continue;
            }
            if (!(action instanceof UpdateableAction)) continue;
            ((UpdateableAction)action).update();
        }
    }

    protected void addAdditionalActions() {
        IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"DataModelingAddin.VersionHistory"));
        if (action != null) {
            action.setCommand(SVNVersionHistoryCommand.COMMAND_ID);
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"version_history.png"));
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.viewproperties"))) != null) {
            action.setCommand(new MetaClass(Ide.class.getClassLoader(), SVNViewPropertiesCommand.COMMAND_ID));
            action.setName(Resource.get((String)"ACTION_VIEWPROPERTIES_NAME"));
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"properties.png"));
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)SVNAddPropertyCommand.COMMAND_ID))) != null) {
            action.setCommand(new MetaClass(Ide.class.getClassLoader(), SVNAddPropertyCommand.COMMAND_ID));
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"propertyadd.png"));
            action.setName(Resource.get((String)"ACTION_ADDPROPERTY_NAME"));
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand"))) != null) {
            action.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand");
            action.setName(Messages.getString("DataModelingAddin.StorableObjectProperties"));
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"file.png"));
            DMSVNOSGiController.getInstance().register(action, (Command)new StorableObjectPropertiesCommand());
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
    }

    protected abstract void addActions();

    protected abstract IdeAction addCompareActions();

    public abstract void clear();

    protected abstract ChangeListStatus[] getChangeListStatuses();

    public boolean isRefreshWhenNotVisible() {
        return this.refreshWhenNotVisible;
    }

    public void setRefreshWhenNotVisible(boolean refreshWhenNotVisible) {
        this.refreshWhenNotVisible = refreshWhenNotVisible;
    }

    public DataModelerChangeList getDependantChangeList() {
        return this.dependantChangeList;
    }

    public void setDependantChangeList(DataModelerChangeList dependantChangeList) {
        this.dependantChangeList = dependantChangeList;
    }

    public boolean isAutoRefreshDependantChangeList() {
        return this.autoRefreshDependantChangeList;
    }

    public void setAutoRefreshDependantChangeList(boolean autoRefreshDependantChangeList) {
        this.autoRefreshDependantChangeList = autoRefreshDependantChangeList;
    }

    public DataModelerChangeListWindow getWindow() {
        return this.window;
    }

    public void setWindow(DataModelerChangeListWindow window) {
        this.window = window;
    }

    protected ChangeListEventQueue createEventQueue() {
        return null;
    }

    protected void initializeChangeList() {
        this.setVisibleStatuses(this.getChangeListStatuses());
    }

    public void updateUI(List<StorableObjectStatus> statuses) {
        TimeLog.log("start getPanel().update(filterNormalStatuses(statuses));");
        List<StorableObjectStatus> recognizedStatuses = this.getPanel().update(this.filterNormalStatuses(statuses));
        TimeLog.log("end getPanel().update(filterNormalStatuses(statuses));");
        this.initializeModel();
        TimeLog.log("end initializeModel");
        MutableVersionOperationModel model = this.getModel();
        if (model != null) {
            try {
                model.remove(Arrays.asList(model.getItems()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setToolTipText("");
            if (recognizedStatuses != null && !recognizedStatuses.isEmpty()) {
                try {
                    model.add(recognizedStatuses);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TimeLog.log("start firePropertyChange");
            this.firePropertyChange("changeListCount", model.getItems().length == 0 ? 1 : 0, model.getItems().length);
        }
    }

    List<StorableObjectStatus> filterNormalStatuses(List<StorableObjectStatus> recognizedStatuses) {
        if (recognizedStatuses == null) {
            return recognizedStatuses;
        }
        ArrayList<StorableObjectStatus> filteredStatuses = new ArrayList<StorableObjectStatus>();
        for (int i = 0; i < recognizedStatuses.size(); ++i) {
            ISVNStatus isvnStatus;
            boolean statusNormal = ((SVNStorableObjectStatus)recognizedStatuses.get(i)).getTextStatus().equalsIgnoreCase(" ");
            boolean statusNotRecognized = ((SVNStorableObjectStatus)recognizedStatuses.get(i)).getTextStatus().equalsIgnoreCase("?");
            if (statusNormal || (this instanceof SVNOutgoingChangesChangeList || this instanceof SVNIncomingChangesChangeList) && !(this instanceof SVNUnversionedFilesChangeList) && statusNotRecognized || this instanceof SVNOutgoingChangesChangeList && (isvnStatus = ((SVNStorableObjectStatus)recognizedStatuses.get(i)).getISVNStatus()) != null && isvnStatus.getTextStatus() == SVNStatusKind.NORMAL && !((SVNStorableObjectStatus)recognizedStatuses.get(i)).getTextStatus().equalsIgnoreCase("A")) continue;
            filteredStatuses.add(recognizedStatuses.get(i));
        }
        return filteredStatuses;
    }

    public IChangeListPanel getPanel() {
        return this.panel;
    }

    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        this.addScopeComboBox(toolbar);
    }

    protected void addScopeComboBox(Toolbar toolbar) {
        if (toolbar.getComponentCount() > 0) {
            toolbar.add((Component)toolbar.newSeparator(), 0);
        }
        toolbar.add((Component)scopeComboBox, 0);
    }

    protected static JComboBox createScopeComboBox() {
        JComboBox scopeComboBox = new JComboBox();
        scopeComboBox.setRenderer(new DataModelerChangeListScopeComboBoxRenderer());
        Dimension d = new Dimension(SwingUtilities.computeStringWidth(scopeComboBox.getFontMetrics(scopeComboBox.getFont()), "ReasonablyLongApplicationNameWithIconIncludingItsLocation.jws"), scopeComboBox.getPreferredSize().height);
        scopeComboBox.setMaximumSize(d);
        scopeComboBox.setMinimumSize(d);
        return scopeComboBox;
    }

    protected void addScopeComboBoxListener() {
        scopeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    DataModelerChangeList.this.clear();
                } else if (e.getStateChange() == 1 && DataModelerChangeList.this.isVisible()) {
                    if (!((Design)e.getItem()).isSVNVersioned()) {
                        if (SVNClientHelper.getInstance().isVersioned(((Design)e.getItem()).getAppView().getSettings().getDefaultSystemTypesPath())) {
                            DataModelerChangeList.this.setForeground(new Color(166, 128, 100));
                        } else {
                            DataModelerChangeList.this.setForeground(defaultScopeComboBoxForeground);
                        }
                    } else {
                        DataModelerChangeList.this.setForeground(defaultScopeComboBoxForeground);
                    }
                    DataModelerChangeList.this.refresh();
                }
            }
        });
    }

    protected void startImpl() {
    }

    public JComboBox getScopeComboBox() {
        return scopeComboBox;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Design getSelectedDesign() {
        if (scopeComboBox.getItemCount() == 0) {
            Design des = ApplicationView.getInstance().getCurrentDesign();
            if (des == null || !des.isSVNVersioned() && !SVNClientHelper.getInstance().isVersioned(des.getAppView().getSettings().getDefaultSystemTypesPath())) return null;
            if (des.isSVNVersioned()) {
                if (!des.isLoading() && SVNClientHelper.getInstance().hasProperties(des)) {
                    scopeComboBox.addItem(des);
                    scopeComboBox.setSelectedItem(des);
                }
            } else {
                if (des.isLoading() || !SVNClientHelper.getInstance().isVersioned(des.getAppView().getSettings().getDefaultSystemTypesPath())) return null;
                scopeComboBox.addItem(des);
                scopeComboBox.setSelectedItem(des);
            }
        }
        Design design = (Design)scopeComboBox.getSelectedItem();
        if (scopeComboBox.getItemCount() != 1 || design == null || design.isSVNVersioned() || !StringUtilities.isEmpty(design.getAppView().getSettings().getDefaultSystemTypesPath())) return design;
        scopeComboBox.removeAllItems();
        return design;
    }

    protected JMenu createCompareWithMenu(JPopupMenu popupMenu) {
        popupMenu.addSeparator();
        JMenu compareWithMenu = new JMenu(Messages.getString("DataModelingAddin.CompareWith"));
        popupMenu.add(compareWithMenu);
        return compareWithMenu;
    }

    public boolean isVersionedOnly() {
        return this.versionedOnly;
    }

    public void setVersionedOnly(boolean versionedOnly) {
        this.versionedOnly = versionedOnly;
    }

    public DataModelerChangeList getSecondDependantChangeList() {
        return this.secondDependantChangeList;
    }

    public void setSecondDependantChangeList(DataModelerChangeList secondDependantChangeList) {
        this.secondDependantChangeList = secondDependantChangeList;
    }

    public boolean isAutoRefreshSecondDependantChangeList() {
        return this.autoRefreshSecondDependantChangeList;
    }

    public void setAutoRefreshSecondDependantChangeList(boolean autoRefreshSecondDependantChangeList) {
        this.autoRefreshSecondDependantChangeList = autoRefreshSecondDependantChangeList;
    }

    public boolean isHaveResolveConflictItem() {
        return false;
    }

    public boolean getDataModelerChangesTimerTaskUpdatable() {
        return this.dataModelerChangesTimerTaskUpdatable;
    }

    public void setDataModelerChangesTimerTaskUpdatable(boolean dataModelerChangesTimerTaskUpdatable) {
        this.dataModelerChangesTimerTaskUpdatable = dataModelerChangesTimerTaskUpdatable;
    }
}

