/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ThirdPartyJDBCDriversPreferences;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;

final class ThirdPartyJDBCDriversPP
extends AbstractPP {
    private static final long serialVersionUID = -7981976760107531787L;
    private static final String BTN_ADD = Messages.getString("OptionsDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("OptionsDialog.Remove");
    private static final String BTN_UP = Messages.getString("OptionsDialog.MoveUp");
    private static final String BTN_DOWN = Messages.getString("OptionsDialog.MoveDown");
    private DefaultListModel lmJdbcDrivers;
    private JList lsJdbcDrivers;
    private String currentJdbcDriverFolder = "";
    private JPanel driversPanel;
    private JScrollPane driversScrollPane;
    private static File lastFolder = null;

    public ThirdPartyJDBCDriversPP() {
        this.setHelpID("THIRD_PARTY_JDBC_DRIVERS_PREFS_PANEL");
        this.driversPanel = new JPanel(new GridBagLayout());
        this.driversPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ThirdPartyJDBCDrivers")));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton bnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        bnAdd.setToolTipText(BTN_ADD);
        bnAdd.addActionListener(new AddJDBCDriverAction());
        final JButton bnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        bnRemove.setToolTipText(BTN_REMOVE);
        bnRemove.addActionListener(new RemoveJDBCDriverAction());
        final JButton bnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
        bnUp.setToolTipText(BTN_UP);
        bnUp.addActionListener(new UpJDBCDriverAction());
        final JButton bnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
        bnDown.setToolTipText(BTN_DOWN);
        bnDown.addActionListener(new DownJDBCDriverAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(bnAdd);
        toolBar.add(bnRemove);
        toolBar.addSeparator();
        toolBar.add(bnUp);
        toolBar.add(bnDown);
        bnRemove.setEnabled(false);
        bnUp.setEnabled(false);
        bnDown.setEnabled(false);
        this.lmJdbcDrivers = new DefaultListModel();
        this.lsJdbcDrivers = new JList(this.lmJdbcDrivers);
        this.lsJdbcDrivers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices().length > 0) {
                    ThirdPartyJDBCDriversPP.this.currentJdbcDriverFolder = new File((String)ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedValue()).getParent();
                    bnRemove.setEnabled(true);
                    bnUp.setEnabled(true);
                    bnDown.setEnabled(true);
                } else {
                    bnRemove.setEnabled(false);
                    bnUp.setEnabled(false);
                    bnDown.setEnabled(false);
                }
            }
        });
        this.driversScrollPane = new JScrollPane(this.lsJdbcDrivers);
        this.driversPanel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.driversPanel.add((Component)this.driversScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
        this.add(this.driversPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        this.lmJdbcDrivers.clear();
        Iterator it = settings.getJDBCDrivers().iterator();
        while (it.hasNext()) {
            this.lmJdbcDrivers.addElement(it.next());
        }
        this.driversScrollPane.updateUI();
    }

    public void onExit(TraversableContext tc) {
        settings.clearJDBCDrivers();
        Enumeration enu = this.lmJdbcDrivers.elements();
        while (enu.hasMoreElements()) {
            settings.addJDBCDriver((String)enu.nextElement());
        }
        ThirdPartyJDBCDriversPreferences preferences = this.getThirdPartyJDBCDriversPreferences(tc);
        preferences.setJDBCDrivers(settings.getJDBCDrivers());
    }

    private ThirdPartyJDBCDriversPreferences getThirdPartyJDBCDriversPreferences(TraversableContext tc) {
        return ThirdPartyJDBCDriversPreferences.getInstance(tc.getPropertyStorage());
    }

    private class AddJDBCDriverAction
    implements ActionListener {
        private AddJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URLFilter driverFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".jar") || file.getName().toLowerCase().endsWith(".zip") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("OptionsDialog.JDBCDrivers");
                }
            };
            URLChooser fileChooser = DialogUtil.newURLChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(2);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(driverFilter);
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = ThirdPartyJDBCDriversPP.this.getApplicationView().getSettings().getDefaultImportPath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = ThirdPartyJDBCDriversPP.this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDrivers"));
            if (status == 0) {
                URL[] selectedFiles = fileChooser.getSelectedURLs();
                for (int i = 0; i < selectedFiles.length; ++i) {
                    File file = new File(selectedFiles[i].getPath());
                    lastFolder = file.getParentFile();
                    if (file == null || ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.contains(file.getAbsolutePath())) continue;
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.addElement(file.getAbsolutePath());
                }
            }
        }
    }

    private class RemoveJDBCDriverAction
    implements ActionListener {
        private RemoveJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices();
            if (selected.length > 0) {
                for (int i = selected.length - 1; i >= 0; --i) {
                    int pos = selected[i];
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.removeElementAt(pos);
                }
            }
        }
    }

    private class UpJDBCDriverAction
    implements ActionListener {
        private UpJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices();
            if (selected.length > 0) {
                for (int i = 0; i < selected.length; ++i) {
                    int pos = selected[i];
                    if (pos <= 0) continue;
                    Object obj = ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.getElementAt(pos);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.remove(pos);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.add(pos - 1, obj);
                    selected[i] = pos - 1;
                }
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.updateUI();
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.setSelectedIndices(selected);
            }
        }
    }

    private class DownJDBCDriverAction
    implements ActionListener {
        private DownJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices();
            if (selected.length > 0) {
                for (int i = selected.length - 1; i >= 0; --i) {
                    int pos = selected[i];
                    if (pos >= ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.getSize() - 1) continue;
                    Object obj = ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.getElementAt(pos);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.remove(pos);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.add(pos + 1, obj);
                    selected[i] = pos + 1;
                }
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.updateUI();
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.setSelectedIndices(selected);
            }
        }
    }
}

