/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.udb.MOHAliasUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHDatatypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHForeignKeyUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHOwnerUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTableUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeIncompleteUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHViewUDB;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHForeignKeyUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTableUDBv81;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class ExtractionHandlerDB2
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private List mohObjectsv7 = null;
    private List mohObjectsv8 = null;
    private ApplicationView view;

    public ExtractionHandlerDB2(ApplicationView view) {
        super(null);
        this.view = view;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
                this.dbMinorVersion = dbmd.getDatabaseMinorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public List getMOHObjects(Connection conn) {
        if (conn != null) {
            this.init(conn);
        }
        switch (this.dbMajorVersion) {
            case 7: {
                return this.getMOHObjectsv7();
            }
            case 8: {
                return this.getMOHObjectsv8();
            }
            case 9: {
                return this.getMOHObjectsv9();
            }
        }
        return this.getMOHObjectsv9();
    }

    public List getMOHObjectsv7() {
        if (this.mohObjectsv7 == null) {
            this.mohObjectsv7 = new ArrayList();
            this.mohObjectsv7.add(new MOHOwnerUDB(this));
            this.mohObjectsv7.add(new MOHTypeIncompleteUDB(this));
            this.mohObjectsv7.add(new MOHDatatypeUDB(this));
            this.mohObjectsv7.add(new MOHTypeUDB(this));
            this.mohObjectsv7.add(new MOHTableUDB(this));
            this.mohObjectsv7.add(new MOHForeignKeyUDB(this));
            this.mohObjectsv7.add(new MOHViewUDB(this));
            this.mohObjectsv7.add(new MOHAliasUDB(this));
        }
        return this.mohObjectsv7;
    }

    public List getMOHObjectsv8() {
        if (this.mohObjectsv8 == null) {
            this.mohObjectsv8 = new ArrayList();
            this.mohObjectsv8.add(new MOHOwnerUDB(this));
            this.mohObjectsv8.add(new MOHTypeIncompleteUDB(this));
            this.mohObjectsv8.add(new MOHDatatypeUDB(this));
            this.mohObjectsv8.add(new MOHTypeUDB(this));
            this.mohObjectsv8.add(new MOHTableUDBv81(this));
            this.mohObjectsv8.add(new MOHForeignKeyUDBv81(this));
            this.mohObjectsv8.add(new MOHViewUDB(this));
            this.mohObjectsv8.add(new MOHAliasUDB(this));
        }
        return this.mohObjectsv8;
    }

    public List getMOHObjectsv9() {
        return this.getMOHObjectsv8();
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv71.RDBMS_TYPE);
            }
            case 8: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
            }
            case 9: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv9.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv9.RDBMS_TYPE);
    }

    private void initSchemas(List selectedObjects) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject next : selectedObjects) {
            if (!"SCHEMA".equalsIgnoreCase(next.getType())) continue;
            list.add(next);
        }
        MOHOwnerUDB.setSchemas(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        List mhoList = this.getMOHObjects(conn);
        if (this.storageDesign == null) {
            this.storageDesign = this.view.getCurrentDesign().getRelationalDesign().getStorageDesign();
        }
        if (selectedObjects.size() > 0 && mhoList.size() > 0 && conn != null && !this.isNullStorageDesign(this.storageDesign)) {
            this.initSchemas(selectedObjects);
            try {
                int counter = 0;
                double step = 10.0;
                int size = mhoList.size();
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.generate(conn, selectedObjects, importLog);
                    moHandler.clearHandledObjects(selectedObjects);
                    ++counter;
                    monitor.setProgress((int)(step += 75.0 / (double)size));
                }
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.postGenerateProcessing(conn);
                }
            }
            catch (Exception e) {
                importLog.addError(e.getMessage());
            }
        }
    }
}

