/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSModelNamingOptions;
import oracle.dbtools.crest.exports.reports.RSNotes;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;

public class RSModel
extends RSGeneral {
    protected static void export(DesignPart model, Map map, Connection connection, String type, String rdbmsType) throws Exception {
        ArrayList<DesignPartViewPlaceHolder> list = new ArrayList<DesignPartViewPlaceHolder>(1000);
        int count = 0;
        String modelOVID = RSModel.getOrCreateOVID(map, model.getObjectID());
        String designOVID = (String)map.get(model.getDesign().getObjectID());
        String query = "INSERT INTO DMRS_MODELS (Design_ID, Design_OVID, Design_Name, Model_ID, Model_OVID, Model_Name, Model_Type, RDBMS_Type) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        stmt.setString(1, model.getDesign().getObjectID());
        stmt.setString(2, designOVID);
        stmt.setString(3, model.getDesign().getName());
        stmt.setString(4, model.getObjectID());
        stmt.setString(5, modelOVID);
        stmt.setString(6, model.getName());
        stmt.setString(7, type);
        stmt.setString(8, rdbmsType);
        stmt.executeUpdate();
        stmt.close();
        stmt = null;
        RSObjectNotes.export(map, connection, model);
        RSComments.export(map, connection, model);
        if (!type.equals("Process")) {
            RSNotes.export(map, connection, model);
        }
        RSModelNamingOptions.export(map, connection, model, modelOVID, type);
        String sub_query = "INSERT INTO DMRS_MODEL_SUBVIEWS (Subview_ID, Subview_OVID, Subview_Name, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement sub_stmt = connection.prepareStatement(sub_query);
        Iterator sub_it = model.getDesignSubviews().iterator();
        while (sub_it.hasNext()) {
            DesignPartViewPlaceHolder subview2 = (DesignPartViewPlaceHolder)sub_it.next();
            String subviewOVID = RSModel.getOrCreateOVID(map, subview2.getObjectID());
            sub_stmt.setString(1, subview2.getObjectID());
            sub_stmt.setString(2, subviewOVID);
            sub_stmt.setString(3, subview2.getName());
            sub_stmt.setString(4, model.getObjectID());
            sub_stmt.setString(5, modelOVID);
            sub_stmt.setString(6, model.getName());
            sub_stmt.setString(7, designOVID);
            sub_stmt.addBatch();
            list.add(subview2);
            if (++count != 1000) continue;
            count = 0;
            sub_stmt.executeBatch();
            for (DesignPartViewPlaceHolder subview2 : list) {
                RSObjectNotes.export(map, connection, subview2);
                RSComments.export(map, connection, subview2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            sub_stmt.executeBatch();
            for (DesignPartViewPlaceHolder subview : list) {
                RSObjectNotes.export(map, connection, subview);
                RSComments.export(map, connection, subview);
            }
            list.clear();
        }
        sub_stmt.close();
        sub_stmt = null;
        String dis_query = "INSERT INTO DMRS_MODEL_DISPLAYS (Display_ID, Display_OVID, Display_Name, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement dis_stmt = connection.prepareStatement(dis_query);
        if (model.getMainView() != null) {
            Iterator dis_it = model.getMainView().getDisplays().iterator();
            while (dis_it.hasNext()) {
                DesignPartViewPlaceHolder display2 = (DesignPartViewPlaceHolder)dis_it.next();
                String displayOVID = RSModel.getOrCreateOVID(map, display2.getObjectID());
                dis_stmt.setString(1, display2.getObjectID());
                dis_stmt.setString(2, displayOVID);
                dis_stmt.setString(3, display2.getName());
                dis_stmt.setString(4, model.getObjectID());
                dis_stmt.setString(5, modelOVID);
                dis_stmt.setString(6, model.getName());
                dis_stmt.setString(7, designOVID);
                dis_stmt.addBatch();
                list.add(display2);
                if (++count != 1000) continue;
                count = 0;
                dis_stmt.executeBatch();
                for (DesignPartViewPlaceHolder display2 : list) {
                    RSObjectNotes.export(map, connection, display2);
                    RSComments.export(map, connection, display2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            dis_stmt.executeBatch();
            for (DesignPartViewPlaceHolder display2 : list) {
                RSObjectNotes.export(map, connection, display2);
                RSComments.export(map, connection, display2);
            }
            list.clear();
        }
        dis_stmt.close();
        dis_stmt = null;
        if (type.equals("Relational")) {
            RelationalDesign relModel = (RelationalDesign)model;
            String srcQuery = "INSERT INTO DMRS_SOURCE_INFO (Source_Info_OVID, Source_Info_Type, DDL_File_Name, DDL_Path_Name, DDL_DB_Type, DataDict_Connection_Name, DataDict_Connection_Url, DataDict_DB_Type, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement srcStmt = connection.prepareStatement(srcQuery);
            count = 0;
            for (DDLFileStamp dStamp : relModel.getImportDDLFileStamps()) {
                String dInfoKey = "D" + dStamp.getFileName() + model.getObjectID();
                String dInfoOVID = RSModel.getOrCreateOVID(map, dInfoKey);
                srcStmt.setString(1, dInfoOVID);
                srcStmt.setString(2, "D");
                srcStmt.setString(3, dStamp.getFileName());
                srcStmt.setString(4, dStamp.getPathName());
                srcStmt.setString(5, dStamp.getDBTypeDisplay());
                srcStmt.setString(6, null);
                srcStmt.setString(7, null);
                srcStmt.setString(8, null);
                srcStmt.setString(9, model.getObjectID());
                srcStmt.setString(10, modelOVID);
                srcStmt.setString(11, model.getName());
                srcStmt.setString(12, designOVID);
                srcStmt.addBatch();
                ++count;
            }
            for (DBConnectionStamp bStamp : relModel.getImportConnectionStamps()) {
                String bInfoKey = "B" + bStamp.getConnName() + model.getObjectID();
                String bInfoOVID = RSModel.getOrCreateOVID(map, bInfoKey);
                srcStmt.setString(1, bInfoOVID);
                srcStmt.setString(2, "B");
                srcStmt.setString(3, null);
                srcStmt.setString(4, null);
                srcStmt.setString(5, null);
                srcStmt.setString(6, bStamp.getConnName());
                srcStmt.setString(7, bStamp.getConnUrl());
                srcStmt.setString(8, bStamp.getConnTypeDisplay());
                srcStmt.setString(9, model.getObjectID());
                srcStmt.setString(10, modelOVID);
                srcStmt.setString(11, model.getName());
                srcStmt.setString(12, designOVID);
                srcStmt.addBatch();
                ++count;
            }
            if (count > 0) {
                srcStmt.executeBatch();
            }
            srcStmt.close();
            srcStmt = null;
        }
    }
}

