/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSEvents
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Event> list = new ArrayList<Event>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_EVENTS (Event_ID, Event_OVID, Event_Name, Model_ID, Model_OVID, Model_Name, Flow_ID, Flow_OVID, Flow_Name, Event_Type, Times_When_Run, Day_Of_Week, Months, Frequency, Time_Frequency, Minute, Hour, Day_Of_Month, Quarter, Year, On_Day, At_Time, Fiscal, Text, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getEventSet().iterator();
        while (it.hasNext()) {
            Event event2 = (Event)it.next();
            String eventOVID = RSEvents.getOrCreateOVID(map, event2.getObjectID());
            Flow flow = event2.getFlow();
            stmt.setString(1, event2.getObjectID());
            stmt.setString(2, eventOVID);
            stmt.setString(3, event2.getName());
            stmt.setString(4, processModel.getObjectID());
            stmt.setString(5, (String)map.get(processModel.getObjectID()));
            stmt.setString(6, processModel.getName());
            if (flow != null) {
                stmt.setString(7, flow.getObjectID());
                stmt.setString(8, RSEvents.getOrCreateOVID(map, flow.getObjectID()));
                stmt.setString(9, flow.getName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            int type = event2.getEventType();
            if (type == 0) {
                stmt.setString(10, "Info Flow");
            } else if (type == 1) {
                stmt.setString(10, "Clock Calendar");
            } else if (type == 2) {
                stmt.setString(10, "Person");
            } else if (type == 3) {
                stmt.setString(10, "Storage");
            } else {
                stmt.setString(10, null);
            }
            int times = event2.getTimesWhenRun();
            if (times == 1) {
                stmt.setString(11, "At Open Of Business Day");
            } else if (times == 2) {
                stmt.setString(11, "At Close Of Business Day");
            } else if (times == 3) {
                stmt.setString(11, "When Convenient During Day");
            } else if (times == 4) {
                stmt.setString(11, "At Specified Time");
            } else {
                stmt.setString(11, null);
            }
            stmt.setString(12, event2.getDayOfWeek());
            stmt.setString(13, event2.getMonths());
            stmt.setInt(14, event2.getFrequency());
            stmt.setInt(15, event2.getTimeFreq());
            stmt.setInt(16, event2.getMinute());
            stmt.setInt(17, event2.getHour());
            stmt.setInt(18, event2.getDayOfMonth());
            stmt.setInt(19, event2.getQuarter());
            stmt.setInt(20, event2.getYear());
            stmt.setString(21, event2.isOnDay() ? "Y" : "N");
            stmt.setString(22, event2.isAtTime() ? "Y" : "N");
            stmt.setString(23, event2.isFiscal() ? "Y" : "N");
            stmt.setString(24, event2.getText());
            stmt.setString(25, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(event2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Event event2 : list) {
                RSObjectNotes.export(map, connection, event2);
                RSComments.export(map, connection, event2);
                RSDynamicProperties.export(design, map, connection, event2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Event event : list) {
                RSObjectNotes.export(map, connection, event);
                RSComments.export(map, connection, event);
                RSDynamicProperties.export(design, map, connection, event);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

