/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.SequenceDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSequenceDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        SequenceDB2v80 sequence = (SequenceDB2v80)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
        this.appendComment(buffer, sequence);
        this.appendCreateSequnce(buffer, sequence, prettyPrint);
        DDLFileMaker.incrementCreateSequence();
        SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 0);
        SSBSequenceDB2v80.appendLineFinisher(buffer, prettyPrint);
        if (sequence.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, sequence, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, SequenceDB2v80 sequence, boolean prettyPrint) {
        SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 0);
        SSBSequenceDB2v80.appendStringWithSpace(buffer, "COMMENT ON");
        SSBSequenceDB2v80.appendStringWithSpace(buffer, "SEQUENCE");
        SSBSequenceDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequence.getLongNameDDL()));
        SSBSequenceDB2v80.appendStringWithSpace(buffer, "IS");
        SSBSequenceDB2v80.appendString(buffer, '\'');
        SSBSequenceDB2v80.appendString(buffer, sequence.getCommentInRDBMS());
        SSBSequenceDB2v80.appendStringWithSpace(buffer, '\'');
        SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 0);
        SSBSequenceDB2v80.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendCreateSequnce(StringBuffer buffer, SequenceDB2v80 sequence, boolean prettyPrint) {
        SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 0);
        this.appendCreate(buffer);
        SSBSequenceDB2v80.appendStringWithSpace(buffer, "SEQUENCE");
        SSBSequenceDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequence.getLongNameDDL()));
        SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBSequenceDB2v80.appendStringWithSpace(buffer, "AS");
        SSBSequenceDB2v80.appendStringWithSpace(buffer, sequence.getDatatype());
        SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBSequenceDB2v80.appendStringWithSpace(buffer, "START");
        SSBSequenceDB2v80.appendStringWithSpace(buffer, "WITH");
        SSBSequenceDB2v80.appendStringWithSpace(buffer, sequence.getStartWith());
        if (sequence.getIncrementBy() != 1) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "BY");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, sequence.getIncrementBy());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "BY");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "1");
        }
        if (!"".equalsIgnoreCase(sequence.getMinValue().trim()) && !"NO".equalsIgnoreCase(sequence.getMinValue().trim())) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "MINVALUE");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, sequence.getMinValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "NO");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "MINVALUE");
        }
        if (!"".equalsIgnoreCase(sequence.getMaxValue().trim()) && !"NO".equalsIgnoreCase(sequence.getMaxValue().trim())) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "MAXVALUE");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, sequence.getMaxValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "NO");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "MAXVALUE");
        }
        if (sequence.getCycle().trim().equalsIgnoreCase("YES")) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "NO");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "CYCLE");
        }
        if (sequence.getCache() != 20) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            if (sequence.getCache() == 0) {
                SSBSequenceDB2v80.appendStringWithSpace(buffer, "NO");
                SSBSequenceDB2v80.appendStringWithSpace(buffer, "CACHE");
            } else {
                SSBSequenceDB2v80.appendStringWithSpace(buffer, "CACHE");
                SSBSequenceDB2v80.appendStringWithSpace(buffer, sequence.getCache());
            }
        }
        if (sequence.getOrder().equalsIgnoreCase("YES")) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "ORDER");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            this.appendComma(buffer);
            SSBSequenceDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "NO");
            SSBSequenceDB2v80.appendStringWithSpace(buffer, "ORDER");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SequenceDB2v80 && ((SequenceDB2v80)object).isMarkedGenerate();
    }
}

