/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.IntervalController;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALYM;
import oracle.dbtools.raptor.datatypes.objects.OraIntervalDatum;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;

public class IntervalActionControl
extends ActionControl {
    private final OraIntervalDatum _defaultValue;
    private final OraIntervalDatum _value;
    private final IntervalController _controller;
    private final boolean _showLabels;
    private final boolean _showSign;
    private final boolean _showNanos;
    private final JPanel _ui;
    protected IntervalType intervalType;

    public IntervalActionControl(String string, String string2, OraINTERVALDS oraINTERVALDS) {
        this(string, string2, oraINTERVALDS, false, true);
    }

    public IntervalActionControl(String string, String string2, OraINTERVALDS oraINTERVALDS, boolean bl, boolean bl2) {
        this(string, string2, oraINTERVALDS, bl, bl2, false);
    }

    public IntervalActionControl(String string, String string2, OraINTERVALDS oraINTERVALDS, boolean bl, boolean bl2, boolean bl3) {
        super(string, string2);
        this.intervalType = IntervalType.DS;
        this._defaultValue = oraINTERVALDS;
        this._showLabels = bl;
        this._showSign = bl2;
        this._showNanos = bl3;
        this._value = this._defaultValue != null ? (OraIntervalDatum)this._defaultValue.clone() : this.getNonNullDefaultValue();
        this._controller = new IntervalController(this._value, true);
        this._ui = new JPanel(new GridBagLayout());
        this._ui.add((Component)this._controller.getEditorPanel(this._showLabels, this._showSign, this._showNanos), LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        LayoutControl.GBC.addHSpring(this._ui, 1);
        this._value.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntervalActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    public IntervalActionControl(String string, String string2, OraINTERVALYM oraINTERVALYM) {
        this(string, string2, oraINTERVALYM, false, true);
    }

    public IntervalActionControl(String string, String string2, OraINTERVALYM oraINTERVALYM, boolean bl, boolean bl2) {
        super(string, string2);
        this.intervalType = IntervalType.YM;
        this._defaultValue = oraINTERVALYM;
        this._showLabels = bl;
        this._showSign = bl2;
        this._showNanos = true;
        this._value = this._defaultValue != null ? (OraIntervalDatum)this._defaultValue.clone() : this.getNonNullDefaultValue();
        this._controller = new IntervalController(this._value, true);
        this._ui = new JPanel(new GridBagLayout());
        this._ui.add((Component)this._controller.getEditorPanel(this._showLabels, this._showSign), LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        LayoutControl.GBC.addHSpring(this._ui, 1);
        this._value.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntervalActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.set(this._value.toString());
        return value;
    }

    @Override
    public Component getUI() {
        return this._ui;
    }

    @Override
    public void reset() {
        this.set(this._defaultValue);
    }

    @Override
    public void setEditable(boolean bl) {
        this.enableUI(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        super.enableUI(bl);
        this._controller.setEnabled(bl);
    }

    public void set(OraIntervalDatum oraIntervalDatum) {
        if (oraIntervalDatum == null) {
            this.set(this.getNonNullDefaultValue());
        } else {
            this._value.setValue(oraIntervalDatum);
        }
    }

    public OraIntervalDatum getTemporalDatum() {
        return (OraIntervalDatum)this._value.clone();
    }

    public OraIntervalDatum getNonNullDefaultValue() {
        if (this.intervalType == IntervalType.YM) {
            return OraINTERVALYM.getInstance();
        }
        return OraINTERVALDS.getInstance();
    }

    protected static enum IntervalType {
        YM,
        DS;

    }
}

