/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.TextRange;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.resource.EditorBundle;

public final class MultiFieldEdit
implements KeyListener,
FocusListener {
    private TextRange totalValidRange;
    private SortedSet<TextRange> ranges = new TreeSet<TextRange>();
    private TextBuffer buffer;
    private BasicEditorPane editor;
    private CaretL caretL = new CaretL();
    private KeyPressActionHookInvoker actionHookInvoker = new KeyPressActionHookInvoker();
    private boolean disposed = false;
    private HighlightLayer highlightLayer;
    private static HighlightStyle highlightStyle;
    private DocumentL documentL = new DocumentL();
    private TextRange currentRange;
    private boolean consumeEnter = false;
    private static final int MIN_VALID_RANGE_SIZE = 1;
    private InvalidRangeAction invalidRangeAction = InvalidRangeAction.REMOVE_RANGES;
    private static final String HIGHLIGHT_STYLE_NAME = "tab-field";
    private transient ArrayList propertyChangeListeners = new ArrayList(2);
    public static final String PROPERTY_ACTIVE = "PROPERTY_ACTIVE";
    public static final String PROPERTY_SELECT = "PROPERTY_SELECT";
    public static final String PROPERTY_RANGE_CHANGE = "PROPERTY_RANGE_CHANGE";
    public static final String PROPERTY_RANGE_CHANGE_PENDING = "PROPERTY_RANGE_CHANGE_PENDING";
    public static boolean inEditMode;
    private transient Popup tipWindow;
    private JToolTip tip;

    public MultiFieldEdit(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        this.buffer = ((BasicDocument)basicEditorPane.getDocument()).getTextBuffer();
    }

    public void setEnterIsSelect(boolean bl) {
        this.consumeEnter = bl;
    }

    public boolean getEnterIsSelect() {
        return this.consumeEnter;
    }

    public TextRange addRange(int n, int n2) {
        TextRange textRange = new TextRange(this.buffer, n, n2);
        this.ranges.add(textRange);
        return textRange;
    }

    public void removeRange(TextRange textRange) {
        this.ranges.remove(textRange);
        textRange.dispose();
    }

    public void setValidRange(int n, int n2) {
        if (this.totalValidRange != null) {
            this.totalValidRange.dispose();
        }
        this.totalValidRange = new TextRange(this.buffer, n, n2);
    }

    public synchronized void setActive(boolean bl) {
        if (bl) {
            this.start();
        } else {
            this.stop();
        }
    }

    public Collection<TextRange> getTextRanges() {
        return Collections.unmodifiableCollection(this.ranges);
    }

    private void start() {
        inEditMode = true;
        this.showTipWindow();
        if (this.disposed) {
            throw new IllegalStateException("Attempt to reactivate a disposed TextTabber");
        }
        if (this.ranges.size() < 1) {
            throw new IllegalStateException("Not enough ranges to activate TextTabber");
        }
        if (this.totalValidRange == null) {
            int n = this.editor.getDocument().getLength();
            int n2 = -1;
            for (TextRange textRange : this.ranges) {
                n = Math.min(n, textRange.getStartOffset());
                n2 = Math.max(n2, textRange.getEndOffset());
            }
            this.totalValidRange = new TextRange(this.buffer, n, n2);
        }
        for (TextRange textRange : this.ranges) {
            int n;
            if (!textRange.contains(n = this.editor.getCaretPosition())) continue;
            this.selectRange(textRange);
        }
        this.editor.addCaretListener((CaretListener)this.caretL);
        this.editor.getDocument().addDocumentListener(this.documentL);
        this.updateHighlights();
        this.editor.addPreActionInvoker((ActionPreInvoker)this.actionHookInvoker, 1.0);
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_ACTIVE, Boolean.FALSE, Boolean.TRUE));
    }

    private void stop() {
        if (this.disposed) {
            return;
        }
        if (this.ranges.size() == 1) {
            this.finishEdit();
            return;
        }
        String string = null;
        String string2 = this.currentRange.getText();
        for (TextRange textRange : this.ranges) {
            if (textRange == this.currentRange) continue;
            string = textRange.getText();
            break;
        }
        this.buffer.remove(this.currentRange.getStartOffset(), this.currentRange.getEndOffset() - this.currentRange.getStartOffset());
        this.buffer.insert(this.currentRange.getStartOffset(), string.toCharArray());
        this.editor.beginEdit(new EditDescriptor("Rename"));
        for (TextRange textRange : this.ranges) {
            this.buffer.remove(textRange.getStartOffset(), textRange.getEndOffset() - textRange.getStartOffset());
            this.buffer.insert(textRange.getStartOffset(), string2.toCharArray());
        }
        this.editor.endEdit();
        this.finishEdit();
    }

    private void finishEdit() {
        this.dispose();
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_ACTIVE, Boolean.TRUE, Boolean.FALSE));
        inEditMode = false;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.totalValidRange.dispose();
        for (TextRange textRange : this.ranges) {
            textRange.dispose();
        }
        this.ranges.clear();
        this.currentRange = null;
        this.editor.removeCaretListener((CaretListener)this.caretL);
        this.editor.getDocument().removeDocumentListener(this.documentL);
        this.removeHighlights();
        this.editor.removePreActionInvoker((ActionPreInvoker)this.actionHookInvoker, 1.0);
    }

    public void setInvalidRangeAction(InvalidRangeAction invalidRangeAction) {
        this.invalidRangeAction = invalidRangeAction;
    }

    public InvalidRangeAction getInvalidRangeAction() {
        return this.invalidRangeAction;
    }

    private void selectRange(TextRange textRange) {
        TextRange textRange2 = this.currentRange;
        this.currentRange = textRange;
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE_PENDING, textRange2, this.currentRange));
        this.editor.setCaretPosition(this.currentRange.getEndOffset());
        this.editor.moveCaretPosition(this.currentRange.getStartOffset());
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE, textRange2, this.currentRange));
    }

    private void nextRange() {
        int n = Math.min(this.editor.getSelectionStart(), this.editor.getSelectionEnd());
        TextRange textRange = null;
        for (TextRange textRange2 : this.ranges) {
            if (textRange2.getStartOffset() <= n) continue;
            textRange = textRange2;
            break;
        }
        if (textRange == null) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE_PENDING, null, null));
            this.editor.setCaretPosition(this.totalValidRange.getEndOffset() + 1);
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE, null, null));
            this.setActive(false);
            return;
        }
        this.selectRange(textRange);
    }

    private void previousRange() {
        TextRange textRange;
        int n = Math.max(this.editor.getSelectionStart(), this.editor.getSelectionEnd());
        TextRange textRange2 = null;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext() && (textRange = (TextRange)iterator.next()).getEndOffset() < n) {
            textRange2 = textRange;
        }
        if (textRange2 == null) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE_PENDING, null, null));
            this.editor.setCaretPosition(this.totalValidRange.getStartOffset());
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE, null, null));
            this.setActive(false);
            return;
        }
        this.selectRange(textRange2);
    }

    private void updateHighlights() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        } else {
            this.highlightLayer.removeAllHighlights();
        }
        for (TextRange textRange : this.ranges) {
            this.highlightLayer.addHighlight(highlightStyle, textRange.getStartOffset(), false, textRange.getEndOffset(), true);
        }
    }

    private void removeHighlights() {
        this.highlightLayer.removeAllHighlights();
        this.editor.destroyHighlightLayer(this.highlightLayer);
    }

    private void documentChanged(DocumentEvent documentEvent) {
        TreeSet<TextRange> treeSet = new TreeSet<TextRange>();
        TextRange textRange = null;
        boolean bl = false;
        for (TextRange textRange2 : this.ranges) {
            if (textRange == null) {
                textRange = textRange2;
                continue;
            }
            if (textRange2.getStartOffset() <= textRange.getEndOffset()) {
                bl = true;
                textRange2.dispose();
                textRange.dispose();
                textRange = null;
                continue;
            }
            treeSet.add(textRange);
            textRange = textRange2;
        }
        if (textRange != null) {
            treeSet.add(textRange);
        }
        this.ranges = treeSet;
        if (bl && this.invalidRangeAction == InvalidRangeAction.STOP) {
            this.setActive(false);
            return;
        }
        if (this.ranges.size() < 1) {
            this.setActive(false);
            return;
        }
        this.updateHighlights();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList(2);
        }
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners != null) {
            this.propertyChangeListeners.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        List list;
        MultiFieldEdit multiFieldEdit = this;
        synchronized (multiFieldEdit) {
            if (this.propertyChangeListeners == null) {
                return;
            }
            list = (List)this.propertyChangeListeners.clone();
        }
        for (PropertyChangeListener propertyChangeListener : list) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.totalValidRange);
        for (TextRange textRange : this.ranges) {
            stringBuilder.append("\n\t");
            stringBuilder.append(textRange);
        }
        return stringBuilder.toString();
    }

    void showTipWindow() {
        int n;
        int n2;
        Point point = this.editor.getLocationOnScreen();
        int n3 = this.editor.getCaretPosition();
        try {
            n2 = this.editor.modelToView((int)n3).x;
            n = this.editor.modelToView((int)n3).y;
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        GraphicsConfiguration graphicsConfiguration = this.editor.getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        this.tip = this.editor.createToolTip();
        this.tip.setTipText("<html>Enter new name, press <b>Enter</b> to refactor</html>");
        Dimension dimension = this.tip.getPreferredSize();
        n += point.y + dimension.height;
        if ((n2 += point.x) < rectangle.x) {
            n2 = rectangle.x;
        } else if (n2 - rectangle.x + dimension.width > rectangle.width) {
            n2 = rectangle.x + Math.max(0, rectangle.width - dimension.width);
        }
        if (n < rectangle.y) {
            n = rectangle.y;
        } else if (n - rectangle.y + dimension.height > rectangle.height) {
            n = rectangle.y + Math.max(0, rectangle.height - dimension.height);
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.tipWindow = popupFactory.getPopup((Component)this.editor, this.tip, n2, n);
        this.tipWindow.show();
        this.editor.addKeyListener((KeyListener)this);
        this.editor.addFocusListener((FocusListener)this);
    }

    void hideTipWindow() {
        this.editor.removeKeyListener((KeyListener)this);
        this.editor.removeFocusListener((FocusListener)this);
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tip = null;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.hideTipWindow();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.hideTipWindow();
    }

    static {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        highlightStyle = highlightRegistry.lookupStyle(HIGHLIGHT_STYLE_NAME);
        if (highlightStyle == null) {
            String string = EditorBundle.get((String)"TAB_FIELD_HIGHLIGHT");
            highlightStyle = highlightRegistry.createStyle(HIGHLIGHT_STYLE_NAME, string, true, 75, null, new Color(-1579033));
        }
        inEditMode = false;
    }

    private class CaretL
    implements CaretListener {
        private CaretL() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (MultiFieldEdit.this.currentRange != null && !MultiFieldEdit.this.currentRange.contains(caretEvent.getDot())) {
                for (TextRange textRange : MultiFieldEdit.this.ranges) {
                    if (!textRange.contains(caretEvent.getDot())) continue;
                    TextRange textRange2 = MultiFieldEdit.this.currentRange;
                    MultiFieldEdit.this.currentRange = textRange;
                    MultiFieldEdit.this.firePropertyChange(new PropertyChangeEvent(this, MultiFieldEdit.PROPERTY_RANGE_CHANGE, textRange2, MultiFieldEdit.this.currentRange));
                    return;
                }
                MultiFieldEdit.this.setActive(false);
            }
        }
    }

    private class KeyPressActionHookInvoker
    implements ActionPreInvoker {
        private KeyPressActionHookInvoker() {
        }

        public boolean invokeAction(String string) {
            if (string.equals("insert-tab")) {
                MultiFieldEdit.this.nextRange();
            } else if (string.equals("reverse-tab")) {
                MultiFieldEdit.this.previousRange();
            } else if (string.equals("cancel") || string.equals("insert-break")) {
                MultiFieldEdit.this.setActive(false);
            } else if (MultiFieldEdit.this.consumeEnter && string.equals("insert-break") && MultiFieldEdit.this.currentRange != null) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, MultiFieldEdit.PROPERTY_SELECT, null, MultiFieldEdit.this.currentRange);
                MultiFieldEdit.this.firePropertyChange(propertyChangeEvent);
            } else {
                return false;
            }
            return true;
        }
    }

    private class DocumentL
    implements DocumentListener {
        private DocumentL() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            MultiFieldEdit.this.documentChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            MultiFieldEdit.this.documentChanged(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            MultiFieldEdit.this.documentChanged(documentEvent);
        }
    }

    public static enum InvalidRangeAction {
        STOP,
        REMOVE_RANGES;

    }
}

