/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.util.ResourceUtils;

public class SortColumnPicker
extends JPanel
implements ListSelectionListener,
ListDataListener,
Cloneable {
    private JList lstFrom = new JList();
    private JList lstTo = new JList();
    private ListPicker pckFrom = new ListPicker(this.lstFrom);
    private ListPicker pckTo = new ReorderableListPicker(this.lstTo);
    private Shuttle shtColumns = new Shuttle();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lblFrom = new JLabel();
    private JLabel lblTo = new JLabel();
    private DBObjectRenderer renderer = new DBObjectRenderer();
    protected DefaultListModel mdlFrom = new DefaultListModel();
    protected DefaultListModel mdlTo = new DefaultListModel();
    private JRadioButton _rdbAscending = new JRadioButton();
    private JRadioButton _rdbDescending = new JRadioButton();
    private JCheckBox _cbxNullFirst = new JCheckBox();
    private ButtonGroup _bgOrder = new ButtonGroup();
    private int start;
    private int end;
    private boolean supportsOrderingNulls = true;

    public SortColumnPicker() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.start = 0;
        this.end = 0;
    }

    protected void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.shtColumns.setFromPicker((ItemPicker)this.pckFrom);
        this.shtColumns.setToPicker((ItemPicker)this.pckTo);
        this.shtColumns.add((Component)this.lblFrom, (Object)"FromHeader");
        this.shtColumns.add((Component)this.lblTo, (Object)"ToHeader");
        ResourceUtils.resLabel((JLabel)this.lblFrom, (Component)this.lstFrom, (String)CommonArb.getString("UNIQUE_LIST_AVAILABLE"));
        ResourceUtils.resLabel((JLabel)this.lblTo, (Component)this.lstTo, (String)CommonArb.getString("UNIQUE_LIST_SELECTED"));
        this.lstFrom.setCellRenderer(this.renderer);
        this.lstTo.setCellRenderer(this.renderer);
        this._rdbAscending.setText(CreateDialogArb.getString("DATAED_ASCENDING"));
        this._rdbDescending.setText(CreateDialogArb.getString("DATAED_DESCENDING"));
        this._cbxNullFirst.setText(CreateDialogArb.getString("DATAED_NULLSFIRST"));
        this._bgOrder.add(this._rdbAscending);
        this._bgOrder.add(this._rdbDescending);
        this._rdbAscending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)SortColumnPicker.this.mdlTo.get(SortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setAscending(true);
                    SortColumnPicker.this.lstTo.repaint();
                }
            }
        });
        this._rdbDescending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)SortColumnPicker.this.mdlTo.get(SortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setAscending(false);
                    SortColumnPicker.this.lstTo.repaint();
                }
            }
        });
        this._cbxNullFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SortColumnPicker.this.lstTo.getSelectedIndex() != -1) {
                    SortCol sortCol = (SortCol)SortColumnPicker.this.mdlTo.get(SortColumnPicker.this.lstTo.getSelectedIndex());
                    sortCol.setNullFirst(SortColumnPicker.this._cbxNullFirst.isSelected());
                }
            }
        });
        this.add((Component)this.shtColumns, new GridBagConstraints(0, 0, 1, 4, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._rdbAscending, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this._rdbDescending, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._cbxNullFirst, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void init(List<String> list) {
        this.mdlFrom.removeAllElements();
        this.mdlTo.removeAllElements();
        for (int i = 0; i < list.size(); ++i) {
            this.mdlFrom.addElement(new SortCol(list.get(i)));
        }
        this.lstFrom.setModel(this.mdlFrom);
        this.lstTo.setModel(this.mdlTo);
        this.lstFrom.setSelectedIndex(0);
        this.shtColumns.setEnabled(true);
        this.lstFrom.setEnabled(true);
        this.lstTo.setEnabled(true);
        this.lstTo.setSelectionMode(0);
        this.shtColumns.validate();
        this._rdbAscending.setEnabled(false);
        this._rdbDescending.setEnabled(false);
        this._cbxNullFirst.setEnabled(false);
        this.mdlTo.addListDataListener(this);
        this.lstTo.addListSelectionListener(this);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.start = listDataEvent.getIndex0();
        this.end = listDataEvent.getIndex1();
        ListSelectionModel listSelectionModel = this.lstTo.getSelectionModel();
        listSelectionModel.setSelectionInterval(this.start, this.end);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.lstTo.getSelectedIndex() == -1 && this.mdlTo.size() > 0) {
            ListSelectionModel listSelectionModel = this.lstTo.getSelectionModel();
            if (this.mdlTo.size() <= this.end) {
                this.start = this.end = this.mdlTo.size() - 1;
            }
            listSelectionModel.setSelectionInterval(this.start, this.end);
        } else {
            this.start = this.end = this.lstTo.getSelectedIndex();
        }
        this.updateSortProperties();
    }

    public void updateSortProperties() {
        int n = this.lstTo.getSelectedIndex();
        if (n == -1) {
            this._rdbAscending.setEnabled(false);
            this._rdbAscending.setSelected(false);
            this._rdbDescending.setEnabled(false);
            this._rdbDescending.setSelected(false);
            this._cbxNullFirst.setEnabled(false);
            this._cbxNullFirst.setSelected(false);
        } else if (n < this.mdlTo.getSize()) {
            SortCol sortCol = (SortCol)this.mdlTo.getElementAt(n);
            this._rdbAscending.setEnabled(true);
            this._rdbAscending.setSelected(sortCol.getAscending());
            this._rdbDescending.setEnabled(true);
            this._rdbDescending.setSelected(!sortCol.getAscending());
            if (this.isSupportsOrderingNulls()) {
                this._cbxNullFirst.setEnabled(true);
                this._cbxNullFirst.setSelected(sortCol.getNullFirst());
            }
        }
    }

    public String getOrderBy() {
        if (this.mdlTo.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            SortCol sortCol = (SortCol)this.mdlTo.get(i);
            stringBuffer.append("\"" + sortCol.getValue() + "\"");
            if (sortCol.getAscending()) {
                stringBuffer.append(" ASC");
            } else {
                stringBuffer.append(" DESC");
            }
            if (this.isSupportsOrderingNulls()) {
                if (sortCol.getNullFirst()) {
                    stringBuffer.append(" NULLS FIRST");
                    continue;
                }
                stringBuffer.append(" NULLS LAST");
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public List<SortCol> getFromList() {
        ArrayList<SortCol> arrayList = new ArrayList<SortCol>();
        for (int i = 0; i < this.mdlFrom.size(); ++i) {
            arrayList.add(new SortCol((SortCol)this.mdlFrom.get(i)));
        }
        return arrayList;
    }

    public List<SortCol> getToList() {
        ArrayList<SortCol> arrayList = new ArrayList<SortCol>();
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            arrayList.add(new SortCol((SortCol)this.mdlTo.get(i)));
        }
        return arrayList;
    }

    public void setFromList(List<SortCol> list) {
        this.mdlFrom.removeAllElements();
        for (SortCol sortCol : list) {
            this.mdlFrom.addElement(sortCol);
        }
    }

    public void setToList(List<SortCol> list) {
        this.mdlTo.removeAllElements();
        for (SortCol sortCol : list) {
            this.mdlTo.addElement(sortCol);
        }
    }

    boolean isSupportsOrderingNulls() {
        return this.supportsOrderingNulls;
    }

    void setSupportsOrderingNulls(boolean bl) {
        this.supportsOrderingNulls = bl;
    }

    public void setOrderBy(String string) {
        final ArrayList<SortCol> arrayList = new ArrayList<SortCol>();
        final List<SortCol> list = this.getFromList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            String[] stringArray = new String[stringTokenizer2.countTokens()];
            int n = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                stringArray[n] = stringTokenizer2.nextToken();
                ++n;
            }
            SortCol sortCol = new SortCol(stringArray[0].replaceAll("\"", ""));
            list.remove(sortCol);
            sortCol.setAscending(stringArray[1].equalsIgnoreCase("ASC"));
            if (stringArray.length == 4) {
                sortCol.setNullFirst(stringArray[3].equalsIgnoreCase("FIRST"));
            }
            arrayList.add(sortCol);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SortColumnPicker.this.setFromList(list);
                SortColumnPicker.this.setToList(arrayList);
            }
        });
    }

    private static class SortCol {
        private boolean _ascending;
        private boolean _nullFirst;
        private String _value;

        public SortCol(String string) {
            this._value = string;
            this._ascending = true;
            this._nullFirst = false;
        }

        public SortCol() {
        }

        public SortCol(SortCol sortCol) {
            this._value = sortCol._value;
            this._ascending = sortCol._ascending;
            this._nullFirst = sortCol._nullFirst;
        }

        public String toString() {
            if (this._value == null) {
                return "";
            }
            Object object = new String(this._value);
            object = this._ascending ? (String)object + " " + CreateDialogArb.getString("DATAED_ASC") : (String)object + " " + CreateDialogArb.getString("DATAED_DESC");
            return object;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this._ascending ? 1231 : 1237);
            n = 31 * n + (this._nullFirst ? 1231 : 1237);
            n = 31 * n + (this._value == null ? 0 : this._value.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SortCol sortCol = (SortCol)object;
            if (this._ascending != sortCol._ascending) {
                return false;
            }
            if (this._nullFirst != sortCol._nullFirst) {
                return false;
            }
            return !(this._value == null ? sortCol._value != null : !this._value.equals(sortCol._value));
        }

        public boolean getAscending() {
            return this._ascending;
        }

        public boolean getNullFirst() {
            return this._nullFirst;
        }

        public void setAscending(boolean bl) {
            this._ascending = bl;
        }

        public void setNullFirst(boolean bl) {
            this._nullFirst = bl;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }
    }
}

