/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.insight.SynonymsCache;
import oracle.dbtools.insight.UsersCache;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.InsightCache;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.VacuousConnection;
import oracle.javatools.util.Log;

public class InsightableOracleDatabase {
    static boolean debug = false;
    private static final Logger logger = Logger.getLogger(InsightableOracleDatabase.class.getName());
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List<Object> binds = new ArrayList<Object>();
    public boolean colNameOrdering = true;
    public final int minLimit = 50;
    public int limit = 50;
    UsersCache users = null;
    SynonymsCache synonyms = null;
    static Map<String, Boolean> dbaSynonymsAtConnection = new HashMap<String, Boolean>();
    private static final String USERNAME_CRITERIA = " and username like ? ";
    private static final String OBJ_TYPE_EQ_PKG = " and object_type = 'PACKAGE' ";
    private static final String OBJ_CRITERIA = " and object_name = ? ";
    private static final String PROCNAME_CRITERIA = " and procedure_name like ? ";
    private static final String VARNAME_CRITERIA = " and name like ? ";
    private static final String OWN_PKG_CRITERIA = " and (o.object_name = ? and a.package_name = ? or o.owner=?) ";
    private static final String STANDALONE_PROC_CRITERIA = " and o.object_name = ? ";
    private static final String PACKAGED_PROC_CRITERIA = " and o.object_name = ? and a.object_name = ? ";
    private boolean prepareUserTablesCalled = false;
    private boolean prepareAllTablesCalled = false;
    boolean prepareColumnsCalled = false;
    private String schema = null;
    private boolean prepareAllFunctionsCalled = false;
    private boolean prepareAllSequencesCalled = false;
    private boolean prepareAllSchemasCalled = false;
    private List<String> prefixedUsers = null;
    private boolean prepareAllPkgProcCalled = false;
    private boolean isSynonym = false;
    private boolean prepareArgumentsProcCalled = false;
    private Map<String, String> tableAliases = null;
    boolean setTableAliasesCalled = false;
    private boolean isPrefixed = false;
    public boolean excludeVirtualColumns = false;
    public boolean adjustCase = true;
    private static Map<Connection, Statement> pool = new HashMap<Connection, Statement>();
    private String prefix = null;
    private String owner = null;
    static int wrkNo = 0;
    long timeout = 500L;
    public boolean isCancellable = false;
    static boolean isRunning = false;
    public static Mode mode = Mode.UNION;

    public InsightableOracleDatabase(String string, boolean bl) {
        this.connectionName = string;
        this.colNameOrdering = bl;
        this.synonyms = (SynonymsCache)SynonymsCache.synonymsAtConnection.get(string);
        if (this.synonyms == null) {
            SynonymsCache.fillIn((String)string);
            this.synonyms = (SynonymsCache)SynonymsCache.synonymsAtConnection.get(string);
        }
        this.users = (UsersCache)UsersCache.usersAtConnection.get(string);
    }

    private int limit() {
        return this.limit;
    }

    private final String queryUserTables() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'TABLE' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.owner# = " + this.users.schema + " \nand o.name not like 'BIN%' \nand o.type# = 2 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE     object_type = 'TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryUserViews() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'VIEW' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.owner# = " + this.users.schema + " \nand o.name not like 'BIN%' \nand o.type# = 4 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE \tobject_type = 'VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryAllTables() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'TABLE' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.name not like 'BIN%' \nand o.type# = 2 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type = 'TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryAllViews() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'VIEW' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.name not like 'BIN%' \nand o.type# = 4 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String queryAllSynonyms() {
        Boolean bl = dbaSynonymsAtConnection.get(this.connectionName);
        if (bl == null) {
            Connection connection = null;
            Statement statement = null;
            boolean bl2 = false;
            try {
                connection = ChameleonConnection.getConnection((String)this.connectionName);
                if (!ChameleonConnection.isTestConnection()) {
                    bl2 = LockManager.tryLock((Connection)connection, (long)500L);
                }
                if (!bl2) {
                    bl = false;
                }
                if (bl == null) {
                    statement = connection.prepareStatement("select 1 FROM sys.DBA_OBJECTS WHERE 1=0");
                    statement.executeQuery();
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (bl2) {
                    LockManager.unlock((Connection)connection);
                }
                dbaSynonymsAtConnection.put(this.connectionName, bl);
            }
        }
        return "select 'TABLE' type, owner, object_name, null column_name, null column_id, null data_type \nFROM " + (bl != false ? " dba_objects" : " all_objects") + "\nWHERE object_name like ? and object_type = 'SYNONYM' \nand rownum <=" + this.limit() + "\n";
    }

    private final String objName() {
        return (this.users != null && this.users.isObjQueriable ? "" : "object_") + "name";
    }

    private final String OBJ_LIKE_CRITERIA() {
        return " and " + this.objName() + " like ? ";
    }

    private final String OWNER_CRITERIA() {
        if (this.users != null && this.users.isObjQueriable) {
            return " and owner# = ? ";
        }
        return " and owner = ? ";
    }

    private final String MIXED_CASE_CRITERIA() {
        return " and upper(" + this.objName() + ")!=" + this.objName() + " ";
    }

    private final String QUERY_COLUMNS_BY_OWNER_TABLE() {
        return "SELECT 'COLUMN' type, owner, table_name object_name, column_name, column_id, data_type \nFROM sys.all_tab_cols \nWHERE hidden_column = 'NO' and rownum <=" + this.limit() + " and owner = ? and table_name = ? ";
    }

    private final String QUERY_COLUMN_SEQUENCES() {
        return "SELECT 'SEQUENCE' type, USER owner,  object_name, 'NEXTVAL' column_name, null column_id, null data_type \nFROM sys.user_objects \nWHERE object_type = 'SEQUENCE' and rownum <=" + this.limit() + "  ";
    }

    private final String COLUMN_LIKE_CRITERIA() {
        return " and column_name like ? ";
    }

    private final String COLUMN_TYPE_NOT_CRITERIA() {
        return " and data_type != ? ";
    }

    private final String COLUMN_NAME_NOT_CRITERIA() {
        return " and column_name != ? ";
    }

    private final String queryProcedures(boolean bl) {
        if (this.users != null && this.users.isObjQueriable) {
            return "select case type# when 7 then 'PROCEDURE' \n               when 8 then 'FUNCTION' \n               when 9 then 'PACKAGE' \n               when 33 then 'OPERATOR' \nend type,\n ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE " + (String)(bl ? "o.owner# = " + this.users.schema + " and " : "") + "name not like 'BIN%' \nand type# in (7,8,9) \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, " + (bl ? "SYS_CONTEXT('USERENV','CURRENT_SCHEMA')" : "owner") + "  owner, object_name, null column_name, null column_id, null data_type \nFROM " + (bl ? "user" : "all") + "_objects \nWHERE rownum <=" + this.limit() + " and object_name not like 'BIN$%'  and object_type IN ('PROCEDURE','FUNCTION','PACKAGE','OPERATOR') \n";
    }

    private final String QUERY_SCHEMAS() {
        return "SELECT 'SCHEMA' type, username owner, username object_name, null column_name, null column_id, null data_type \nFROM all_users WHERE rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_PACKAGED_PROCEDURES() {
        return "SELECT 'FUNCTION' type, owner, object_name/*||'.'||procedure_name*/ object_name, /*null*/procedure_name column_name, null column_id, null data_type \nFROM all_procedures \nWHERE rownum <=" + this.limit() + " OBJ_TYPE_EQ_PKG  and procedure_name is not null \n";
    }

    private final String QUERY_PACKAGED_GLOBAL_VARIABLES() {
        return "select 'NUMBER' type, owner, object_name, name as column_name, null column_id, null data_type \nFROM all_identifiers a\n WHERE usage_context_id = 1\n   and usage = 'DECLARATION'\n   and type = 'VARIABLE'\nand object_type = 'PACKAGE' and rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_ARGUMENTS() {
        return "SELECT 'ARGUMENT' type, null owner,  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name,  a.argument_name||'=>'||substr(a.argument_name,1,1)||'/*'||a.data_type||' '||a.defaulted||'*/' column_name, a.position column_id, null data_type \nFROM all_arguments a, all_objects o \nWHERE a.object_id=o.object_id and rownum <=" + this.limit() + " and    argument_name is not null \n";
    }

    public void prepareUserTables() {
        if (this.prepareUserTablesCalled) {
            return;
        }
        this.prepareUserTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryUserTables());
        this.query.append("\n union all \n");
        this.query.append(this.queryUserViews());
    }

    public void prepareAllTables(String string, String string2) {
        if (this.users != null && string != null && this.users.getUserId(string) == null) {
            return;
        }
        if (this.prepareAllTablesCalled) {
            return;
        }
        this.prepareAllTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryAllTables());
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        this.addOwnerCriteria(string);
        this.query.append("\n union all \n");
        this.query.append(this.queryAllViews());
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        this.addOwnerCriteria(string);
        boolean bl = true;
        if (bl && string2 != null && string2.length() > 0) {
            this.query.append("\n union all \n");
            this.query.append(this.queryAllSynonyms());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string != null) {
                this.query.append(" and owner = ? ");
                this.binds.add(string);
            } else {
                this.query.append(" and owner in (SYS_CONTEXT('USERENV','CURRENT_SCHEMA') ,'PUBLIC') ");
            }
        }
    }

    private void addOwnerCriteria(String string) {
        if (string != null) {
            if (this.users != null && this.users.isObjQueriable) {
                Integer n = this.users.getUserId(string);
                if (n != null) {
                    this.query.append(this.OWNER_CRITERIA());
                    this.binds.add(n);
                } else {
                    this.query.append(" and 0 = 1 ");
                }
            } else {
                this.query.append(this.OWNER_CRITERIA());
                this.binds.add(string);
            }
        }
    }

    public void prepareColumns(String string, String string2) {
        String string3 = null;
        String string4 = null;
        List list = LexerToken.parse((String)string);
        if (list.size() != 3 || !".".equals(((LexerToken)list.get((int)1)).content)) {
            String string5;
            string4 = string;
            if (this.synonyms != null && (string5 = this.synonyms.getTable(null, string4)) != null) {
                string3 = string5.substring(0, string5.indexOf(46));
                string4 = string5.substring(string5.indexOf(46) + 1);
            }
        } else {
            List list2;
            String string6;
            string3 = ((LexerToken)list.get((int)0)).content;
            string4 = ((LexerToken)list.get((int)2)).content;
            if (this.synonyms != null && (string6 = this.synonyms.getTable(string3, string4)) != null && (list2 = LexerToken.parse((String)string6)).size() == 3) {
                string3 = ((LexerToken)list2.get((int)0)).content;
                string4 = ((LexerToken)list2.get((int)2)).content;
            }
        }
        if (string3 == null) {
            string3 = this.getCurrentSchema();
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(1));
        this.binds.add(Service.handleMixedCase((String)string3));
        this.binds.add(Service.handleMixedCase((String)string4));
        if (string2 != null && !"".equals(string2)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
        }
    }

    private String getCurrentSchema() {
        if (this.schema == null) {
            try {
                this.schema = DBUtil.getInstance((Connection)this.getConnection()).executeOracleReturnOneCol("select SYS_CONTEXT('USERENV','CURRENT_SCHEMA') current_schema FROM dual", new HashMap());
            }
            catch (Exception exception) {
                Log.error((String)("IOD.gcs():" + exception.getMessage()));
                this.schema = "N/A";
            }
        }
        if (this.schema == null) {
            Log.error((String)"IOD.gcs(): schema == null");
            this.schema = "N/A";
        }
        return this.schema;
    }

    public void prepareFQColumns(Set<String> set, String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(set.size()));
        this.setFQBinds(set, this.binds);
        if (string != null && !"".equals(string)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        }
    }

    public void excludeColTypes(List<String> list) {
        for (String string : list) {
            this.query.append(this.COLUMN_TYPE_NOT_CRITERIA());
            this.binds.add(string);
        }
    }

    public void excludeColNames(List<String> list) {
        for (String string : list) {
            this.query.append(this.COLUMN_NAME_NOT_CRITERIA());
            this.binds.add(string);
        }
    }

    public void prepareAllProcedures(String string, String string2) {
        if (this.users != null && string != null && this.users.getUserId(string) == null) {
            return;
        }
        if (this.prepareAllFunctionsCalled) {
            return;
        }
        this.prepareAllFunctionsCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryProcedures(false));
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
        }
        this.addOwnerCriteria(string);
    }

    public void prepareAllSequences(String string, boolean bl) {
        if (this.prepareAllSequencesCalled) {
            return;
        }
        this.prepareAllSequencesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_COLUMN_SEQUENCES());
        if (bl) {
            this.query.append(" and object_name like ?");
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        } else {
            this.query.append(" and object_name = ?");
            this.binds.add(Service.handleMixedCase((String)string));
        }
    }

    public void prepareAllSchemas(String string) {
        if (this.users != null) {
            this.prefixedUsers = this.users.prefixedUsers(string);
            return;
        }
        this.prefixedUsers = null;
        if (this.prepareAllSchemasCalled) {
            return;
        }
        this.prepareAllSchemasCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        Object object = this.QUERY_SCHEMAS();
        if (string != null && !"".equals(string)) {
            object = (String)object + USERNAME_CRITERIA;
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        }
        this.query.append((String)object);
    }

    public void prepareAllPkgProc(String string, String string2, String string3) {
        List list;
        String string4;
        if (this.prepareAllPkgProcCalled) {
            return;
        }
        this.prepareAllPkgProcCalled = true;
        if (this.synonyms != null && (string4 = this.synonyms.getTable(string, string2)) != null && (list = LexerToken.parse((String)string4)).size() == 3) {
            string = ((LexerToken)list.get((int)0)).content;
            string2 = ((LexerToken)list.get((int)2)).content;
            this.isSynonym = true;
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_PACKAGED_PROCEDURES());
        if (string == null) {
            string = Service.handleMixedCase((String)this.getCurrentSchema());
            this.query.append(" and owner in('SYS',?) ");
            this.binds.add(string);
        } else {
            this.query.append(" and owner = ? ");
            this.binds.add(Service.handleMixedCase((String)string));
        }
        if (string2 != null) {
            this.query.append(OBJ_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string2));
        }
        if (string3 != null && string3.length() > 0) {
            this.query.append(PROCNAME_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string3) + "%");
        }
        if (string2 == null) {
            return;
        }
        try {
            string4 = RaptorVersionTracker.getDbVersion(ChameleonConnection.getConnection((String)this.connectionName));
        }
        catch (Exception exception) {
            return;
        }
        if (string4 == null) {
            return;
        }
        int n = string4.toIntArray()[0];
        int n2 = string4.toIntArray()[1];
        if (n < 11) {
            return;
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_PACKAGED_GLOBAL_VARIABLES());
        if (string == null) {
            string = Service.handleMixedCase((String)this.getCurrentSchema());
            this.query.append(" and owner in('SYS',?) ");
            this.binds.add(string);
        } else {
            this.query.append(" and owner = ? ");
            this.binds.add(Service.handleMixedCase((String)string));
        }
        if (string2 != null) {
            this.query.append(OBJ_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string2));
        }
        if (string3 != null && string3.length() > 0) {
            this.query.append(VARNAME_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string3) + "%");
        }
    }

    public void prepareArgumentsProc(String string, String string2) {
        List list;
        Object object;
        if (this.prepareArgumentsProcCalled) {
            return;
        }
        this.prepareArgumentsProcCalled = true;
        if (this.synonyms != null && (object = this.synonyms.getTable(null, string)) != null && (list = LexerToken.parse((String)object)).size() == 3) {
            string = ((LexerToken)list.get((int)2)).content;
            this.isSynonym = true;
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        object = this.QUERY_ARGUMENTS();
        if (string != null) {
            object = (String)object + OWN_PKG_CRITERIA;
            this.binds.add(string);
            this.binds.add(string);
            this.binds.add(string);
        }
        if (string2 != null) {
            if (string != null) {
                object = (String)object + PACKAGED_PROC_CRITERIA;
                this.binds.add(string);
                this.binds.add(string2);
            } else {
                object = (String)object + STANDALONE_PROC_CRITERIA;
                this.binds.add(string2);
            }
        }
        this.query.append((String)object);
    }

    public void setTableAliases(Map<String, String> map) {
        this.setTableAliases(map, false);
    }

    public void setTableAliases(Map<String, String> map, boolean bl) {
        if (this.setTableAliasesCalled) {
            return;
        }
        this.setTableAliasesCalled = true;
        this.isPrefixed = bl;
        if (this.synonyms == null) {
            this.tableAliases = map;
        } else {
            this.tableAliases = new HashMap<String, String>();
            for (String string : map.keySet()) {
                String string2;
                String string3 = map.get(string);
                String string4 = null;
                String string5 = string3;
                if (string5.charAt(0) != '\"' && string5.indexOf(46) > 0) {
                    string4 = string5.substring(0, string5.indexOf(46));
                    string5 = string5.substring(string5.indexOf(46) + 1);
                }
                if ((string2 = this.synonyms.getTable(string4, string5)) != null) {
                    string3 = string2;
                }
                this.tableAliases.put(string, string3);
            }
        }
    }

    String getTable(String string) {
        if (this.tableAliases == null) {
            return null;
        }
        return this.tableAliases.get(string);
    }

    private List<String> translate(String string, String string2, String string3) {
        String string4;
        String string5;
        boolean bl = false;
        int n = 0;
        for (String object2 : this.tableAliases.keySet()) {
            String string6;
            ++n;
            String string7 = this.tableAliases.get(object2);
            if (object2.equalsIgnoreCase(string7)) continue;
            string5 = null;
            string4 = object2;
            if (string4.charAt(0) != '\"' && string4.indexOf(46) > 0) {
                string5 = string4.substring(0, string4.indexOf(46));
                string4 = string4.substring(string4.indexOf(46) + 1);
            }
            if (string7.equals(string6 = this.synonyms.getTable(string5, string4))) continue;
            bl = true;
            break;
        }
        if (this.colNameOrdering && this.isPrefixed) {
            bl = true;
        }
        if (1 < n) {
            bl = true;
        }
        ArrayList arrayList = new ArrayList();
        if (this.tableAliases.size() == 0) {
            arrayList.add(string3);
            return arrayList;
        }
        for (String string7 : this.tableAliases.keySet()) {
            string5 = this.tableAliases.get(string7);
            if (!string5.equalsIgnoreCase(string + "." + string2) && !string5.equalsIgnoreCase(string2) && !string5.equalsIgnoreCase("\"" + string + "\".\"" + string2 + "\"") && !string5.equalsIgnoreCase("\"" + string + "\"." + string2) && !string5.equalsIgnoreCase("\"" + string2 + "\"")) continue;
            string4 = bl ? string7 + "." + string3 : string3;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public boolean isPrepared() {
        return this.query.length() > 0;
    }

    private String queryByOwnerTable(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append("\n  union all\n");
            }
            stringBuffer.append(this.QUERY_COLUMNS_BY_OWNER_TABLE());
            if (!this.excludeVirtualColumns) continue;
            stringBuffer.append(" and virtual_column='NO' ");
        }
        return stringBuffer.toString();
    }

    private void setFQBinds(Set<String> set, List<Object> list) {
        for (String string : set) {
            String string2;
            String string3 = string.substring(0, string.indexOf(46));
            list.add(Service.handleMixedCase((String)string3));
            String string4 = string.substring(string.indexOf(46) + 1);
            if (this.synonyms != null && (string2 = this.synonyms.getTable(string3, string4)) != null) {
                string3 = string2.substring(0, string2.indexOf(46));
                string4 = string2.substring(string2.indexOf(46) + 1);
            }
            list.add(Service.handleMixedCase((String)string4));
        }
    }

    public Set<SuggestedItem> fetch() throws Exception {
        if (this.query == null || this.query.length() == 0) {
            return Collections.emptySet();
        }
        long l = System.currentTimeMillis();
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        String string = null;
        Connection connection = this.getConnection();
        if (connection == null) {
            return Collections.emptySet();
        }
        string = connection.getMetaData().getDatabaseMajorVersion() > 10 ? this.query.toString().replace("OBJ_TYPE_EQ_PKG", OBJ_TYPE_EQ_PKG) : this.query.toString().replace("OBJ_TYPE_EQ_PKG", "");
        if (mode == Mode.SERIAL) {
            List<Object> list = new ArrayList<Object>();
            list.addAll(this.binds);
            int n = string.indexOf("union all");
            while (0 < n) {
                String string2 = string.substring(0, n);
                string = string.substring(n + "union all".length());
                int n2 = new StringTokenizer(" " + (String)string2 + " ", "?").countTokens() - 1;
                List<Object> list2 = list.subList(0, n2);
                list = list.subList(n2, list.size());
                treeSet.addAll(this.fetch(connection, string2, list2));
                n = string.indexOf("union all");
            }
            if (10 < string.length()) {
                treeSet.addAll(this.fetch(connection, string, list));
            }
        } else if (mode == Mode.UNION) {
            treeSet.addAll(this.fetch(connection, string, this.binds));
        } else if (mode == Mode.PARALLEL) {
            treeSet.addAll(this.fetchParallel(connection, string));
        } else if (mode == Mode.CACHE_PARALLEL) {
            treeSet.addAll(this.fetchCachedParallel(connection, string));
        } else if (mode == Mode.CACHE_UNION) {
            treeSet.addAll(this.fetchCachedUnion(connection, string));
        } else {
            throw new AssertionError((Object)"Unexpected ccase");
        }
        long l2 = System.currentTimeMillis();
        if (CompletionInsight.timing) {
            System.out.println("InsightableOracleDatabase.fetch() time = " + (l2 - l));
        }
        if (l + 600L < l2) {
            logger.warning("InsightableOracleDatabase.fetch() time = " + (l2 - l));
            logger.warning(this.query.toString());
            if (CompletionInsight.timing) {
                logger.warning("Binds=" + this.binds);
            }
        }
        if (this.prefixedUsers != null) {
            for (String string3 : this.prefixedUsers) {
                treeSet.add(new SuggestedItem("SCHEMA", null, string3));
            }
        }
        return treeSet;
    }

    private Set<SuggestedItem> fetchParallel(Connection connection, String string) {
        Object object;
        long l = System.currentTimeMillis();
        HashSet<QueryWorker> hashSet = new HashSet<QueryWorker>();
        List<Object> list = new ArrayList<Object>();
        list.addAll(this.binds);
        int n = string.indexOf("union all");
        while (0 < n) {
            object = string.substring(0, n);
            string = string.substring(n + "union all".length());
            int n2 = new StringTokenizer(" " + object + " ", "?").countTokens() - 1;
            List<Object> list2 = list.subList(0, n2);
            list = list.subList(n2, list.size());
            Connection connection2 = this.getIdleConnection(connection);
            if (connection2 == null) {
                System.out.println("cloneConn == null");
            } else {
                QueryWorker queryWorker = new QueryWorker(connection2, (String)object, list2);
                hashSet.add(queryWorker);
                queryWorker.start();
            }
            n = string.indexOf("union all");
        }
        if (10 < string.length()) {
            object = this.getIdleConnection(connection);
            if (object == null) {
                System.out.println("cloneConn == null");
            } else {
                QueryWorker queryWorker = new QueryWorker((Connection)object, string, list);
                hashSet.add(queryWorker);
                queryWorker.start();
            }
        }
        object = new TreeSet<SuggestedItem>();
        boolean bl = false;
        while (!bl) {
            boolean bl2 = false;
            for (QueryWorker queryWorker : hashSet) {
                if (queryWorker.isAlive()) {
                    bl2 = true;
                }
                if (queryWorker.isAlive() || queryWorker.ret == null) continue;
                object.addAll(queryWorker.ret);
                queryWorker.ret = null;
            }
            if (!bl2) {
                if (debug) {
                    System.out.println("Time=" + (System.currentTimeMillis() - l));
                }
                return object;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (debug) {
            System.out.println("Time=" + (System.currentTimeMillis() - l));
        }
        return object;
    }

    private List<SuggestedItem> fetchCachedParallel(Connection connection, String string) {
        boolean bl;
        Object object;
        long l = System.currentTimeMillis();
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        List<SuggestedItem> list = InsightCache.getDatabase(this.connectionName);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<Object> hashSet = new HashSet<Object>();
        List<Object> list2 = new ArrayList<Object>();
        list2.addAll(this.binds);
        int n = string.indexOf("union all");
        while (0 < n) {
            String string2 = string.substring(0, n);
            string = string.substring(n + "union all".length());
            int n2 = new StringTokenizer(" " + string2 + " ", "?").countTokens() - 1;
            object = list2.subList(0, n2);
            list2 = list2.subList(n2, list2.size());
            boolean bl2 = this.prepareCacheQuery(string2, list, linkedList2, (List<Object>)object);
            if (!bl2) {
                Connection connection2 = this.getIdleConnection(connection);
                if (connection2 == null) {
                    System.out.println("cloneConn == null");
                } else {
                    QueryWorker queryWorker = new QueryWorker(connection2, string2, (List<Object>)object);
                    hashSet.add(queryWorker);
                    queryWorker.start();
                }
            }
            n = string.indexOf("union all");
        }
        if (10 < string.length() && !(bl = this.prepareCacheQuery(string, list, linkedList2, list2))) {
            Connection connection3 = this.getIdleConnection(connection);
            if (connection3 == null) {
                System.out.println("cloneConn == null");
            } else {
                object = new QueryWorker(connection3, string, list2);
                hashSet.add(object);
                ((Thread)object).start();
            }
        }
        if (list != null) {
            linkedList.addAll(InsightCache.queryItems(this.connectionName, this.users.schemaName, this.prefix, this.owner, linkedList2));
        }
        boolean bl3 = false;
        while (!bl3) {
            boolean bl4 = false;
            for (QueryWorker queryWorker : hashSet) {
                if (queryWorker.isAlive()) {
                    bl4 = true;
                }
                if (queryWorker.isAlive() || queryWorker.ret == null) continue;
                linkedList.addAll(queryWorker.ret);
                queryWorker.ret = null;
            }
            if (!bl4) {
                if (debug) {
                    System.out.println("Time=" + (System.currentTimeMillis() - l));
                }
                return linkedList;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (debug) {
            System.out.println("Time=" + (System.currentTimeMillis() - l));
        }
        return linkedList;
    }

    private List<SuggestedItem> fetchCachedUnion(Connection connection, String string) {
        boolean bl;
        long l = System.currentTimeMillis();
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        List<SuggestedItem> list = InsightCache.getDatabase(this.connectionName);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Object> list2 = new ArrayList<Object>();
        list2.addAll(this.binds);
        int n = string.indexOf("union all");
        while (0 < n) {
            String string2 = string.substring(0, n);
            string = string.substring(n + "union all".length());
            int n2 = new StringTokenizer(" " + string2 + " ", "?").countTokens() - 1;
            List<Object> list3 = list2.subList(0, n2);
            list2 = list2.subList(n2, list2.size());
            boolean bl2 = this.prepareCacheQuery(string2, list, linkedList2, list3);
            if (!bl2) {
                if (0 < stringBuilder.length()) {
                    stringBuilder.append(" union all ");
                }
                stringBuilder.append(string2);
                arrayList.addAll(list3);
            }
            n = string.indexOf("union all");
        }
        if (10 < string.length() && !(bl = this.prepareCacheQuery(string, list, linkedList2, list2))) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(" union all ");
            }
            stringBuilder.append(string);
            arrayList.addAll(list2);
        }
        if (list != null) {
            linkedList.addAll(InsightCache.queryItems(this.connectionName, this.users.schemaName, this.prefix, this.owner, linkedList2));
        }
        try {
            if (0 < stringBuilder.length()) {
                linkedList.addAll(this.fetch(connection, stringBuilder.toString(), arrayList));
            }
        }
        catch (Exception exception) {
            logger.severe("failed query " + stringBuilder.toString());
        }
        if (debug) {
            System.out.println("Time=" + (System.currentTimeMillis() - l));
        }
        return linkedList;
    }

    private boolean prepareCacheQuery(String string, List<SuggestedItem> list, List<String> list2, List<Object> list3) {
        boolean bl = false;
        if (string.contains("_objects")) {
            bl = true;
        }
        if (list != null && bl) {
            String string2;
            String string3 = "object_type =";
            int n = string.indexOf(string3);
            if (n < 0) {
                string3 = "object_type IN";
                n = string.indexOf(string3);
            }
            if (0 < n) {
                if (string.contains("'TABLE'")) {
                    list2.add("TABLE");
                }
                if (string.contains("'VIEW'")) {
                    list2.add("VIEW");
                }
                if (string.contains("'SYNONYM'")) {
                    list2.add("SYNONYM");
                }
                if (string.contains("'SEQUENCE'")) {
                    list2.add("SEQUENCE");
                }
                if (string.contains("'PROCEDURE'")) {
                    list2.add("PROCEDURE");
                }
                if (string.contains("'FUNCTION'")) {
                    list2.add("FUNCTION");
                }
                if (string.contains("'OPERATOR'")) {
                    list2.add("OPERATOR");
                }
                if (string.contains("'PACKAGE'")) {
                    list2.add("PACKAGE");
                }
            } else {
                bl = false;
            }
            String string4 = "object_name like ?";
            int n2 = 0;
            if (string.contains(string4)) {
                this.prefix = (String)list3.get(n2);
                this.prefix = this.prefix.substring(0, this.prefix.length() - 1);
                ++n2;
            }
            if (string.contains(string2 = this.OWNER_CRITERIA())) {
                this.owner = (String)list3.get(n2);
                ++n2;
            }
            if (this.owner == null && string.contains("SYS_CONTEXT('USERENV','CURRENT_SCHEMA'")) {
                this.owner = "";
            }
        }
        return bl;
    }

    Connection getIdleConnection(Connection connection) {
        Object object;
        for (Connection connection2 : pool.keySet()) {
            object = pool.get(connection2);
            if (object != null) continue;
            return connection2;
        }
        try {
            long l = System.currentTimeMillis();
            object = this.connectionName;
            Connection connection3 = null;
            if (!this.connectionName.startsWith("jdbc:oracle:thin:@")) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)Connections.getInstance().getConnectionInfo(this.connectionName));
                object = properties.getProperty("customUrl") + "," + properties.getProperty("user") + "," + properties.getProperty("password");
            }
            ChameleonConnection.clearCache();
            connection3 = ChameleonConnection.getConnection((String)object);
            if (debug) {
                System.out.println("clone connection " + (System.currentTimeMillis() - l));
            }
            pool.put(connection3, null);
            if (debug) {
                System.out.println("pool.size()=" + pool.keySet().size());
            }
            return connection3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<SuggestedItem> fetch(Connection connection, String string, List<Object> list) throws Exception {
        Object object;
        TreeSet<SuggestedItem> treeSet;
        block38: {
            boolean bl;
            block37: {
                treeSet = new TreeSet<SuggestedItem>();
                ResultSet resultSet = null;
                bl = false;
                CancelOnTimeout cancelOnTimeout = null;
                try {
                    bl = Connections.getInstance().tryLock(connection, 300L);
                    if (!bl) {
                        Set<SuggestedItem> set = Collections.emptySet();
                        return set;
                    }
                    object = connection.getMetaData().getUserName();
                    long l = System.currentTimeMillis();
                    PreparedStatement preparedStatement = connection.prepareStatement(string);
                    if (this.isCancellable) {
                        cancelOnTimeout = new CancelOnTimeout(preparedStatement);
                        cancelOnTimeout.start();
                    }
                    preparedStatement.setFetchSize(this.limit() + 5);
                    long l2 = System.currentTimeMillis();
                    pool.put(connection, preparedStatement);
                    if (list != null) {
                        DBUtil.bind((PreparedStatement)preparedStatement, list);
                    }
                    try {
                        resultSet = preparedStatement.executeQuery();
                    }
                    catch (Exception exception) {
                        logger.severe(exception.getMessage());
                        TreeSet<SuggestedItem> treeSet2 = treeSet;
                        if (resultSet != null) {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                        }
                        if (bl) {
                            Connections.getInstance().unlock(connection);
                        }
                        pool.put(connection, null);
                        return treeSet2;
                    }
                    if (debug) {
                        System.out.println(preparedStatement.toString() + " prepared " + (l2 - l) + ", executed " + (System.currentTimeMillis() - l2));
                    }
                    String string2 = null;
                    HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                    long l3 = System.currentTimeMillis();
                    while (resultSet.next()) {
                        String string3;
                        String string4 = resultSet.getString("type");
                        String string5 = resultSet.getString("object_name");
                        if (string.indexOf("object_name||'.'||procedure_name") <= 0) {
                            string5 = Service.addDoubleQuote((String)string5);
                        }
                        String string6 = resultSet.getString("column_name");
                        if ("ARGUMENT".equals(string4)) {
                            string3 = string5;
                            if (string2 == null || string3.equals(string2)) {
                                hashMap.put(resultSet.getInt("column_id"), string6);
                            } else {
                                this.inlineArguments(treeSet, hashMap);
                                hashMap.put(resultSet.getInt("column_id"), string6);
                            }
                            string2 = string3;
                            continue;
                        }
                        string3 = resultSet.getString("owner");
                        if (string6 != null && ("COLUMN".equals(string4) || "PROCEDURE".equals(string4) || "FUNCTION".equals(string4)) || "NUMBER".equals(string4)) {
                            string6 = Service.addDoubleQuote((String)string6);
                            if (string3 == null || string5 == null) {
                                System.out.println(string3);
                            }
                            List<String> list2 = this.translate(string3, string5, string6);
                            Integer n = resultSet.getInt("column_id");
                            if (n == null || this.colNameOrdering) {
                                n = -1;
                            }
                            for (String string7 : list2) {
                                SuggestedItem suggestedItem = new SuggestedItem(string4, null, string7, n, this.adjustCase);
                                suggestedItem.columnType = resultSet.getString("data_type");
                                treeSet.add(suggestedItem);
                            }
                            continue;
                        }
                        if ("SEQUENCE".equals(string4)) {
                            treeSet.add(new SuggestedItem(string4, string5, string6));
                            continue;
                        }
                        if (this.users != null) {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n >= 0) {
                                string3 = this.users.getUserName(n);
                            }
                        }
                        treeSet.add(new SuggestedItem(string4, ((String)object).equals(string3) || this.isSynonym ? "" : string3, string5));
                    }
                    if (hashMap.size() > 0) {
                        this.inlineArguments(treeSet, hashMap);
                        hashMap.clear();
                    }
                    if (cancelOnTimeout != null) {
                        cancelOnTimeout.quit = true;
                    }
                    if (debug) {
                        System.out.println("Finished " + preparedStatement.toString() + ", time=" + (System.currentTimeMillis() - l) + ", ret.size()=" + treeSet.size());
                    }
                    if (resultSet == null) break block37;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    System.out.println("ret.size()=" + treeSet.size());
                    break block38;
                }
                finally {
                    if (resultSet != null) {
                        DBUtil.closeResultSet(resultSet);
                    }
                    if (bl) {
                        Connections.getInstance().unlock(connection);
                    }
                    pool.put(connection, null);
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            if (bl) {
                Connections.getInstance().unlock(connection);
            }
            pool.put(connection, null);
        }
        if (treeSet.size() >= this.limit()) {
            object = null;
            Iterator iterator = treeSet.iterator();
            if (iterator.hasNext()) {
                SuggestedItem suggestedItem = (SuggestedItem)iterator.next();
                object = suggestedItem;
            }
            treeSet.add(new SuggestedItem(object.getType(), null, "..."));
        }
        return treeSet;
    }

    private void inlineArguments(Set<SuggestedItem> set, Map<Integer, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 1; i <= map.size(); ++i) {
            String string = map.get(i);
            boolean bl = 0 < string.indexOf(" Y*/");
            string = string.replace(" Y*/", "*/");
            string = string.replace(" N*/", "*/");
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            if (bl) continue;
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(string);
        }
        if (stringBuilder.length() != stringBuilder2.length()) {
            set.add(new SuggestedItem("ARGUMENT", null, "/*min sig:*/" + stringBuilder2.toString()));
            set.add(new SuggestedItem("ARGUMENT", null, "/*full sig:*/" + stringBuilder.toString()));
        } else {
            set.add(new SuggestedItem("ARGUMENT", null, stringBuilder.toString()));
        }
    }

    public Connection getConnection() throws Exception {
        return ChameleonConnection.getConnection((String)this.connectionName);
    }

    public static void profile(int n, int n2) {
        InsightableOracleDatabase.profile(n, n2, 5);
    }

    public static void profile(final int n, final int n2, final int n3) {
        if (isRunning) {
            System.out.println("********fired more than once********");
            return;
        }
        isRunning = true;
        String string = Thread.currentThread().getName();
        System.out.println("threadName=" + string);
        new Thread(){

            @Override
            public void run() {
                String string = Thread.currentThread().getName();
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() < l + (long)n) {
                    try {
                        Thread.sleep(n2);
                        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(true, true);
                        boolean bl = false;
                        boolean bl2 = false;
                        for (ThreadInfo threadInfo : threadInfoArray) {
                            StackTraceElement stackTraceElement;
                            if (string.equals(threadInfo.getThreadName())) continue;
                            if (bl) {
                                System.out.println("----------------" + threadInfo.getThreadName());
                            }
                            bl = false;
                            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                            int n4 = 0;
                            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
                            int n22 = stackTraceElementArray2.length;
                            for (int i = 0; !(i >= n22 || (stackTraceElement = stackTraceElementArray2[i]).toString().startsWith("org") || stackTraceElement.toString().startsWith("oracle.dbtools.raptor.plsql.BackgroundParser") || stackTraceElement.toString().startsWith("oracle.ide.model.FacadeBufferReference$PollingThread") || stackTraceElement.toString().startsWith("oracle.ide.util.WeakDataReference$Cleaner") || stackTraceElement.toString().startsWith("oracle.ide.status.StatusExecutor") || stackTraceElement.toString().startsWith("oracle.ide.log.QueuedLoggingHandler")); ++i) {
                                if (stackTraceElement.toString().startsWith("java") || stackTraceElement.toString().startsWith("sun") || stackTraceElement.toString().startsWith("oracle.net.ns") || stackTraceElement.toString().startsWith("oracle.jdbc") || stackTraceElement.toString().startsWith("oracle.dbtools.raptor.backgroundTask") || stackTraceElement.toString().startsWith("oracle.javatools.db.execute.QueryWrapper") || stackTraceElement.toString().startsWith("oracle.javatools.db.execute.ConnectionWrapper") || n4 >= n3) continue;
                                System.out.println(stackTraceElement.toString());
                                bl = true;
                                bl2 = true;
                                ++n4;
                            }
                        }
                        if (!bl2) continue;
                        System.out.println("=================" + (System.currentTimeMillis() - l));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
    }

    static {
        try {
            Properties properties = System.getProperties();
            Object object = properties.get("sqldev.insight.mode");
            if (debug) {
                System.out.println("pr.getProperty(\"sqldev.insight.mode\")=" + object);
            }
            if (object != null) {
                for (Mode mode : Mode.values()) {
                    if (!mode.toString().equals(object)) continue;
                    InsightableOracleDatabase.mode = mode;
                }
            } else {
                String string = DBConfig.getInstance().getString("INSIGHTDBQUERYMODE");
                for (Mode mode : Mode.values()) {
                    if (!mode.toString().equals(string)) continue;
                    InsightableOracleDatabase.mode = mode;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static enum Mode {
        UNION,
        SERIAL,
        PARALLEL,
        CACHE_UNION,
        CACHE_PARALLEL;

    }

    private class QueryWorker
    extends Thread {
        Connection conn;
        String query;
        List<Object> binds;
        Set<SuggestedItem> ret;

        QueryWorker(Connection connection, String string, List<Object> list) {
            super("QueryWorker" + wrkNo++);
            this.ret = null;
            try {
                pool.put(connection, new VacuousConnection().prepareStatement("vacuous sql"));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.conn = connection;
            this.query = string;
            this.binds = list;
        }

        @Override
        public void run() {
            try {
                this.ret = InsightableOracleDatabase.this.fetch(this.conn, this.query, this.binds);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class CancelOnTimeout
    extends Thread {
        boolean quit;
        Statement stmt;

        CancelOnTimeout(Statement statement) {
            super("CancelOnTimeout" + wrkNo++);
            this.quit = false;
            this.stmt = statement;
        }

        @Override
        public void run() {
            try {
                try {
                    Thread.sleep(InsightableOracleDatabase.this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.quit) {
                    return;
                }
                if (debug) {
                    System.out.println("Canceling- " + this.stmt.toString());
                }
                long l = System.currentTimeMillis();
                this.stmt.cancel();
                if (debug) {
                    System.out.println("-done  " + (System.currentTimeMillis() - l));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

