/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;

public abstract class CancellableQuery {
    private boolean refreshInTask;
    private PreparedStatement stmt = null;
    private State state = State.READY;

    protected abstract void initialize(Connection var1) throws SQLException;

    protected abstract PreparedStatement prepareStatement(Connection var1) throws SQLException;

    protected abstract void loadData(ResultSet var1) throws SQLException;

    protected abstract void clearData();

    protected abstract void handleException(Exception var1);

    protected boolean continueLoading() {
        return this.state == State.LOADING;
    }

    public CancellableQuery() {
        this(true);
    }

    public CancellableQuery(boolean bl) {
        this.refreshInTask = bl;
    }

    public void process(final Connection connection) {
        if (this.refreshInTask) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("ResultSetTableModel.8"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                public boolean cancel() {
                    CancellableQuery.this.cancelWork();
                    return true;
                }

                protected Void doWork() throws TaskException {
                    CancellableQuery.this.processWork(connection);
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        } else {
            this.processWork(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processWork(Connection var1_1) {
        try {
            this.transitState(1, new State[]{State.READY, State.PREPARING});
            var2_2 = null;
            if (Connections.getInstance().lock(var1_1, true)) {
                try {
                    try {
                        this.initialize(var1_1);
                        this.stmt = this.prepareStatement(var1_1);
                        if (this.stmt != null) {
                            if (this.transitState(2, new State[]{State.PREPARING, State.EXECUTING, State.CANCELLED, State.FINISHED}) != State.PREPARING) ** GOTO lbl57
                            var2_2 = this.stmt.executeQuery();
                            if (this.transitState(3, new State[]{State.EXECUTING, State.LOADING, State.CANCELLED, State.FINISHED}) == State.EXECUTING) {
                                this.loadData(var2_2);
                                if (this.transitState(4, new State[]{State.LOADING, State.FINISHED, State.CANCELLED, State.FINISHED}) != State.CANCELLED) ** GOTO lbl57
                                this.clearData();
                            }
                            this.tidyFailedCancel(var1_1);
                        }
                        this.clearData();
                    }
                    catch (SQLException var3_4) {
                        this.clearData();
                        if (var3_4.getErrorCode() == 1013) {
                            this.transitState(5, new State[]{State.CANCELLED, State.FINISHED});
                        }
                        this.transitState(6, new State[]{State.PREPARING, State.FINISHED, State.EXECUTING, State.FINISHED, State.LOADING, State.FINISHED, State.CANCELLED, State.FINISHED});
                        if (var3_4.getErrorCode() == 17104) ** GOTO lbl57
                        this.handleException(var3_4);
                    }
                    catch (Exception var3_5) {
                        this.clearData();
                        this.transitState(7, new State[]{State.PREPARING, State.FINISHED, State.EXECUTING, State.FINISHED, State.LOADING, State.FINISHED, State.CANCELLED, State.FINISHED});
                        this.handleException(var3_5);
                    }
                }
                finally {
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                    }
                    catch (SQLException var3_7) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var3_7.getStackTrace()[0].toString(), var3_7);
                    }
                    try {
                        if (this.stmt != null) {
                            this.stmt.close();
                            this.stmt = null;
                        }
                    }
                    catch (SQLException var3_8) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var3_8.getStackTrace()[0].toString(), var3_8);
                    }
                    Connections.getInstance().unlock(var1_1);
                }
            } else if (this.transitState(8, new State[]{State.PREPARING, State.FINISHED, State.CANCELLED, State.FINISHED}) == State.PREPARING) {
                this.clearData();
            }
lbl57:
            // 12 sources

            this.transitState(9, new State[]{State.PREPARING, State.COMPLETE, State.EXECUTING, State.COMPLETE, State.LOADING, State.COMPLETE, State.READY, State.COMPLETE, State.CANCELLED, State.COMPLETE, State.FINISHED, State.COMPLETE});
        }
        catch (RuntimeException var2_3) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var2_3.getStackTrace()[0].toString(), var2_3);
            throw var2_3;
        }
    }

    private void cancelWork() {
        State state = this.transitState(10, State.PREPARING, State.CANCELLED, State.EXECUTING, State.CANCELLED, State.LOADING, State.CANCELLED, State.READY, State.READY, State.CANCELLED, State.CANCELLED, State.FINISHED, State.FINISHED, State.COMPLETE, State.COMPLETE);
        if (state == State.PREPARING) {
            this.clearData();
        } else if (state == State.EXECUTING) {
            try {
                this.stmt.cancel();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            this.clearData();
            this.waitForCancel();
        }
    }

    private void waitForCancel() {
        final CancellableQuery cancellableQuery = this;
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("CancellableQuery.1"), true, IRaptorTaskRunMode.MODAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                Object object = cancellableQuery;
                synchronized (object) {
                    while (CancellableQuery.this.state != State.COMPLETE) {
                        try {
                            cancellableQuery.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                        }
                    }
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State transitState(int n, State ... stateArray) {
        State state = null;
        CancellableQuery cancellableQuery = this;
        synchronized (cancellableQuery) {
            for (int i = 0; i < stateArray.length; i += 2) {
                State state2 = stateArray[i];
                if (this.state != state2) continue;
                state = state2;
                this.state = stateArray[i + 1];
                if (state2 == State.COMPLETE || this.state != State.COMPLETE) break;
                this.notify();
                break;
            }
        }
        if (state == null) {
            throw new IllegalStateException();
        }
        Logger.getLogger(this.getClass().getName()).log(Level.FINEST, "[" + n + "] " + state + " --> " + this.state);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidyFailedCancel(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM DUAL");){
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static enum State {
        READY,
        PREPARING,
        EXECUTING,
        LOADING,
        CANCELLED,
        FINISHED,
        COMPLETE;

    }
}

