/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.ExtColumn;
import oracle.dbtools.raptor.config.ExternalEditorConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ExternalEditorPanel
extends DefaultTraversablePanel {
    private JTable _table;
    private DefaultTableModel _model = new DefaultTableModel();
    private Component _comp;

    public ExternalEditorPanel() {
        this.init();
    }

    public ExternalEditorPanel(List<ExtColumn> list) {
        this.init();
        for (ExtColumn extColumn : list) {
            this.addRow(extColumn.getType(), extColumn.getName());
        }
    }

    public void setColumns(List<ExtColumn> list) {
        for (ExtColumn extColumn : list) {
            this.addRow(extColumn.getType(), extColumn.getName());
        }
    }

    private Map<String, List<String>> modelToMap(DefaultTableModel defaultTableModel) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 0);
            String string2 = (String)defaultTableModel.getValueAt(i, 1);
            String string3 = (String)defaultTableModel.getValueAt(i, 2);
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string2, arrayList);
            }
            arrayList.add(string);
            arrayList.add(string3);
        }
        return hashMap;
    }

    private DefaultTableModel mapToModel(Map<String, List<String>> map) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn(Messages.getString("ExternalEditor.0"));
        defaultTableModel.addColumn(Messages.getString("ExternalEditor.1"));
        defaultTableModel.addColumn(Messages.getString("ExternalEditor.2"));
        String[] stringArray = new String[2];
        int n = 0;
        for (String string : map.keySet()) {
            n = 0;
            Iterator<String> iterator = map.get(string).iterator();
            while (iterator.hasNext()) {
                String string2;
                stringArray[n] = string2 = iterator.next();
                ++n;
            }
            defaultTableModel.addRow(new Object[]{stringArray[0], string, stringArray[1]});
        }
        return defaultTableModel;
    }

    public void onEntry(TraversableContext traversableContext) {
        DefaultTableModel defaultTableModel;
        ExternalEditorConfig externalEditorConfig = ExternalEditorConfig.getInstance(traversableContext);
        this._model = defaultTableModel = this.mapToModel(externalEditorConfig.getAllElements());
        this._table.setModel(this._model);
        this._table.updateUI();
        int n = 2;
        TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new URLCellEditor());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this._table.getCellEditor() != null) {
            this._table.getCellEditor().stopCellEditing();
        }
        ExternalEditorConfig externalEditorConfig = ExternalEditorConfig.getInstance(traversableContext);
        externalEditorConfig.putAllElements(this.modelToMap(this._model));
    }

    public void init() {
        this.setHelpID("f1_idedidesetexternaleditor_html");
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(PreferencesArb.getString("EXTEDITOR_DES"));
        this.add(jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane();
        this.add(jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this._table = new JTable(this._model);
        this._model.addColumn(Messages.getString("ExternalEditor.3"));
        this._model.addColumn(Messages.getString("ExternalEditor.4"));
        this._model.addColumn(Messages.getString("ExternalEditor.5"));
        jScrollPane.setViewportView(this._table);
        int n = 2;
        TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
        this._comp = this;
        tableColumn.setCellEditor(new URLCellEditor());
    }

    public void addRow(String string, String string2) {
        this._model.addRow(new Object[]{string2, string});
        this._model.fireTableDataChanged();
    }

    public void addRow(String string, String string2, String string3) {
        this._model.addRow(new Object[]{string, string2, string3});
        this._model.fireTableDataChanged();
    }

    public List<ExtColumn> getColumns() {
        ExtColumn extColumn = null;
        ArrayList<ExtColumn> arrayList = new ArrayList<ExtColumn>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            extColumn = new ExtColumn((String)this._table.getModel().getValueAt(i, 0), (String)this._table.getModel().getValueAt(i, 1));
            arrayList.add(extColumn);
        }
        return arrayList;
    }

    public class URLCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component;

        public URLCellEditor() {
            this.component = new FileSelector(ExternalEditorPanel.this._comp);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            ((FileSelector)this.component).setFileName((String)object);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((FileSelector)this.component).getFileName();
        }
    }

    public class FileSelector
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JTextField _fileName;
        private Component _parent;
        private JButton _browse;
        private String _defaultName = "";
        private String _encoding;

        public FileSelector(Component component) {
            this._parent = component;
            this.setLayout(new BorderLayout());
            this._fileName = new JTextField(this._defaultName);
            this.add((Component)this._fileName, "Center");
            this._browse = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FileSelector.1")));
            this._browse.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("FileSelector.2")));
            this._browse.addActionListener(this);
            this.add((Component)this._browse, "East");
            int n = Double.valueOf(this.getPreferredSize().getWidth()).intValue();
            Dimension dimension = new Dimension(n + 150, Double.valueOf(this.getPreferredSize().getHeight()).intValue());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        }

        public void prompt() {
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.setPathContext("EXPORTDIR");
            String string = this._fileName.getText();
            DBConfig dBConfig = DBConfig.getInstance();
            Object object = dBConfig.getString("EXPORTDIR") + File.separator;
            object = System.getProperty("user.home");
            if (string.equals("")) {
                try {
                    File file = new File((String)object);
                    uRLFileChooser.setSelectedFile(file);
                }
                catch (Exception exception) {
                    File file = new File((String)object);
                    uRLFileChooser.setSelectedFile(file);
                }
            } else {
                int n = string.lastIndexOf(File.separator);
                if (n > -1) {
                    uRLFileChooser.setSelectedFile(new File(string));
                } else {
                    uRLFileChooser.setSelectedFile(new File(dBConfig.getString("EXPORTDIR") + File.separator + string));
                }
            }
            if (uRLFileChooser.showSaveDialog(this._parent, Messages.getString("FileSelector.2")) == 0) {
                int n;
                String string2 = uRLFileChooser.getSelectedFile().toString();
                String string3 = string2.substring(n = string2.lastIndexOf(File.separator));
                if (string3.lastIndexOf(".") > -1) {
                    this._fileName.setText(uRLFileChooser.getSelectedFile().toString());
                } else {
                    this._fileName.setText(uRLFileChooser.getSelectedFile().toString());
                }
            }
        }

        public void setFileName(String string) {
            this._fileName.setText(string);
        }

        public String getFileName() {
            return this._fileName.getText();
        }

        public String getEncoding() {
            return this._encoding;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.prompt();
        }
    }
}

