/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import oracle.dbtools.connections.ConnectionReference;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfoFactory;

public final class ConnectionInfoReferenceable
implements ConnectionReferenceable {
    private final SessionInfo mInfo;

    public ConnectionInfoReferenceable(SessionInfo sessionInfo) {
        this.mInfo = sessionInfo;
    }

    public SessionInfo getConnectionInfo() {
        return this.mInfo;
    }

    public ConnectionReference getReference() {
        SessionInfo.OssInfo ossInfo;
        ConnectionReference.ReferenceBuilder referenceBuilder = new ConnectionReference.ReferenceBuilder(ConnectionInfoReferenceable.class.getName());
        CConnectionInfoFactory.setURIValue(referenceBuilder, "ROOT_URI", this.mInfo.getServerRoot());
        CConnectionInfoFactory.setURIValue(referenceBuilder, "SERVICE_URI", this.mInfo.getServiceRoot());
        CConnectionInfoFactory.setStringValue(referenceBuilder, "USERNAME", this.mInfo.getUsername());
        CConnectionInfoFactory.setSecureValue(referenceBuilder, "AUTHENTICATION", this.mInfo.getPassword(), this.mInfo.getName());
        SessionInfo.SftpInfo sftpInfo = this.mInfo.getSftpInfo();
        if (sftpInfo != null) {
            CConnectionInfoFactory.setStringValue(referenceBuilder, "SFTP_HOST", sftpInfo.getSftpHost());
            CConnectionInfoFactory.setStringValue(referenceBuilder, "SFTP_USERNAME", sftpInfo.getSftpUser());
            CConnectionInfoFactory.setSecureValue(referenceBuilder, "SFTP_AUTHENTICATION", sftpInfo.getSftpPass(), this.mInfo.getName());
            CConnectionInfoFactory.setIntValue(referenceBuilder, "SFTP_PORT", sftpInfo.getSftpPort());
        }
        if ((ossInfo = this.mInfo.getOssInfo()) != null) {
            CConnectionInfoFactory.setBooleanValue(referenceBuilder, "OSS_ENABLED", (Boolean)ossInfo.isOssEnabled());
            CConnectionInfoFactory.setStringValue(referenceBuilder, "OSS_SERVICE_NAME", ossInfo.getOssServiceName());
            CConnectionInfoFactory.setStringValue(referenceBuilder, "OSS_IDENTITY_DOMAIN", ossInfo.getOssIdentityDomain());
            CConnectionInfoFactory.setStringValue(referenceBuilder, "OSS_USERNAME", ossInfo.getOssUserName());
            CConnectionInfoFactory.setSecureValue(referenceBuilder, "OSS_AUTHENICATION", ossInfo.getOssPassword(), this.mInfo.getName());
            CConnectionInfoFactory.setStringValue(referenceBuilder, "OSS_SERVICE_URL", ossInfo.getOssServiceUrl());
        }
        return referenceBuilder.build();
    }
}

