/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;

public final class NavHelpListener
implements ContextMenuListener,
Controller {
    public static final int HELP_COMMAND_NAME = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.RaptorDBAddin.HELP");
    private static final IdeAction actionHelp = IdeAction.find((int)HELP_COMMAND_NAME);
    static JMenuItem MENU_HELP = null;
    private static String HELP_PREFIX = "f1_raptorconnectionnav_";

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Element element = contextMenu.getContext().getElement();
        if (element instanceof ObjectFolder || element instanceof OtherSchemasFolder) {
            if (MENU_HELP == null) {
                actionHelp.addController((Controller)this);
                MENU_HELP = contextMenu.createMenuItem((ToggleAction)actionHelp);
            }
            contextMenu.add((Component)MENU_HELP);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.equals(actionHelp)) {
            Element element = context.getElement();
            if (element instanceof ObjectFolder) {
                ObjectFolder objectFolder = (ObjectFolder)element;
                String string = objectFolder.getObjectType().replaceAll(" ", "_");
                this.showHelp(string);
            } else if (element instanceof OtherSchemasFolder) {
                this.showHelp("USER");
            }
            return true;
        }
        return false;
    }

    private void showHelp(String string) {
        HelpInfo helpInfo = new HelpInfo(HELP_PREFIX + string);
        HelpSystem.getHelpSystem().showHelp(helpInfo);
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }
}

