/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.format;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.format.CodeFragment;
import oracle.dbtools.format.EmbedCommand;
import oracle.dbtools.format.ExposeCommand;
import oracle.dbtools.format.FormatCommand;
import oracle.dbtools.format.FormatterMenu;
import oracle.dbtools.format.Messages;
import oracle.dbtools.raptor.SerializedData;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;

public class FormatterController
implements Controller {
    public boolean handleEvent(IdeAction ideAction, Context context) {
        WaitCursor waitCursor = Ide.getWaitCursor();
        int n = ideAction.getCommandId();
        if (FormatterMenu.FORMAT_ID == n) {
            waitCursor.show();
            FormatCommand formatCommand = new FormatCommand(context);
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            try {
                commandProcessor.invoke((Command)formatCommand);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            waitCursor.hide();
            return true;
        }
        if (FormatterMenu.FORMAT_POPUP_ID == n) {
            waitCursor.show();
            this.executeEmbedExpose(context);
            waitCursor.hide();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private boolean executeEmbedExpose(Context context) {
        final Context context2 = context;
        CodeFragment codeFragment = new CodeFragment(context);
        if (!codeFragment.isSql()) {
            ExposeCommand exposeCommand = new ExposeCommand(context2, false);
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            try {
                if (commandProcessor.invoke((Command)exposeCommand) == 1) {
                    return true;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return false;
        }
        final Boolean[] booleanArray = new Boolean[]{new Boolean(false)};
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{Messages.getString("EDITOR"), Messages.getString("CLIPBOARD")});
        final JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{Messages.getString("EmbedExposePanel.Java"), Messages.getString("EmbedExposePanel.Python"), Messages.getString("EmbedExposePanel.Plsql")});
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("OUTPUT_DESTINATION")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("OUTPUT_DESTINATION")));
        jLabel.setLabelFor(jComboBox);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("OUTPUT_TYPE")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("OUTPUT_TYPE")));
        jLabel2.setLabelFor(jComboBox2);
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        final JCheckBox jCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)Messages.getString("EmbedExposePanel.verbose"));
        jPanel.add((Component)jCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jCheckBox.setSelected(SerializedData.getInstance().embedExposeIsVerbose);
        jComboBox2.setSelectedIndex(SerializedData.getInstance().embedExposeLangIndex);
        if (jComboBox2.getSelectedIndex() != 0) {
            jCheckBox.setEnabled(false);
            jCheckBox.setSelected(false);
        }
        jComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (jComboBox2.getSelectedIndex() == 0) {
                    jCheckBox.setEnabled(true);
                } else {
                    jCheckBox.setEnabled(false);
                    jCheckBox.setSelected(false);
                }
            }
        });
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.setMinimumSize(new Dimension(400, 800));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_popupformatdialog_html");
        UIUtils.showPanelAsDialog((JPanel)jPanel, (String)Messages.getString("EMBED_EXPOSE_SQL"), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                SerializedData.getInstance().embedExposeLangIndex = jComboBox2.getSelectedIndex();
                SerializedData.getInstance().embedExposeIsVerbose = jCheckBox.isSelected();
                SerializedData.write();
                EmbedCommand.Language language = EmbedCommand.Language.JAVA;
                if (jComboBox2.getSelectedIndex() == 1) {
                    language = EmbedCommand.Language.PYTHON;
                } else if (jComboBox2.getSelectedIndex() == 2) {
                    language = EmbedCommand.Language.PLSQL;
                }
                EmbedCommand embedCommand = new EmbedCommand(context2, jComboBox.getSelectedIndex() == 1, language);
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                try {
                    if (commandProcessor.invoke((Command)embedCommand) == 1) {
                        booleanArray[0] = new Boolean(true);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
        return booleanArray[0];
    }
}

