/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.JComponent;
import oracle.ide.inspector.AbstractPropertyInspectorPanel;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyCategoryPanel;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.ScrollablePanelDelegate;
import oracle.ide.inspector.find.ContainerSearch;

final class PropertyGroupPanel
extends AbstractPropertyInspectorPanel
implements PropertyCategoryPanel {
    private final String group;
    private ContainerSearch containerSearch;
    private final ScrollablePanelDelegate scrollablePanelDelegate = new ScrollablePanelDelegate(this);
    private boolean rendered;

    PropertyGroupPanel(String group) {
        this.group = group;
        this.updateTargetPanel(this);
    }

    @Override
    public boolean isRendered() {
        return this.rendered;
    }

    @Override
    public void render(Properties properties, Orientation orientation) {
        this.renderAll(properties.propertiesInGroup(this.group), orientation);
    }

    public void renderAll(Properties properties, Orientation orientation) {
        this.removeAll();
        this.rendered = true;
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.populateRows(properties, orientation);
        this.addToTargetPanel(Box.createVerticalStrut(7));
        RenderingUtils.addVerticalGlueTo(this, this.constraints());
    }

    private void populateRows(Properties properties, Orientation orientation) {
        this.setLayout(new GridBagLayout());
        properties.sort();
        for (PropertyInfo property : properties) {
            this.renderProperty(property, orientation);
            ++this.constraints().gridy;
        }
    }

    @Override
    public JComponent categoryPanel() {
        return this;
    }

    @Override
    public String categoryTitle() {
        return this.group;
    }

    @Override
    public boolean isDefaultSelected() {
        return false;
    }

    @Override
    public boolean isDefaultExpanded() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.scrollablePanelDelegate.preferredScrollableViewportSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.scrollablePanelDelegate.scrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.scrollablePanelDelegate.scrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.scrollablePanelDelegate.scrollableTracksViewportWidth();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.scrollablePanelDelegate.scrollableTracksViewportHeight();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.scrollablePanelDelegate.paintComponent(g);
    }

    @Override
    public boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        if (this.containerSearch == null) {
            this.containerSearch = new ContainerSearch(this);
        }
        return this.containerSearch.findText(searchText, searchForward, searchRepeat);
    }
}

