/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.addin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.RepaintManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.IDBConnectionComboBoxListener;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.addin.ReportEditorController;
import oracle.dbtools.raptor.report.navigatorV2.ReportEditorNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.dbtools.worksheet.extension.WorksheetConnectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;

public class ReportEditor
extends Editor
implements Controller,
IDBEditor {
    private DisplayPanel _panel;
    private Toolbar _toolbar;
    private DBConnectionComboBox _dbConns;
    private String _dbName;
    JEWTDialog dlg;
    private boolean _isPinned = false;
    private IdeAction pinAction;
    private JComboBox _timerInterval;
    private Timer _timer;
    private TimerTask _tt;
    private ArrayList<IdeAction> history = new ArrayList();
    MenuToolButton historyButton;
    public static final String HISTOY_CMD = "ReportEditor.HISTORY_CMD";
    public static final int HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)"ReportEditor.HISTORY_CMD");
    AbstractAction sqlWorksheet;
    AbstractAction run;
    private ToggleToolButton _pinToggle;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    public static final String REPORT_CONN_NAME = "report.conn.name";
    public static final String REPORT_PROG_BINDS = "report.prog.binds";
    private IDBConnectionComboBoxListener connectionComboBoxListener = new ConnectionComboBoxListener();

    public ReportEditor() {
        this.pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID);
        this.pinAction.addController((Controller)this);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_reporteditor_html");
    }

    public Object getPrintable() {
        return this._panel;
    }

    public JComboBox getTimer() {
        return this._timerInterval;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    public DisplayPanel getPanel() {
        return this._panel;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.init();
    }

    public Component getGUI() {
        this.updateContent();
        return this._panel;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public Component getFixedTopMargin() {
        return null;
    }

    public void openSQLEditor() {
        String string = this._panel.getModel().getQuery(this.getConnection()).getSql();
        OpenWorksheetWizard.openNewTempWorksheet((String)this._dbConns.getCurrentConnectionName(), (String)string);
    }

    private void buildToolbar() {
        if (this._toolbar.getComponentCount() == 0) {
            this._pinToggle = this._toolbar.addToggleButton((ToggleAction)this.pinAction);
            this.run = new AbstractAction(Messages.getString("ReportEditor.3"), OracleIcons.getIcon((String)"run.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ReportEditor.this._panel.promptForBindsOnNextRun(true);
                    ReportEditor.this._panel.refresh(true);
                }
            };
            this.run.putValue("ShortDescription", Messages.getString("ReportEditor.4"));
            this._toolbar.add((Action)this.run);
            this._toolbar.addSeparator();
            this.sqlWorksheet = new AbstractAction(Messages.getString("ReportEditor.5"), CommonArb.getIcon((String)"SQLWORKSHEET_ICON")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ReportEditor.this.openSQLEditor();
                }
            };
            this.sqlWorksheet.putValue("ShortDescription", Messages.getString("ReportEditor.6"));
            this._toolbar.add((Action)this.sqlWorksheet);
            this._dbConns.getJComboBox().setSize(50, 20);
            JLabel jLabel = new JLabel(Messages.getString("ReportEditor.7"));
            this._timerInterval = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._timerInterval.getModel();
            defaultComboBoxModel.addElement("0");
            defaultComboBoxModel.addElement("5");
            defaultComboBoxModel.addElement("10");
            defaultComboBoxModel.addElement("15");
            defaultComboBoxModel.addElement("20");
            defaultComboBoxModel.addElement("25");
            defaultComboBoxModel.addElement("30");
            defaultComboBoxModel.addElement("60");
            defaultComboBoxModel.addElement("120");
            this._timerInterval.setMaximumSize(this._timerInterval.getMinimumSize());
            this._timerInterval.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (ReportEditor.this._timer != null) {
                            ReportEditor.this._timer.cancel();
                            ReportEditor.this._timer = null;
                        }
                        if (ReportEditor.this._dbName == null || ReportEditor.this._dbName.length() <= 0) {
                            ReportEditor.this._timerInterval.setSelectedItem("0");
                        }
                        if (!ReportEditor.this._timerInterval.getSelectedItem().equals("0") && ReportEditor.this._dbName != null && ReportEditor.this._dbName.length() > 0) {
                            ReportEditor.this._timer = new Timer();
                            ReportEditor.this._tt = new TimerTask(){

                                @Override
                                public void run() {
                                    ReportEditor.this._panel.refresh(false, true);
                                    if (!ReportEditor.this.connectionOK(ReportEditor.this._panel.getConnection())) {
                                        ReportEditor.this._timer.cancel();
                                        ReportEditor.this._timer = null;
                                        ReportEditor.this._timerInterval.setSelectedItem("0");
                                    }
                                }
                            };
                            ReportEditor.this._timer.scheduleAtFixedRate(ReportEditor.this._tt, 0L, Long.parseLong((String)ReportEditor.this._timerInterval.getSelectedItem()) * 1000L);
                        }
                    }
                }
            });
            this._panel.setTimerInterval(this._timerInterval);
            this._toolbar.add((Component)jLabel);
            this._toolbar.add((Component)this._timerInterval);
            this._toolbar.addSeparator();
            int n = Ide.findOrCreateCmdID((String)"DRILL_UP.Back");
            IdeAction ideAction = IdeAction.get((int)n);
            this.historyButton = new MenuToolButton((ToggleAction)ideAction);
            this.historyButton.setEnabled(false);
            this.historyButton.setIcon(RaptorImage.getIcon((String)"navigate_back.gif"));
            this._toolbar.add((Component)this.historyButton);
            this._toolbar.add(Box.createHorizontalGlue());
            this._toolbar.add((Component)this._dbConns.getJComboBox(), (Object)"Center");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionOK(Connection connection) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            callableStatement = connection.prepareCall("select '1' from dual");
            resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private IdeAction getAction(DisplayModel displayModel) {
        String string = displayModel.getName();
        int n = Ide.findOrCreateCmdID((String)("DRILL_UP." + string));
        IdeAction ideAction = IdeAction.get((int)n);
        ideAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string));
        ideAction.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)string)));
        ideAction.putValue("ID", (Object)displayModel.getID());
        ideAction.putValue("BINDS", (Object)displayModel.getQueriesBindMap());
        ideAction.addController((Controller)this);
        return ideAction;
    }

    private void updateToolbar() {
        this.historyButton.removeAllPopupItems();
        for (IdeAction ideAction : this.history) {
            this.historyButton.addPopupItem((ToggleAction)ideAction);
        }
        if (this.history.size() > 0) {
            this.historyButton.setEnabled(true);
        } else {
            this.historyButton.setEnabled(false);
        }
        this.historyButton.setIcon(RaptorImagesArb.getIcon((String)"NAVIGATE_BACK"));
    }

    private Map<String, Object> getProgBinds() {
        Object object;
        Map map = null;
        Context context = this.getContext();
        if (context != null && (object = context.getProperty(REPORT_PROG_BINDS)) != null && object instanceof Map) {
            map = (Map)object;
        }
        return map;
    }

    private void init() {
        if (this._panel == null) {
            this._panel = new DisplayPanel(null);
            this._panel.setMainPanelBinds(this.getProgBinds());
            if (this.getContext() != null) {
                this._dbName = (String)this.getContext().getProperty(REPORT_CONN_NAME);
            }
            if (this._dbName == null) {
                this._dbName = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), (String)this._dbName, (boolean)true);
            }
            if (this._dbName == null) {
                this.close();
                return;
            }
            this._toolbar = this._panel.getToolbar();
            this._dbConns = new DBConnectionComboBox();
            this.buildToolbar();
            this._dbConns.setCurrentConnection(this._dbName);
            this._dbConns.addConnectionOpenListener(this.connectionComboBoxListener, null);
            Connections.getInstance().addConnectionListener(new ConnectionListener(){

                public void connectionAdded(ConnectionEvent connectionEvent) {
                }

                public void connectionOpened(ConnectionEvent connectionEvent) {
                }

                public void connectionClosed(ConnectionEvent connectionEvent) {
                }

                public void connectionRemoved(ConnectionEvent connectionEvent) {
                    String string = connectionEvent.getConnectionName();
                    if (string.equalsIgnoreCase(ReportEditor.this._dbName)) {
                        ReportEditor.this._dbName = null;
                    }
                    if (ReportEditor.this._timer != null && ReportEditor.this._dbName == null) {
                        ReportEditor.this._timer.cancel();
                    }
                }

                public void connectionRenamed(ConnectionEvent connectionEvent) {
                }

                public void connectionModified(ConnectionEvent connectionEvent) {
                }
            });
        }
    }

    public void enableDisableRefreshToolbar() {
        if (this._panel.isEnableRefresh()) {
            if (this._timerInterval != null && !this._timerInterval.isEnabled()) {
                this._timerInterval.setEnabled(true);
            }
        } else if (this._timerInterval != null) {
            if (!this._timerInterval.getSelectedItem().equals("0")) {
                this._timerInterval.setSelectedItem("0");
            }
            this._timerInterval.setEnabled(false);
            if (this._timer != null) {
                this._timer.cancel();
                this._timer = null;
            }
        }
    }

    public void updateContent() {
        ReportEditorNode reportEditorNode = (ReportEditorNode)this.getContext().getNode();
        ReportNode reportNode = reportEditorNode.getReportNode();
        try {
            if (this._dbName == null || reportNode == null || reportNode.getReport() == null) {
                return;
            }
            reportNode.getReport().setConnName(this._dbName);
            if (reportNode.getReport().hasChildren()) {
                for (DisplayModel displayModel : reportNode.getReport().getChildren()) {
                    displayModel.setConnName(this._dbName);
                }
            }
            if (this._panel.getModel() == null || this._panel.getModel() != null && this._panel.getModel() != reportNode.getReport()) {
                DisplayModel displayModel;
                if (reportNode.getReport().getParent() != null) {
                    this.history.add(this.getAction((DisplayModel)reportNode.getReport().getParent()));
                    this.updateToolbar();
                } else {
                    this.history.clear();
                    this.updateToolbar();
                }
                this._panel.close();
                DisplayModel displayModel2 = reportNode.getReport();
                displayModel = displayModel2.getQuery(displayModel2.getConnection());
                if (displayModel == null) {
                    this.sqlWorksheet.setEnabled(false);
                    this.run.setEnabled(false);
                    this._timerInterval.setEnabled(false);
                } else {
                    this.sqlWorksheet.setEnabled(true);
                    this.run.setEnabled(true);
                    this._timerInterval.setEnabled(true);
                }
                this._panel.setMainPanelBinds(this.getProgBinds());
                this._panel.setModel(displayModel2);
                this.buildToolbar();
                this.updateToolbar();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public void close() {
        super.close();
        this.history = new ArrayList();
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
        try {
            if (this.getContext() != null && this.getContext().getNode() != null && this.getContext().getNode().isOpen()) {
                this.getContext().getNode().close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        if (this._panel != null) {
            this._panel.close();
            this._panel = null;
        }
        this._dbConns.removeConnectionOpenListener();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void setPinned(boolean bl) {
        this._isPinned = bl;
    }

    public boolean getPinned() {
        return this._isPinned;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getValue("ID") != null) {
            int n;
            DisplayModel displayModel = DisplayModelCache.getDisplayModel((String)((String)ideAction.getValue("ID")));
            if (ideAction.getValue("BINDS") != null) {
                displayModel.setQueriesBindMap((Map)((HashMap)ideAction.getValue("BINDS")));
            }
            if ((n = this.history.indexOf(ideAction)) == 0) {
                this.history = new ArrayList();
            } else {
                ArrayList<IdeAction> arrayList = new ArrayList<IdeAction>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.history.get(i));
                }
                this.history = arrayList;
            }
            this.updateToolbar();
            ReportNavigatorContextMenu.getInstance().openReport(displayModel, false, (String)this.getContext().getProperty("ObjectAction.CONN_NAME"));
            return true;
        }
        this.setPinned(!this.getPinned());
        this.pinAction.setState(this.getPinned());
        if (!this.getPinned()) {
            this._pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
        } else {
            this._pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
        }
        return true;
    }

    public void editorShown() {
        ReportEditor.updateToolbarActions((Toolbar)this._toolbar);
        this.pinAction.setState(this.getPinned());
        if (!this.getPinned()) {
            this._pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
        } else {
            this._pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
        }
        this.enableDisableRefreshToolbar();
    }

    public void editorHidden() {
        ReportEditor.updateToolbarActions((Toolbar)this._toolbar);
        this.pinAction.setState(this.getPinned());
        this.enableDisableRefreshToolbar();
    }

    public void open() {
    }

    public Database getDatabase() {
        try {
            return Connections.getInstance().getDatabase(this.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            return null;
        }
    }

    public Connection getConnection() {
        try {
            return Connections.getInstance().getConnection(this.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            return null;
        }
    }

    public String getConnectionName() {
        return this._dbConns.getCurrentConnectionName();
    }

    public void setConnectionName(String string) {
        this._dbConns.setCurrentConnection(string);
        this._dbName = string;
    }

    public Controller getController() {
        return ReportEditorController.getInstance();
    }

    public DBConnectionComboBox getDBSelector() {
        return this._dbConns;
    }

    public void onCloseConnection() {
        this._dbConns.setCurrentConnection(null);
        this.run.setEnabled(false);
    }

    private class ConnectionComboBoxListener
    implements IDBConnectionComboBoxListener {
        String currentDb;

        private ConnectionComboBoxListener() {
            this.currentDb = ReportEditor.this._dbName;
        }

        public void connectionOpening() {
            WorksheetConnectionListener.isOpenable = false;
            if (ReportEditor.this._timer != null) {
                ReportEditor.this._timer.cancel();
                ReportEditor.this._timer = null;
                ReportEditor.this._timerInterval.setSelectedItem("0");
            }
        }

        public void connectionOpened(Connection connection) {
            ReportEditor.this.run.setEnabled(true);
            ReportEditor.this._dbName = Connections.getInstance().getConnectionName(connection);
            if (ReportEditor.this.getContext().getNode() != null && ReportEditor.this.getContext().getNode() instanceof ReportEditorNode) {
                boolean bl = true;
                Map map = ((ReportEditorNode)ReportEditor.this.getContext().getNode()).getReportNode().getReport().getExtAttributes();
                if (map == null || map.get("connType") == null || !((String)map.get("connType")).equals("Oracle")) {
                    bl = false;
                }
                if (map != null && map.get("requiredLic") != null && ((String)map.get("requiredLic")).equals("diagnostics") && !LicenseUtils.requiresDiag((String)ReportEditor.this._dbName)) {
                    return;
                }
                if (ReportEditor.this._dbName != null && !ReportEditor.this._dbName.equals("") && !Connections.getInstance().isOracle(ReportEditor.this._dbName) && bl) {
                    ReportEditor.this._dbName = this.currentDb;
                    ReportEditor.this._dbConns.setCurrentConnection(ReportEditor.this._dbName);
                    ReportAddin.showOracleOnlyReportMessage((Component)ReportEditor.this._panel);
                    return;
                }
                if (this.currentDb != ReportEditor.this._dbName) {
                    ReportEditor.this._panel.setModel(null);
                }
            }
            if (this.currentDb != ReportEditor.this._dbName) {
                ReportEditor.this.updateContent();
            }
        }

        public void connectionFailed(RaptorTaskEvent raptorTaskEvent) {
            ReportEditor.this._dbConns.setCurrentConnection(this.currentDb);
            ReportEditor.this.run.setEnabled(this.currentDb != null);
            RaptorTaskUtils.showErrorMessage((String)this.currentDb, (Component)ReportEditor.this._panel, (RaptorTaskDescriptor)raptorTaskEvent.getTaskDescriptor(), (boolean)true);
        }

        public void connectionCanceled(RaptorTaskEvent raptorTaskEvent) {
            ReportEditor.this._dbConns.setCurrentConnection(this.currentDb);
            ReportEditor.this.run.setEnabled(this.currentDb != null);
            RaptorTaskUtils.showErrorMessage((String)this.currentDb, (Component)ReportEditor.this._panel, (RaptorTaskDescriptor)raptorTaskEvent.getTaskDescriptor(), (boolean)true);
        }
    }
}

