/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.util;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.SecretKey;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSSKeyRetriever
extends KeyRetriever {
    protected X509Certificate retrieveCertificate(KeyInfoData keyInfo) throws KeyRetrievalException {
        try {
            return this.processCert(keyInfo);
        }
        catch (WSSException ex) {
            throw new KeyRetrievalException((Throwable)((Object)ex));
        }
    }

    protected PublicKey retrievePublicKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        try {
            X509Certificate cert = this.processCert(keyInfo);
            if (cert != null) {
                return cert.getPublicKey();
            }
            return null;
        }
        catch (WSSException ex) {
            throw new KeyRetrievalException((Throwable)((Object)ex));
        }
    }

    protected PrivateKey retrievePrivateKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        try {
            return this.processPrivateKey(keyInfo);
        }
        catch (WSSException ex) {
            throw new KeyRetrievalException((Throwable)((Object)ex));
        }
    }

    protected SecretKey retrieveSymmetricKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        try {
            return this.processSymmetricKey(keyInfo);
        }
        catch (WSSException ex) {
            throw new KeyRetrievalException((Throwable)((Object)ex));
        }
    }

    public X509Certificate processCert(KeyInfoData kid) throws WSSException {
        X509Certificate cert = null;
        if (kid instanceof WSSecurityTokenReference) {
            Object obj;
            WSSecurityTokenReference str = (WSSecurityTokenReference)kid;
            WSSecurityTokenReferenceType stref = str.getSTReference();
            if (stref instanceof SAMLAssertionKeyIdentifier && (cert = ((SAMLAssertionKeyIdentifier)stref).getPublicKey()) != null) {
                return cert;
            }
            if (stref instanceof SAML2AssertionKeyIdentifier && (cert = ((SAML2AssertionKeyIdentifier)stref).getPublicKey()) != null) {
                return cert;
            }
            WSSecurityToken token = stref.getSecurityToken();
            if (token == null) {
                return null;
            }
            if (token instanceof SAMLAssertionToken) {
                Assertion assertion = (Assertion)((SAMLAssertionToken)token).getToken();
                NodeList nl = assertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
                int nlen = nl.getLength();
                for (int ii = 0; ii < nlen && nlen > 0; ++ii) {
                    Vector v;
                    NodeList enl = XMLElement.getChildElementsByTagNameNS((Element)((Element)nl.item(ii)), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"KeyInfo");
                    int enlen = nl.getLength();
                    if (enlen == 0 || enlen > 1) {
                        return null;
                    }
                    XSKeyInfo xk = new XSKeyInfo((Element)enl.item(0));
                    if (!xk.getType().equals("http://www.w3.org/2000/09/xmldsig#X509Data") || (v = xk.getX509Data()) == null || v.size() <= 0) continue;
                    for (int x = 0; x < v.size(); ++x) {
                        X509Data xd = (X509Data)v.elementAt(x);
                        try {
                            Vector cc = xd.getCertificates();
                            if (v == null || v.size() <= 0) continue;
                            return (X509Certificate)cc.elementAt(0);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            if ((obj = token.getToken()) instanceof X509Certificate) {
                cert = (X509Certificate)obj;
            }
        }
        return cert;
    }

    public PrivateKey processPrivateKey(KeyInfoData kid) throws WSSException {
        WSSecurityTokenReference str;
        WSSecurityTokenReferenceType stref;
        Object obj;
        PrivateKey pk = null;
        if (kid instanceof WSSecurityTokenReference && (obj = (stref = (str = (WSSecurityTokenReference)kid).getSTReference()).getKey()) instanceof PrivateKey) {
            pk = (PrivateKey)obj;
        }
        return pk;
    }

    public SecretKey processSymmetricKey(KeyInfoData kid) throws WSSException {
        SecretKey sk = null;
        if (kid instanceof WSSecurityTokenReference) {
            WSSecurityTokenReference str = (WSSecurityTokenReference)kid;
            WSSecurityTokenReferenceType stref = str.getSTReference();
            sk = (SecretKey)stref.getKey();
        }
        return sk;
    }
}

