/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.export.service.ExportServicesRegistry;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.util.Logger;

public class ExportAPI {
    private ExitCode _exitCode;
    private ExportParms _eParms;
    private IToolRunMode _tRunMode;
    private ExportService _eService;

    public ExitCode start(ExportParms eParms, IToolRunMode tRunMode) {
        this._eParms = eParms;
        this._tRunMode = tRunMode;
        try {
            if (this.getRegisteredService() == ExitCode.EXIT_SUCCESS || this.getRegisteredService() == ExitCode.EXIT_WARNING) {
                this._exitCode = this._eService.start(this._eParms, this._tRunMode);
            }
        }
        catch (Exception e) {
            this._exitCode = ExitCode.EXIT_SEVERE;
            this._exitCode.setMessage(this._exitCode.getMessage() + " " + e.toString());
            return ExitCode.EXIT_SEVERE;
        }
        return this._exitCode;
    }

    public ExitCode validate() {
        return this._eService.validate();
    }

    public void export() {
        try {
            this._eService.export();
        }
        catch (Exception e1) {
            Logger.warn(ExportAPI.class, (Throwable)e1);
            this._eService.eLogException(e1);
            ExceptionHandler.handleException((Throwable)e1);
        }
    }

    public void finish() {
        this._eService.finish();
    }

    protected ExportService getService() {
        return this._eService;
    }

    private ExitCode getRegisteredService() {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        if (ExportServicesRegistry.isServiceRegistered(this._eParms.getServiceType())) {
            this._eService = ExportServicesRegistry.getService(this._eParms.getServiceType());
            if (this._eService != null) {
                return exitCode;
            }
        }
        String msg = ExportResources.format("EXPORT_SERVICE_NOT_AVAIL", this._eParms.getServiceType().toString());
        Logger.severe(ExportAPI.class, (String)msg);
        exitCode = ExitCode.EXIT_SEVERE;
        exitCode.setMessage(msg);
        return exitCode;
    }

    protected IToolRunMode getRunMode() {
        return this._tRunMode;
    }

    protected void setRunMode(IToolRunMode tRunMode) {
        this._tRunMode = tRunMode;
    }
}

