/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;

public abstract class StackedIterator
implements Iterator {
    private Object contextNode;
    private LinkedList iteratorStack = new LinkedList();
    private Navigator navigator;
    private Set created = new HashSet();

    public StackedIterator(Object object, Navigator navigator) {
        this.init(object, navigator);
    }

    protected StackedIterator() {
    }

    protected void init(Object object, Navigator navigator) {
        this.contextNode = object;
        this.navigator = navigator;
        this.pushIterator(this.internalCreateIterator(object));
    }

    private Iterator internalCreateIterator(Object object) {
        if (this.created.contains(object)) {
            return null;
        }
        this.created.add(object);
        return this.createIterator(object);
    }

    @Override
    public boolean hasNext() {
        Iterator iterator = this.currentIterator();
        if (iterator == null) {
            return false;
        }
        return iterator.hasNext();
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iterator iterator = this.currentIterator();
        Object e = iterator.next();
        this.pushIterator(this.internalCreateIterator(e));
        return e;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected abstract Iterator createIterator(Object var1);

    protected void pushIterator(Iterator iterator) {
        if (iterator != null) {
            this.iteratorStack.addLast(iterator);
        }
    }

    private Iterator currentIterator() {
        while (this.iteratorStack.size() > 0) {
            Iterator iterator = (Iterator)this.iteratorStack.getFirst();
            if (iterator.hasNext()) {
                return iterator;
            }
            this.iteratorStack.removeFirst();
        }
        return null;
    }

    protected Navigator getNavigator() {
        return this.navigator;
    }
}

