/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;

public class BooleanExpression
implements SearchExpression {
    private boolean _caseSensitive;
    private int _operator;
    private SearchExpression _expr1;
    private SearchExpression _expr2;

    public BooleanExpression(SearchExpression expr1, SearchExpression expr2, int operator, boolean caseSensitive) {
        this._expr1 = expr1;
        this._expr2 = expr2;
        this._operator = operator;
        this._caseSensitive = caseSensitive;
    }

    @Override
    public SearchExpression getExpression1() {
        return this._expr1;
    }

    @Override
    public SearchExpression getExpression2() {
        return this._expr2;
    }

    @Override
    public String[] getData() {
        return null;
    }

    @Override
    public int getOperator() {
        return this._operator;
    }

    @Override
    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    @Override
    public void print() {
        if (this._expr1 == null) {
            return;
        }
        this._expr1.print();
        switch (this._operator) {
            case 2: {
                System.out.println("OR");
                break;
            }
            case 1: {
                System.out.println("AND");
                break;
            }
            case 3: {
                System.out.println("NOT");
                break;
            }
            case 4: {
                System.out.println("NAND");
                break;
            }
            default: {
                if (this._expr2 == null) break;
                System.out.println("Unknown operator");
            }
        }
        if (this._expr2 != null) {
            this._expr2.print();
        }
    }

    public static SearchExpression buildExpressionTree(String buffer, boolean caseSensitive) throws SearchException {
        boolean debug = false;
        SearchExpression searchExpression = null;
        try {
            int count = 0;
            int i = 0;
            boolean space = true;
            for (i = 0; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (Character.isSpaceChar(c)) {
                    if (!space) {
                        ++count;
                    }
                    space = true;
                    continue;
                }
                if (c == '(' || c == ')' || c == '+' || c == '-' || c == '\"') {
                    if (!space) {
                        ++count;
                    }
                    ++count;
                    space = true;
                    continue;
                }
                space = false;
            }
            if (!space) {
                ++count;
            }
            space = true;
            int begin = -1;
            String[] words = new String[count];
            count = 0;
            for (i = 0; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (Character.isSpaceChar(c)) {
                    if (!space) {
                        words[count++] = caseSensitive ? buffer.substring(begin, i) : buffer.substring(begin, i).toLowerCase();
                        begin = -1;
                    }
                    space = true;
                    continue;
                }
                if (c == '(' || c == ')' || c == '+' || c == '-' || c == '\"') {
                    if (!space) {
                        words[count++] = caseSensitive ? buffer.substring(begin, i) : buffer.substring(begin, i).toLowerCase();
                    }
                    words[count++] = Character.toString(c);
                    begin = -1;
                    space = true;
                    continue;
                }
                if (begin == -1) {
                    begin = i;
                }
                space = false;
            }
            if (!space) {
                String string = words[count++] = caseSensitive ? buffer.substring(begin, i) : buffer.substring(begin, i).toLowerCase();
            }
            if (words.length == 1) {
                searchExpression = new StringExpression(words, caseSensitive);
            } else {
                int[] startIndex = new int[]{0};
                searchExpression = BooleanExpression._buildExpressionTree(words, startIndex, caseSensitive);
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to parse boolean expression: " + buffer, e);
        }
        return searchExpression;
    }

    private static SearchExpression _buildExpressionTree(String[] words, int[] startIndex, boolean caseSensitive) throws IllegalArgumentException {
        int i = startIndex[0];
        SearchExpression expr1 = null;
        SearchExpression expr2 = null;
        boolean inparan = false;
        int operator = 0;
        boolean debug = false;
        if (words[i].equals("+")) {
            ++i;
        }
        if (words[i].equals("(")) {
            startIndex[0] = i + 1;
            expr1 = BooleanExpression._buildExpressionTree(words, startIndex, caseSensitive);
            inparan = true;
        } else {
            int j;
            if (BooleanExpression.isBooleanOperator(words[i]) == 1 || BooleanExpression.isBooleanOperator(words[i]) == 2 || words[i].equals(")")) {
                throw new IllegalArgumentException("invalid boolean expression");
            }
            if (BooleanExpression.isBooleanOperator(words[i]) == 3 || words[i].equals("-")) {
                startIndex[0] = i + 1;
                expr1 = BooleanExpression._buildExpressionTree(words, startIndex, caseSensitive);
                return new BooleanExpression(expr1, null, 3, caseSensitive);
            }
            if (i == words.length) {
                throw new IllegalArgumentException("invalid boolean expression " + i);
            }
            for (j = i + 1; j < words.length && BooleanExpression.isBooleanOperator(words[j]) == 0 && !words[j].equals(")"); ++j) {
            }
            String[] exp = new String[j - i];
            for (int k = i; k < j; ++k) {
                exp[k - i] = words[k];
            }
            expr1 = new StringExpression(exp, caseSensitive);
            startIndex[0] = j;
            if (j == words.length) {
                return expr1;
            }
        }
        i = startIndex[0];
        if (inparan && words[i].equals(")")) {
            inparan = false;
            if (++i == words.length) {
                startIndex[0] = words.length;
                return expr1;
            }
        }
        if (!inparan && words[i].equals(")")) {
            startIndex[0] = i;
            return expr1;
        }
        operator = BooleanExpression.isBooleanOperator(words[i]);
        if (operator == 0) {
            throw new IllegalArgumentException("invalid boolean expression");
        }
        if (operator == 3) {
            operator = 4;
        }
        startIndex[0] = i + 1;
        expr2 = BooleanExpression._buildExpressionTree(words, startIndex, caseSensitive);
        return new BooleanExpression(expr1, expr2, operator, caseSensitive);
    }

    public static int isBooleanOperator(String word) {
        if (word.equalsIgnoreCase("AND") || word.equals("+")) {
            return 1;
        }
        if (word.equalsIgnoreCase("OR")) {
            return 2;
        }
        if (word.equalsIgnoreCase("NOT") || word.equals("-")) {
            return 3;
        }
        return 0;
    }
}

