/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;

public class WindowCoordinate {
    private int _value;
    private boolean _isNegative;
    private boolean _isPercent;
    private boolean _horizontal;

    public WindowCoordinate(int value, boolean isNegative, boolean isPercent, boolean horizontal) {
        this._value = value;
        this._isNegative = isNegative;
        this._isPercent = isPercent;
        this._horizontal = horizontal;
    }

    public int getValue(int offset, Component window) {
        int screenDimension;
        Dimension screenSize;
        Toolkit toolkit;
        int retValue = this._value;
        if (this._isPercent) {
            toolkit = window.getToolkit();
            screenSize = toolkit.getScreenSize();
            screenDimension = this._horizontal ? screenSize.width : screenSize.height;
            double percent = (double)retValue / 100.0;
            retValue = (int)((double)screenDimension * percent);
        }
        if (this._isNegative) {
            toolkit = Toolkit.getDefaultToolkit();
            screenSize = toolkit.getScreenSize();
            screenDimension = this._horizontal ? screenSize.width : screenSize.height;
            retValue = screenDimension - retValue - offset;
        }
        return retValue;
    }

    public int getOriginalValue() {
        return this._value;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public boolean isPercent() {
        return this._isPercent;
    }

    public String getTextValue() {
        Object coordinate = this._isNegative ? "-" : "";
        coordinate = (String)coordinate + this._value;
        if (this._isPercent) {
            coordinate = (String)coordinate + "%";
        }
        return coordinate;
    }
}

