/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.message;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.exports.file.PathKey;

public class Tag
implements Comparable<Tag> {
    private final String id;
    private final Object value;
    private static final Set<String> TAG_IDS = Collections.synchronizedSet(new HashSet());

    public static Set<String> tagIds() {
        return TAG_IDS;
    }

    public Tag(String id, Object value) {
        if (value instanceof Path && ((Path)value).getFileSystem() != FileSystems.getDefault()) {
            value = new PathKey((Path)value);
        }
        this.id = id;
        this.value = value;
        TAG_IDS.add(id);
    }

    public String getId() {
        return this.id;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Tag that) {
        return this.id.compareTo(that.id);
    }

    public boolean equals(Object that) {
        return that instanceof Tag && this.id.equals(((Tag)that).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.valueOf(this.id);
    }
}

