/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.library.LibraryScope;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.specification.ExportLinkage;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.SpecificationScope;
import org.xml.sax.SAXException;

public class ClassPathEntry {
    private final URLKey urlKey;
    private final ExportLinkage exportLinkage;
    private final String libraryLinkageKey;
    private final boolean manifestExport;
    private final int line;
    private final LibraryDependency dependency;
    private final ClassPathEntry manifestEntry;
    private Object resolvingLibrary;
    private ExportSpecification exportSpecification;
    private Map<String, String> embeddedRemediationComments;
    private boolean manifestClassPath;
    private boolean resolved;

    public ClassPathEntry(URL url, ExportLinkage exportLinkage, String key, boolean manifestExport, int line) {
        this.urlKey = URLKey.getInstance(url);
        this.exportLinkage = exportLinkage;
        this.libraryLinkageKey = key != null ? key : "";
        this.manifestExport = manifestExport;
        this.line = line;
        this.manifestEntry = null;
        this.dependency = null;
        boolean bl = this.resolved = exportLinkage == ExportLinkage.NULL;
        if (this.resolved) {
            this.embeddedRemediationComments = Collections.emptyMap();
        }
    }

    ClassPathEntry(URL url, ClassPathEntry manifestEntry, ClassPathEntry suppliedEntry) {
        this.urlKey = URLKey.getInstance(url);
        this.exportLinkage = suppliedEntry.exportLinkage;
        this.libraryLinkageKey = "";
        this.manifestExport = false;
        this.manifestClassPath = false;
        this.line = suppliedEntry.line;
        this.manifestEntry = manifestEntry;
        this.resolved = true;
        this.resolvingLibrary = suppliedEntry.resolvingLibrary;
        this.dependency = null;
        this.exportSpecification = suppliedEntry.isManifestExport() ? suppliedEntry.exportSpecification : null;
        this.embeddedRemediationComments = suppliedEntry.isManifestExport() ? suppliedEntry.embeddedRemediationComments : Collections.emptyMap();
    }

    ClassPathEntry(LibraryDependency dependency, URL url, ClassPathEntry dependencyEntry) {
        boolean DE = dependencyEntry != null;
        boolean DEX = DE && dependency.isReexported();
        this.urlKey = URLKey.getInstance(url);
        this.exportLinkage = DEX ? dependencyEntry.exportLinkage : ExportLinkage.NULL;
        this.libraryLinkageKey = "";
        this.manifestExport = false;
        this.manifestClassPath = false;
        this.line = -1;
        this.manifestEntry = DE ? dependencyEntry.manifestEntry : null;
        this.dependency = dependency;
        this.resolvingLibrary = dependency.getLibrary();
        this.resolved = true;
        if (DE) {
            ExportSpecification es = dependencyEntry.exportSpecification;
            this.exportSpecification = DEX ? es : (es != null ? new ExportSpecification(es.getScope(), es.getOwner(), es.getSource(), es.getConsumers(), es.getDomain(), Collections.emptyMap()) : null);
        } else {
            this.exportSpecification = null;
        }
        this.embeddedRemediationComments = DEX ? dependencyEntry.embeddedRemediationComments : Collections.emptyMap();
    }

    Merge<ClassPathEntry> merge(ClassPathEntry that, String type) {
        if (!that.resolved) {
            throw new IllegalStateException("this not resolved: " + this);
        }
        if (!this.resolved) {
            throw new IllegalStateException("that not resolved: " + that);
        }
        Merge<ClassPathEntry> merge = new Merge<ClassPathEntry>(this, that, "%s %s", type, this.urlKey);
        ExportSpecification thisSpecification = this.exportSpecification;
        ExportSpecification thatSpecification = that.exportSpecification;
        Merge<ExportSpecification> specificationMerge = ExportSpecification.merge(new Scope("entry merge"), thisSpecification, thatSpecification);
        merge.addMerge(specificationMerge);
        this.exportSpecification = specificationMerge.getValue();
        merge.complete(this);
        return merge;
    }

    static ClassPathEntry merge(ClassPathEntry predecessor, ClassPathEntry successor, Merge<Void> merge) {
        if (!predecessor.resolved) {
            throw new IllegalStateException("that not resolved: " + successor);
        }
        if (!successor.resolved) {
            throw new IllegalStateException("this not resolved: " + predecessor);
        }
        Merge<ClassPathEntry> entryMerge = new Merge<ClassPathEntry>(predecessor, successor, "%s %s", "duplicated supplied entry", predecessor.urlKey);
        ExportSpecification thisSpecification = predecessor.exportSpecification;
        ExportSpecification thatSpecification = successor.exportSpecification;
        Merge<ExportSpecification> specificationMerge = ExportSpecification.merge(new Scope("entry merge"), thisSpecification, thatSpecification);
        entryMerge.addMerge(specificationMerge);
        predecessor.exportSpecification = specificationMerge.getValue();
        successor.exportSpecification = specificationMerge.getValue();
        entryMerge.complete(predecessor);
        merge.addMerge(entryMerge);
        return predecessor;
    }

    public URL getUrl() {
        return this.urlKey.toURL();
    }

    public URLKey getUrlKey() {
        return this.urlKey;
    }

    public ExportLinkage getExportLinkage() {
        return this.exportLinkage;
    }

    public boolean isSupplied() {
        return this.manifestEntry == null && this.dependency == null;
    }

    public boolean isManifest() {
        return this.manifestEntry != null;
    }

    public boolean isDependency() {
        return this.dependency != null;
    }

    public String getLibraryLinkageKey() {
        return this.libraryLinkageKey;
    }

    public boolean isManifestClassPath() {
        return this.manifestClassPath;
    }

    public boolean isManifestExport() {
        return this.manifestExport;
    }

    public LibraryDependency getDependency() {
        return this.dependency;
    }

    public void resolve(FileExportLibrary library, Map<String, ExportSpecification> libraryExportSpecifications, ExportSpecificationReader specificationReader, RemediationCommentsReader commentsReader, Log log) {
        if (this.resolved) {
            return;
        }
        this.resolvingLibrary = library;
        this.resolved = true;
        URL url = this.urlKey.toURL();
        LibraryScope libraryScope = new LibraryScope(null, library);
        switch (this.exportLinkage) {
            case NONE: {
                this.exportSpecification = new ExportSpecification(new SpecificationScope((Scope)libraryScope, ExportLinkage.NONE), CompatibilityAccess.CONCEALED, specificationReader.getExportDomain());
                break;
            }
            case EMBEDDED: {
                URL specificationUrl = URLFactory.newURL(url, "META-INF/lib-exports.xml");
                try {
                    this.exportSpecification = specificationReader.read(new SpecificationScope(libraryScope, ExportLinkage.EMBEDDED, null, specificationUrl, null), specificationUrl, URLFileSystem.openInputStream(specificationUrl), log);
                }
                catch (FileNotFoundException e) {
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, ExportLinkage.EMBEDDED, null, url, e.getMessage()), CompatibilityAccess.CONCEALED, specificationReader.getExportDomain());
                    if (URLFileSystem.isRegularFile(url)) {
                        log.error("library-entry-embedded", "embedded export specification META-INF/lib-exports.xml not found in %s (%s:%d)", URLFileSystem.getPlatformPathName(url), URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                        break;
                    }
                    log.error("library-entry-embedded", "entry with embedded export specification not found at %s (%s:%d)", URLFileSystem.getPlatformPathName(url), URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, ExportLinkage.EMBEDDED, null, url, e.getMessage()), CompatibilityAccess.CONCEALED, specificationReader.getExportDomain());
                    log.error("library-entry-embedded", "embedded export specification META-INF/lib-exports.xml not read at %s: %s (%s:%d)", URLFileSystem.getPlatformPathName(url), e, URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                }
                break;
            }
            case LIBRARY: {
                this.exportSpecification = libraryExportSpecifications.get(this.libraryLinkageKey);
                if (this.exportSpecification != null) break;
                if (libraryExportSpecifications.containsKey(this.libraryLinkageKey)) {
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, ExportLinkage.LIBRARY, this.libraryLinkageKey, null, "failed"), CompatibilityAccess.CONCEALED, specificationReader.getExportDomain());
                    break;
                }
                if (this.libraryLinkageKey.isEmpty()) {
                    log.error("library-entry-key", "<export-specification> element with default key (no key attribute or key=\"\") not found (%s:%d)", URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, ExportLinkage.LIBRARY, this.libraryLinkageKey, null, "missing"), CompatibilityAccess.CONCEALED, specificationReader.getExportDomain());
                    break;
                }
                log.error("library-entry-key", "<export-specification> element with key=\"%s\" not found (%s:%d)", this.libraryLinkageKey, URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, ExportLinkage.LIBRARY, this.libraryLinkageKey, null, "missing"), CompatibilityAccess.CONCEALED, specificationReader.getExportDomain());
                break;
            }
            case ALL: {
                this.exportSpecification = new ExportSpecification(new SpecificationScope((Scope)libraryScope, ExportLinkage.ALL), CompatibilityAccess.EXPORTED, specificationReader.getExportDomain());
                break;
            }
            default: {
                this.exportSpecification = null;
            }
        }
        switch (this.exportLinkage) {
            case EMBEDDED: {
                URL commentUrl = URLFactory.newURL(url, "META-INF/lib-comments.xml");
                try {
                    this.embeddedRemediationComments = commentsReader.read(commentUrl, URLFileSystem.openInputStream(commentUrl), log);
                }
                catch (FileNotFoundException e) {
                    this.embeddedRemediationComments = Collections.emptyMap();
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.embeddedRemediationComments = Collections.emptyMap();
                    log.error("embedded-comments-not-read", "embedded remediation comments file META-INF/lib-comments.xml not read in %s: %s (%s:%d)", URLFileSystem.getPlatformPathName(url), e, URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                }
                break;
            }
            default: {
                this.embeddedRemediationComments = Collections.emptyMap();
            }
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    void markManifestClassPath() {
        this.manifestClassPath = true;
    }

    public boolean hasManifestClassPath() {
        if (!this.resolved) {
            throw new IllegalStateException("entry not resolved");
        }
        return this.manifestClassPath;
    }

    public ExportSpecification getResolvedExportSpecification() {
        if (!this.resolved) {
            throw new IllegalStateException("entry not resolved");
        }
        return this.exportSpecification;
    }

    public Map<String, String> getResolvedRemediationComments() {
        if (!this.resolved) {
            throw new IllegalStateException("entry not resolved");
        }
        return this.embeddedRemediationComments;
    }

    public boolean equals(Object that) {
        return that instanceof ClassPathEntry && this.urlKey.equals(((ClassPathEntry)that).urlKey);
    }

    public int hashCode() {
        return this.urlKey.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isSupplied()) {
            builder.append("supplied");
        } else if (this.isManifest()) {
            builder.append("manifest");
        }
        if (this.isDependency()) {
            builder.append(" dependency");
        }
        builder.append(' ').append((Object)this.exportLinkage).append(" entry ").append(URLFileSystem.getPlatformPathName(this.urlKey.toURL()));
        return builder.toString();
    }
}

