/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.extension;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ExportLibraryReader;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.message.Log;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionManifestReader
extends DefaultHandler
implements Consumer<FileExportLibrary> {
    private SAXParser parser;
    private ExportLibraryReader libraryReader;
    private Path manifestPath;
    private Path contextPath;
    private Map<String, String> macros;
    private List<FileExportLibrary> libraries;
    private Map<String, String> aliasToName;
    private Log log;
    private Locator locator;
    private State state = State.VOID;
    private String extensionId;
    private int depth;
    private State libraryState;
    private int ignoringDepth;
    private StringBuilder text;

    public ExtensionManifestReader(ExportLibraryReader libraryReader) {
        this.libraryReader = libraryReader;
    }

    public ExportLibraryReader getLibraryReader() {
        return this.libraryReader;
    }

    public void scan(Path manifestPath, Map<String, String> macros, List<FileExportLibrary> libraries, Map<String, String> aliasToName, Log log) throws ParserConfigurationException, SAXException, IOException {
        this.manifestPath = manifestPath;
        Path jarPath = Paths.getDefaultPath(manifestPath);
        this.contextPath = jarPath.getParent();
        this.macros = macros;
        if (this.parser == null) {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        this.libraries = libraries;
        this.aliasToName = aliasToName;
        this.log = log;
        this.state = State.VOID;
        this.depth = 0;
        try (InputStream stream = Files.newInputStream(manifestPath, new OpenOption[0]);){
            this.parser.parse(stream, (DefaultHandler)this);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case VOID: {
                if ("extension".equals(qName)) {
                    this.extensionId = attributes.getValue("id");
                    break;
                }
                if (!"libraries".equals(qName) && !"shared-libraries".equals(qName)) break;
                this.state = State.LIBRARIES;
                break;
            }
            case LIBRARIES: {
                if ("alias".equals(qName)) {
                    this.state = State.ALIAS;
                    String from = attributes.getValue("from");
                    String to = attributes.getValue("to");
                    if (from == null || to == null) break;
                    this.aliasToName.put(from, to);
                    break;
                }
                if ("library".equals(qName)) {
                    this.libraryReader.beginExtension(this.manifestPath, this.contextPath, this.extensionId, this.macros, this, this.log);
                    this.libraryReader.setDocumentLocator(this.locator);
                    this.parser.getXMLReader().setContentHandler(this.libraryReader);
                    this.libraryReader.startElement(uri, localName, qName, attributes);
                    break;
                }
                if ("jdk".equals(qName)) {
                    this.state = State.JDK;
                    this.libraryState = State.JDK;
                    break;
                }
                this.state = State.IGNORING;
                this.ignoringDepth = this.depth;
                break;
            }
            case LIBRARY: 
            case JDK: {
                if ("classpath".equals(qName)) {
                    this.state = State.CLASSPATH;
                    this.text = new StringBuilder();
                    break;
                }
                if ("endorsed-dirs".equals(qName)) {
                    this.state = State.ENDORSED_DIRS;
                    this.text = new StringBuilder();
                    break;
                }
                if ("srcpath".equals(qName)) {
                    this.state = State.SRCPATH;
                    break;
                }
                if ("docpath".equals(qName)) {
                    this.state = State.DOCPATH;
                    break;
                }
                throw new SAXException("<" + qName + "> element not expected in <library> element" + this.at());
            }
            case IGNORING: {
                break;
            }
            case ALIAS: 
            case CLASSPATH: 
            case ENDORSED_DIRS: 
            case DOCPATH: 
            case SRCPATH: {
                throw new SAXException("<" + qName + "> element not expected in <" + this.state.toString().toLowerCase().replace('_', '-') + "> element" + this.at());
            }
        }
        ++this.depth;
    }

    @Override
    public void characters(char[] text, int offset, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(text, offset, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        switch (this.state) {
            case VOID: {
                break;
            }
            case LIBRARIES: {
                this.state = State.VOID;
                break;
            }
            case LIBRARY: 
            case JDK: {
                this.state = State.LIBRARIES;
                break;
            }
            case CLASSPATH: {
                this.text = null;
                this.state = this.libraryState;
                break;
            }
            case ENDORSED_DIRS: {
                this.text = null;
                this.state = this.libraryState;
                break;
            }
            case DOCPATH: 
            case SRCPATH: {
                this.state = this.libraryState;
                break;
            }
            case IGNORING: {
                if (this.depth != this.ignoringDepth) break;
                this.state = State.LIBRARIES;
                break;
            }
            case ALIAS: {
                this.state = State.LIBRARIES;
            }
        }
    }

    @Override
    public void accept(FileExportLibrary library) {
        this.libraries.add(library);
        try {
            this.parser.getXMLReader().setContentHandler(this);
        }
        catch (SAXException e) {
            this.log.error("extension-content-handler", "Exception restoring content handler for %s: %s", this.manifestPath, e);
            e.printStackTrace();
        }
    }

    public String at() {
        return " (line " + this.locator.getLineNumber() + ", column " + this.locator.getColumnNumber() + ")";
    }

    private static enum State {
        VOID,
        LIBRARIES,
        ALIAS,
        IGNORING,
        LIBRARY,
        JDK,
        CLASSPATH,
        ENDORSED_DIRS,
        DOCPATH,
        SRCPATH;

    }
}

