/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Arrays {
    public static <T> List<T> asList(T ... elements) {
        return java.util.Arrays.asList(elements);
    }

    public static <T> List<T> asUnmodifiableList(T ... elements) {
        return elements.length > 0 ? Collections.unmodifiableList(java.util.Arrays.asList(elements)) : Collections.emptyList();
    }

    public static int binarySearch(Object[] a, Object key) {
        return java.util.Arrays.binarySearch(a, key);
    }

    public static <T> int binarySearch(T[] a, T key, Comparator<? super T> c) {
        return java.util.Arrays.binarySearch(a, key, c);
    }

    public static int binarySearch(Object[] a, int fromIndex, int toIndex, Object key) {
        return java.util.Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    public static <T> int binarySearch(T[] a, int fromIndex, int toIndex, T key, Comparator<? super T> c) {
        return java.util.Arrays.binarySearch(a, fromIndex, toIndex, key, c);
    }

    public static <T> boolean contains(T[] a, T element) {
        for (int i = 0; i < a.length; ++i) {
            if (!Objects.equals(element, a[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] a, int from, int to, T element) {
        for (int i = from; i < to; ++i) {
            if (!Objects.equals(element, a[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isContained(T element, T ... elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (!Objects.equals(element, elements[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(T element, T ... elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (!Objects.equals(element, elements[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T element, int fromIndex, T ... elements) {
        for (int i = fromIndex; i < elements.length; ++i) {
            if (!Objects.equals(element, elements[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T element, T ... elements) {
        int i = elements.length;
        while (--i >= 0) {
            if (!Objects.equals(element, elements[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T element, int fromIndex, T ... elements) {
        int i = fromIndex;
        while (--i >= 0) {
            if (!Objects.equals(element, elements[i])) continue;
            return i;
        }
        return -1;
    }

    public static void sort(Object[] a) {
        java.util.Arrays.sort(a);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        java.util.Arrays.sort(a, fromIndex, toIndex);
    }

    public static <T> void sort(T[] a, Comparator<? super T> c) {
        java.util.Arrays.sort(a, c);
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> c) {
        java.util.Arrays.sort(a, fromIndex, toIndex, c);
    }

    public static <T> Stream<T> stream(T[] array) {
        return java.util.Arrays.stream(array, 0, array.length);
    }

    public static <T> Stream<T> stream(T[] array, int startInclusive, int endExclusive) {
        return java.util.Arrays.stream(array, startInclusive, endExclusive);
    }

    public static String toString(Object[] array) {
        return java.util.Arrays.toString(array);
    }
}

