/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.command.ClassesSource;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandOutput;
import oracle.javatools.exports.data.DataFiles;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.name.NameFormat;

public class CommandInput {
    private CommandType commandType;
    private String copyrightText;
    private EnumMap<OutputType, Path> outputFiles;
    private Path middlewareHome;
    private String source;
    private String owner;
    private Set<String> consumers = Collections.emptySet();
    private Path domain;
    public static final Path FMW_DOMAIN = Paths.get("FMW", new String[0]);
    public static final Path UNIVERSAL_DOMAIN = Paths.get("ALL", new String[0]);
    private String libraryName;
    private String libraryId;
    private String libraryDescription;
    private boolean validating = true;
    private boolean failOnClassPathError;
    private boolean official;
    private boolean traces;
    private boolean uses;
    private boolean classes = true;
    private List<Path> classPath = Collections.emptyList();
    private List<ClassesSource> libraries = Collections.emptyList();
    private List<ClassesSource> dependencies = Collections.emptyList();
    private Path baseline0;
    private Path baseline1;
    private List<Path> exports = Collections.emptyList();
    private Path compareTo;
    private List<Path> approvals = Collections.emptyList();
    List<String> packages = Collections.emptyList();
    private List<Path> scope = Collections.emptyList();
    private List<Path> bootClassPath = Collections.emptyList();
    private List<Path> files = Collections.emptyList();
    private CompatibilityAccess access;
    private Path left;
    private NameFormat apiFormat;
    private Path right;
    private Path toCsv;
    private Path toExport;
    private Path toSignature;
    private String delimiter;
    private Set<String> rules = Collections.emptySet();
    private Set<String> properties = Collections.emptySet();
    private Set<String> excludeEmpty = Collections.emptySet();
    private boolean header;
    private boolean removeAdeViewRoot;
    private Path usesAggregate;
    private Path directory;
    private List<String> output = Collections.emptyList();
    private final Map<OutputType, Path> outputPaths = new EnumMap<OutputType, Path>(OutputType.class);

    private Path resolveBaselinePath(Path baselinePath) {
        String fileName;
        Path path;
        if (baselinePath == null) {
            return null;
        }
        String defaultName = OutputType.BASELINE.getFileName();
        if (defaultName.endsWith(".zip")) {
            defaultName = defaultName.substring(0, defaultName.length() - 4);
        }
        if (Files.isDirectory(baselinePath, new LinkOption[0])) {
            Path path2 = baselinePath.resolve(defaultName);
            if (Files.isRegularFile(path2, new LinkOption[0])) {
                baselinePath = path2;
            } else {
                path2 = baselinePath.resolve(defaultName + ".zip");
                if (Files.isRegularFile(path2, new LinkOption[0])) {
                    baselinePath = path2;
                }
            }
        } else if (!Files.isRegularFile(baselinePath, new LinkOption[0]) && Files.isRegularFile(path = (fileName = baselinePath.getFileName().toString()).endsWith(".zip") ? baselinePath.resolveSibling(fileName.substring(0, fileName.length() - 4)) : baselinePath.resolveSibling(fileName + ".zip"), new LinkOption[0])) {
            baselinePath = path;
        }
        return baselinePath;
    }

    public CommandInput() {
        this(null);
    }

    public CommandInput(CommandType commandType) {
        this.commandType = commandType;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(CommandOutput commandOutput) throws CommandException {
        if (this.isOfficial() && this.getDomain() == null) {
            this.setDomain(FMW_DOMAIN);
        }
        if (this.getCopyrightText() != null) {
            commandOutput.note(this.getCopyrightText(), new Object[0]);
        }
        switch (this.commandType) {
            case GENERATE: {
                CommandInput.prohibit("access", (Object)this.getAccess(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline0", this.getBaseline0(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline1", this.getBaseline1(), this.commandType, commandOutput);
                CommandInput.prohibit("compareto", this.getCompareTo(), this.commandType, commandOutput);
                CommandInput.prohibit("approvals", this.getApprovals(), this.commandType, commandOutput);
                CommandInput.prohibit("libraries", this.getLibraries(), this.commandType, commandOutput);
                CommandInput.require("classpath", this.getClassPath(), this.commandType, commandOutput);
                commandOutput.note("Generating export specification from annotations in%s", this.itemsImage(this.getClassPath()));
                break;
            }
            case ANALYZE: {
                CommandInput.prohibit("access", (Object)this.getAccess(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline0", this.getBaseline0(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline1", this.getBaseline1(), this.commandType, commandOutput);
                CommandInput.prohibit("compareto", this.getCompareTo(), this.commandType, commandOutput);
                CommandInput.prohibit("exports", this.getExports(), this.commandType, commandOutput);
                CommandInput.prohibit("approvals", this.getApprovals(), this.commandType, commandOutput);
                CommandInput.prohibit("messages", this.getFiles(), this.commandType, commandOutput);
                CommandInput.requirex("libraries", this.getLibraries(), "classpath", this.getClassPath(), this.commandType, commandOutput);
                commandOutput.note("Analyzing%s", this.itemsImage(this.getLibraries(), this.getClassPath()));
                break;
            }
            case MERGE: {
                CommandInput.prohibit("access", (Object)this.getAccess(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline0", this.getBaseline0(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline1", this.getBaseline1(), this.commandType, commandOutput);
                CommandInput.prohibit("exports", this.getExports(), this.commandType, commandOutput);
                CommandInput.prohibit("messages", this.getFiles(), this.commandType, commandOutput);
                CommandInput.requirex("libraries", this.getLibraries(), "classpath", this.getClassPath(), this.commandType, commandOutput);
                CommandInput.require("source", this.getSource(), this.commandType, commandOutput);
                if (this.getCompareTo() != null) {
                    commandOutput.note("Comparing %s to merge and capture of%s", Paths.toString(this.getCompareTo()), this.itemsImage(this.getLibraries(), this.getClassPath()));
                    break;
                }
                CommandInput.prohibit("approvals", this.getApprovals(), this.commandType, commandOutput);
                commandOutput.note("Merging%s", this.itemsImage(this.getLibraries(), this.getClassPath()));
                break;
            }
            case CAPTURE: {
                CommandInput.prohibit("access", (Object)this.getAccess(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline0", this.getBaseline0(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline1", this.getBaseline1(), this.commandType, commandOutput);
                CommandInput.prohibit("exports", this.getExports(), this.commandType, commandOutput);
                CommandInput.prohibit("messages", this.getFiles(), this.commandType, commandOutput);
                CommandInput.requirex("libraries", this.getLibraries(), "classpath", this.getClassPath(), this.commandType, commandOutput);
                CommandInput.require("source", this.getSource(), this.commandType, commandOutput);
                if (this.getCompareTo() != null) {
                    commandOutput.note("Comparing %s to merge and capture of%s", Paths.toString(this.getCompareTo()), this.itemsImage(this.getLibraries(), this.getClassPath()));
                    break;
                }
                CommandInput.prohibit("accept", this.getApprovals(), this.commandType, commandOutput);
                commandOutput.note("Capture baseline for %s", this.itemsImage(this.getLibraries(), this.getClassPath()));
                break;
            }
            case COMPARE: {
                CommandInput.prohibit("access", (Object)this.getAccess(), this.commandType, commandOutput);
                CommandInput.prohibit("compareto", this.getCompareTo(), this.commandType, commandOutput);
                CommandInput.prohibit("exports", this.getExports(), this.commandType, commandOutput);
                CommandInput.prohibit("classpath", this.getClassPath(), this.commandType, commandOutput);
                CommandInput.prohibit("libraries", this.getLibraries(), this.commandType, commandOutput);
                CommandInput.prohibit("messages", this.getFiles(), this.commandType, commandOutput);
                CommandInput.require("baseline0", this.getBaseline0(), this.commandType, commandOutput);
                CommandInput.require("baseline1", this.getBaseline1(), this.commandType, commandOutput);
                commandOutput.note("Comparing baselines %s and %s", this.getBaseline0(), this.getBaseline1());
                break;
            }
            case CONVERT: {
                CommandInput.prohibit("baseline0", this.getBaseline0(), this.commandType, commandOutput);
                CommandInput.prohibit("baseline1", this.getBaseline1(), this.commandType, commandOutput);
                CommandInput.prohibit("classpath", this.getClassPath(), this.commandType, commandOutput);
                CommandInput.prohibit("compareto", this.getCompareTo(), this.commandType, commandOutput);
                CommandInput.prohibit("exports", this.getExports(), this.commandType, commandOutput);
                CommandInput.prohibit("approvals", this.getApprovals(), this.commandType, commandOutput);
                CommandInput.prohibit("libraries", this.getLibraries(), this.commandType, commandOutput);
                if (this.getRight() != null ^ this.getRight() != null) {
                    throw new CommandException("%s command requires both or neither of %s and %s", this.commandType.getName(), commandOutput.propertyDescription("left"), commandOutput.propertyDescription("right"));
                }
                if (this.getAccess() == CompatibilityAccess.CONCEALED) {
                    throw new CommandException("%s command prohibits value of \"concealed\" for %s", this.commandType.getName(), commandOutput.propertyDescription("access"));
                }
                String to = "nothing";
                if (this.getToCsv() != null) {
                    to = "CSV list";
                } else if (this.getToExport() != null) {
                    to = "export specification";
                } else if (this.getToSignature() != null) {
                    to = "signature list";
                }
                int files = this.getFiles().size();
                if (this.getLeft() == null) {
                    commandOutput.note("Converting uses in %s file%s to %s", this.getFiles().size(), files != 1 ? "s" : "", to);
                    break;
                }
                if (files > 0) {
                    commandOutput.note("Converting and comparing 2 sets of %s files to %s", this.getFiles().size(), files != 1 ? "s" : "", to);
                    break;
                }
                commandOutput.note("Converting and comparing 2 files to %s", to);
            }
        }
        CommandType commandType = this.getCommandType();
        Set<OutputType> allowedOutputTypes = commandType.getAllowedOutputs();
        Set<OutputType> defaultOutputTypes = commandType.getDefaultOutputs();
        if (this.getCompareTo() != null) {
            if (allowedOutputTypes.contains((Object)OutputType.BASELINE)) {
                defaultOutputTypes.add(OutputType.BASELINE);
                defaultOutputTypes.add(OutputType.NOTES);
                allowedOutputTypes.add(OutputType.NOTES);
                defaultOutputTypes.add(OutputType.WARNINGS);
                allowedOutputTypes.add(OutputType.WARNINGS);
                defaultOutputTypes.add(OutputType.ERRORS);
                allowedOutputTypes.add(OutputType.ERRORS);
                defaultOutputTypes.add(OutputType.ERRORS_USED);
                allowedOutputTypes.add(OutputType.ERRORS_USED);
                defaultOutputTypes.add(OutputType.SUBMITTED);
                allowedOutputTypes.add(OutputType.SUBMITTED);
                defaultOutputTypes.add(OutputType.MATCHED);
                allowedOutputTypes.add(OutputType.MATCHED);
                defaultOutputTypes.add(OutputType.UNMATCHED);
                allowedOutputTypes.add(OutputType.UNMATCHED);
                defaultOutputTypes.add(OutputType.DIFFERENCES);
                allowedOutputTypes.add(OutputType.DIFFERENCES);
            } else {
                throw new CommandException("%s command prohibits %s", commandType.toString().toLowerCase(), commandOutput.propertyDescription("compareto"));
            }
        }
        if (this.isTraces()) {
            if (allowedOutputTypes.contains((Object)OutputType.TRACES)) {
                defaultOutputTypes.add(OutputType.TRACES);
            } else {
                throw new CommandException("%s command prohibits %s", commandType.toString().toLowerCase(), commandOutput.propertyDescription("traces"));
            }
        }
        if (this.isUses()) {
            if (allowedOutputTypes.contains((Object)OutputType.RECENT_CONCEALED)) {
                defaultOutputTypes.add(OutputType.RECENT_EXPORTED);
                defaultOutputTypes.add(OutputType.RECENT_CONCEALED);
                defaultOutputTypes.add(OutputType.RECENT_COMMENTED);
                defaultOutputTypes.add(OutputType.RECENT_UNCOMMENTED);
                defaultOutputTypes.add(OutputType.RECENT_MIGRATED);
                defaultOutputTypes.add(OutputType.RECENT_MISSING);
            } else {
                throw new CommandException("%s command prohibits %s", commandType.toString().toLowerCase(), commandOutput.propertyDescription("uses"));
            }
        }
        this.outputFiles = new EnumMap(OutputType.class);
        if (this.getOutput().isEmpty()) {
            for (OutputType outputType : defaultOutputTypes) {
                this.outputFiles.put(outputType, null);
            }
        } else {
            for (String string : this.getOutput()) {
                void var6_9;
                OutputType outputType;
                String string2 = string.trim().toLowerCase();
                if (string2.equals("default")) {
                    for (OutputType outputType2 : defaultOutputTypes) {
                        this.outputFiles.put(outputType2, null);
                    }
                    continue;
                }
                if (string2.equals("all")) {
                    for (OutputType outputType3 : allowedOutputTypes) {
                        this.outputFiles.put(outputType3, null);
                    }
                    continue;
                }
                if (string2.equals("none")) {
                    this.outputFiles.clear();
                    continue;
                }
                if (string2.equals("uses")) {
                    if (allowedOutputTypes.contains((Object)OutputType.RECENT_CONCEALED)) {
                        this.outputFiles.put(OutputType.RECENT_EXPORTED, null);
                        this.outputFiles.put(OutputType.RECENT_CONCEALED, null);
                        this.outputFiles.put(OutputType.RECENT_COMMENTED, null);
                        this.outputFiles.put(OutputType.RECENT_UNCOMMENTED, null);
                        continue;
                    }
                    throw new CommandException("%s command prohibits %s", commandType.toString().toLowerCase(), commandOutput.propertyDescription("uses"));
                }
                boolean negated = string2.startsWith("no");
                if (negated) {
                    String string3 = string2.substring(2);
                }
                if ((outputType = OutputType.toOutput((String)var6_9)) == null) {
                    void var6_14;
                    if (negated) {
                        String string4 = "no" + (String)var6_9;
                    }
                    throw new CommandException("unrecognized type \"%s\" in %s", var6_14, commandOutput.propertyDescription("output"));
                }
                if (!allowedOutputTypes.contains((Object)outputType)) {
                    throw new CommandException("%s command prohibits type \"%s\" in %s", commandType.toString().toLowerCase(), outputType.getTypeName(), commandOutput.propertyDescription("output"));
                }
                if (negated) {
                    if (!this.outputFiles.isEmpty()) continue;
                    for (OutputType type : defaultOutputTypes) {
                        this.outputFiles.put(type, null);
                    }
                    this.outputFiles.remove((Object)outputType);
                    continue;
                }
                this.outputFiles.put(outputType, null);
            }
        }
        for (Iterator<Object> iterator : OutputType.values()) {
            Path file = this.outputPaths.get(iterator);
            if (file == null) continue;
            if (!allowedOutputTypes.contains(iterator)) {
                throw new CommandException("%s command prohibits %s", commandType.toString().toLowerCase(), commandOutput.propertyDescription(((OutputType)((Object)iterator)).getOptionName()));
            }
            this.outputFiles.put((OutputType)((Object)iterator), file);
        }
        if (this.isOfficial()) {
            Object outputDirectory;
            if (defaultOutputTypes.contains((Object)OutputType.RECENT_MIGRATED)) {
                this.outputFiles.putIfAbsent(OutputType.RECENT_MIGRATED, null);
            }
            if (defaultOutputTypes.contains((Object)OutputType.RECENT_MISSING)) {
                this.outputFiles.putIfAbsent(OutputType.RECENT_MISSING, null);
            }
            if (this.outputFiles.containsKey((Object)OutputType.EXPORTS) && this.outputFiles.get((Object)OutputType.EXPORTS) == null) {
                commandOutput.note("Overriding export specification file name to fmw-documented-exports.xml for FA", new Object[0]);
                outputDirectory = this.getDirectory();
                if (outputDirectory == null) {
                    throw new CommandException("%s required for output files indicated by %s", commandOutput.propertyDescription("directory"), commandOutput.propertyDescription("output"));
                }
                this.outputFiles.put(OutputType.EXPORTS, outputDirectory.resolve("fmw-documented-exports.xml"));
            }
            if (this.outputFiles.containsKey((Object)OutputType.COMMENTS) && this.outputFiles.get((Object)OutputType.COMMENTS) == null) {
                commandOutput.note("Overriding remediation comments file name to %s for FA", DataFiles.FMW_COMMENTS.getName());
                outputDirectory = this.getDirectory();
                if (outputDirectory == null) {
                    throw new CommandException("%s required for output files indicated by %s", commandOutput.propertyDescription("directory"), commandOutput.propertyDescription("output"));
                }
                this.outputFiles.put(OutputType.COMMENTS, outputDirectory.resolve(DataFiles.FMW_COMMENTS.getName()));
            }
            if (this.outputFiles.containsKey((Object)OutputType.RECENT_MIGRATED) && this.outputFiles.get((Object)OutputType.RECENT_MIGRATED) == null) {
                commandOutput.note("Overriding migrated members file name to %s for FA", DataFiles.FMW_MIGRATED_MEMBERS.getName());
                outputDirectory = this.getDirectory();
                if (outputDirectory == null) {
                    throw new CommandException("%s required for output files indicated by %s", commandOutput.propertyDescription("directory"), commandOutput.propertyDescription("output"));
                }
                this.outputFiles.put(OutputType.RECENT_MIGRATED, outputDirectory.resolve(DataFiles.FMW_MIGRATED_MEMBERS.getName()));
            }
        }
        if (this.isTraces() && !this.outputFiles.containsKey((Object)OutputType.TRACES)) {
            commandOutput.note("Enabling traces output file for %s", commandOutput.propertyDescription("traces"));
            this.outputFiles.put(OutputType.TRACES, null);
        }
        for (Map.Entry<OutputType, Path> entry : this.outputFiles.entrySet()) {
            if (entry.getValue() != null) continue;
            OutputType type = entry.getKey();
            Path path = this.getDirectory();
            if (path == null) {
                throw new CommandException("%s required for output files indicated by %s", commandOutput.propertyDescription("directory"), commandOutput.propertyDescription("output"));
            }
            entry.setValue(path.resolve(type.getFileName()));
        }
        if (this.middlewareHome != null) {
            Path jdeveloper;
            if (!Files.isDirectory(this.middlewareHome, new LinkOption[0])) {
                throw new CommandException("Middleware home %s not a directory", this.middlewareHome);
            }
            commandOutput.note("Middleware home %s", this.middlewareHome);
            Path oracleCommon = this.middlewareHome.resolve("oracle_common");
            if (!Files.exists(oracleCommon, new LinkOption[0])) {
                commandOutput.warning("Middleware oracle_common directory %s not present", oracleCommon);
            }
            Path path = this.middlewareHome.resolve("wlserver");
            if (!Files.exists(oracleCommon, new LinkOption[0])) {
                commandOutput.warning("Middleware wlserver directory %s not present", path);
            }
            if (!Files.exists(jdeveloper = this.middlewareHome.resolve("jdeveloper"), new LinkOption[0])) {
                commandOutput.warning("Middleware jdeveloper directory %s not present", jdeveloper);
            } else {
                Path path2 = jdeveloper.resolve("ide/macros");
                if (!Files.isDirectory(path2, new LinkOption[0])) {
                    commandOutput.warning("Middleware jdeveloper macros directory %s not present", path2);
                }
            }
        } else {
            try {
                this.middlewareHome = Files.createTempDirectory(commandType.toString(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new CommandException(e, "temporary directory not created: %s", e);
            }
            commandOutput.note("No middleware home defined", new Object[0]);
        }
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public boolean hasOutput(OutputType type) {
        return this.outputFiles.containsKey((Object)type);
    }

    public boolean hasOutput(OutputType ... types) {
        for (OutputType type : types) {
            if (!this.outputFiles.containsKey((Object)type)) continue;
            return true;
        }
        return false;
    }

    public Path getOutputPath(OutputType type) {
        return this.outputFiles.get((Object)type);
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public Path getMiddlewareHome() {
        return this.middlewareHome;
    }

    public void setMiddlewareHome(Path middlewareHome) {
        this.middlewareHome = middlewareHome;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Set<String> getConsumers() {
        return this.consumers;
    }

    public void setConsumers(Set<String> consumers) {
        if (consumers == null) {
            consumers = Collections.emptySet();
        }
        this.consumers = consumers;
    }

    public Path getDomain() {
        return this.domain;
    }

    public void setDomain(Path domain) {
        this.domain = domain;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public String getLibraryDescription() {
        return this.libraryDescription;
    }

    public void setLibraryDescription(String libraryDescription) {
        this.libraryDescription = libraryDescription;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isFailOnClassPathError() {
        return this.failOnClassPathError;
    }

    public void setFailOnClassPathError(boolean failOnClassPathError) {
        this.failOnClassPathError = failOnClassPathError;
    }

    public boolean isOfficial() {
        return this.official;
    }

    public void setOfficial(boolean official) {
        this.official = official;
    }

    public boolean isTraces() {
        return this.traces;
    }

    public void setTraces(boolean traces) {
        this.traces = traces;
    }

    public boolean isUses() {
        return this.uses;
    }

    public void setUses(boolean uses) {
        this.uses = uses;
    }

    public boolean isClasses() {
        return this.classes;
    }

    public void setClasses(boolean classes) {
        this.classes = classes;
    }

    public List<Path> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(List<Path> classPath) {
        if (classPath == null) {
            classPath = Collections.emptyList();
        }
        this.classPath = classPath;
    }

    public List<ClassesSource> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<ClassesSource> libraries) {
        if (libraries == null) {
            libraries = Collections.emptyList();
        }
        this.libraries = libraries;
    }

    public List<ClassesSource> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ClassesSource> dependencies) {
        if (dependencies == null) {
            dependencies = Collections.emptyList();
        }
        this.dependencies = dependencies;
    }

    public Path getBaseline0() {
        return this.baseline0;
    }

    public void setBaseline0(Path baseline0) {
        this.baseline0 = this.resolveBaselinePath(baseline0);
    }

    public Path getBaseline1() {
        return this.baseline1;
    }

    public void setBaseline1(Path baseline1) {
        this.baseline1 = this.resolveBaselinePath(baseline1);
    }

    public List<Path> getExports() {
        return this.exports;
    }

    public void setExports(List<Path> exports) {
        if (exports == null) {
            exports = Collections.emptyList();
        }
        this.exports = exports;
    }

    public Path getCompareTo() {
        return this.compareTo;
    }

    public void setCompareTo(Path compareTo) {
        this.compareTo = this.resolveBaselinePath(compareTo);
    }

    public List<Path> getApprovals() {
        return this.approvals;
    }

    public void setApprovals(List<Path> approvals) {
        if (approvals == null) {
            approvals = Collections.emptyList();
        }
        this.approvals = approvals;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        if (packages == null) {
            packages = Collections.emptyList();
        }
        this.packages = packages;
    }

    public List<Path> getScope() {
        return this.scope;
    }

    public void setScope(List<Path> scope) {
        if (scope == null) {
            scope = Collections.emptyList();
        }
        this.scope = scope;
    }

    public List<Path> getBootClassPath() {
        return this.bootClassPath;
    }

    public void setBootClassPath(List<Path> bootClassPath) {
        if (bootClassPath == null) {
            bootClassPath = Collections.emptyList();
        }
        this.bootClassPath = bootClassPath;
    }

    public List<Path> getFiles() {
        return this.files;
    }

    public void setFiles(List<Path> files) {
        if (files == null) {
            files = Collections.emptyList();
        }
        this.files = files;
    }

    public CompatibilityAccess getAccess() {
        return this.access;
    }

    public void setAccess(CompatibilityAccess access) {
        this.access = access;
    }

    public Path getLeft() {
        return this.left;
    }

    public void setLeft(Path left) {
        this.left = left;
    }

    public NameFormat getApiFormat() {
        return this.apiFormat;
    }

    public void setApiFormat(NameFormat format) {
        this.apiFormat = format;
    }

    public Path getRight() {
        return this.right;
    }

    public void setRight(Path right) {
        this.right = right;
    }

    public Path getToCsv() {
        return this.toCsv;
    }

    public void setToCsv(Path toCsv) {
        this.toCsv = toCsv;
    }

    public Path getToExport() {
        return this.toExport;
    }

    public void setToExport(Path toExport) {
        this.toExport = toExport;
    }

    public Path getToSignature() {
        return this.toSignature;
    }

    public void setToSignature(Path toSignature) {
        this.toSignature = toSignature;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Set<String> getRules() {
        return this.rules;
    }

    public void setRules(List<String> rules) {
        if (rules == null) {
            rules = Collections.emptyList();
        }
        this.rules = new TreeSet<String>();
        for (String rule : rules) {
            int bracket = rule.indexOf(91);
            if (bracket > 0) {
                rule = rule.substring(0, bracket);
            }
            this.rules.add(rule);
        }
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        if (properties == null) {
            properties = Collections.emptyList();
        }
        this.properties = new LinkedHashSet<String>(properties);
    }

    public Set<String> getExcludeEmpty() {
        return this.excludeEmpty;
    }

    public void setExcludeEmpty(List<String> excludeEmpty) {
        if (excludeEmpty == null) {
            excludeEmpty = Collections.emptyList();
        }
        this.excludeEmpty = new TreeSet<String>(excludeEmpty);
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public boolean isRemoveAdeViewRoot() {
        return this.removeAdeViewRoot;
    }

    public void setRemoveAdeViewRoot(boolean removeAdeViewRoot) {
        this.removeAdeViewRoot = removeAdeViewRoot;
    }

    public Path getUsesAggregate() {
        return this.usesAggregate;
    }

    public void setUsesAggregate(Path usesAggregate) {
        this.usesAggregate = usesAggregate;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void setDirectory(Path directory) {
        this.directory = directory;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public void setOutput(List<String> output) {
        if (output == null) {
            output = Collections.emptyList();
        }
        this.output = output;
    }

    public void setOutputPath(OutputType type, Path path) {
        this.outputPaths.put(type, path);
    }

    private static void prohibit(String name, Object value, CommandType type, CommandOutput output) throws CommandException {
        if (value == null) {
            return;
        }
        throw new CommandException("%s command prohibits %s", type.getName(), output.propertyDescription(name));
    }

    private static void prohibit(String name, List<?> value, CommandType type, CommandOutput output) throws CommandException {
        if (value == null || value.isEmpty()) {
            return;
        }
        throw new CommandException("%s command prohibits %s", type.getName(), output.propertyDescription(name));
    }

    private static void requirex(String name1, List<?> value1, String name2, List<?> value2, CommandType type, CommandOutput output) throws CommandException {
        boolean empty2;
        boolean empty1 = value1 == null || value1.isEmpty();
        boolean bl = empty2 = value2 == null || value2.isEmpty();
        if (empty1 == empty2) {
            throw new CommandException(empty1 ? "%s command prohibits %s and %s" : "%s command requires one of %s or %s", type.getName(), output.propertyDescription(name1), output.propertyDescription(name2));
        }
    }

    private static void require(String name, Object value, CommandType type, CommandOutput output) throws CommandException {
        if (value != null) {
            return;
        }
        throw new CommandException("%s command requires %s", type.getName(), output.propertyDescription(name));
    }

    private static void require(String name, List<?> value, CommandType type, CommandOutput output) throws CommandException {
        if (!value.isEmpty()) {
            return;
        }
        throw new CommandException("%s command requires %s", type.getName(), output.propertyDescription(name));
    }

    private StringBuilder itemsImage(List<?> items1, List<?> items2) {
        if (items1 != null && !items1.isEmpty()) {
            return this.itemsImage(items1);
        }
        if (items2 != null && !items2.isEmpty()) {
            return this.itemsImage(items2);
        }
        return new StringBuilder();
    }

    private StringBuilder itemsImage(List<?> messageItems) {
        StringBuilder builder = new StringBuilder();
        switch (messageItems.size()) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                builder.append(' ');
                this.appendItem(messageItems.get(0), builder);
                break;
            }
            default: {
                builder.append(':');
                for (Object item : messageItems) {
                    builder.append("\n    ");
                    this.appendItem(item, builder);
                }
            }
        }
        return builder;
    }

    private StringBuilder appendItem(Object item, StringBuilder builder) {
        builder.append(item);
        if (item instanceof ClassesSource && ((ClassesSource)item).getType() == ClassesSource.SourceType.INSTALLATION) {
            builder.append(" at ").append(this.middlewareHome);
        }
        return builder;
    }

    public static enum OutputType {
        BASELINE("baseline.xsig.zip"),
        COMMENTS("lib-comments.xml"),
        CONCEALED("concealed-signatures.lis"),
        DIFFERENCES("differences.lis"),
        ERRORS("baseline-errors.lis"),
        ERRORS_USED("baseline-errors-used.lis"),
        EXPORTED("exported-signatures.lis"),
        EXPORTS("lib-exports.xml"),
        ISSUES("exports.log"),
        LIBRARIES("libraries.lis"),
        LIBRARY("lib-exports.library"),
        MATCHED("matched-approvals.lis"),
        NOTES("baseline-notes.lis"),
        PACKAGES("packages.csv"),
        PROBLEMS("problem-types.lis"),
        RECENT_EXPORTED("recent-uses-exported-unused.lis"),
        RECENT_COMMENTED("recent-uses-concealed-commented.lis"),
        RECENT_CONCEALED("recent-uses-concealed.lis"),
        RECENT_UNCOMMENTED("recent-uses-concealed-uncommented.lis"),
        RECENT_MIGRATED("recent-uses-migrated.lis"),
        RECENT_MISSING("recent-uses-missing.lis"),
        RESTRICTED("restricted-signatures.lis"),
        SUBMITTED("submitted-approvals.lis"),
        TRACES("traces.log"),
        TYPES("types.csv"),
        UNMATCHED("unmatched-approvals.lis"),
        USED("used.xml"),
        USES("uses.csv"),
        WARNINGS("baseline-warnings.lis");

        private final String fileName;
        private static final Map<String, OutputType> typeForName;

        private OutputType(String fileName) {
            this.fileName = fileName;
        }

        public String getTypeName() {
            return this.toString().toLowerCase().replace("_", "");
        }

        public String getOptionName() {
            return this.toString().toLowerCase().replace("_", "") + "file";
        }

        public String getFileName() {
            return this.fileName;
        }

        public static OutputType toOutput(String name) {
            if (typeForName.isEmpty()) {
                for (OutputType type : OutputType.values()) {
                    typeForName.put(type.toString().toLowerCase().replace("_", ""), type);
                }
            }
            return typeForName.get(name.toLowerCase().replace('-', '_').replace("_", ""));
        }

        static {
            typeForName = new HashMap<String, OutputType>();
        }
    }

    public static enum CommandType {
        GENERATE,
        ANALYZE,
        MERGE,
        CAPTURE,
        COMPARE,
        CONVERT;

        private static final Set<OutputType> PRODUCT;
        private static final Set<OutputType> DATA;
        private static final Set<OutputType> RECENT_USES;
        private static final Set<OutputType> LOGS;
        private static final Set<OutputType> BASELINES;

        public String getName() {
            return this.toString().toLowerCase();
        }

        public Set<OutputType> getAllowedOutputs() {
            switch (this) {
                case GENERATE: {
                    return CommandType.set(PRODUCT, DATA, RECENT_USES, LOGS);
                }
                case ANALYZE: {
                    return CommandType.set(PRODUCT, DATA, RECENT_USES, LOGS);
                }
                case MERGE: {
                    return CommandType.set(PRODUCT, DATA, RECENT_USES, LOGS);
                }
                case CAPTURE: {
                    return MERGE.getAllowedOutputs();
                }
                case COMPARE: {
                    return CommandType.set(BASELINES, LOGS);
                }
                case CONVERT: {
                    return Collections.emptySet();
                }
            }
            throw new IllegalStateException();
        }

        public Set<OutputType> getDefaultOutputs() {
            Set<Object> result;
            switch (this) {
                case GENERATE: {
                    result = this.getAllowedOutputs();
                    result.removeAll(CommandType.set(new Object[]{OutputType.LIBRARIES, OutputType.PACKAGES, OutputType.TYPES, OutputType.BASELINE, RECENT_USES}));
                    break;
                }
                case ANALYZE: {
                    result = this.getAllowedOutputs();
                    break;
                }
                case MERGE: {
                    result = this.getAllowedOutputs();
                    break;
                }
                case CAPTURE: {
                    result = MERGE.getDefaultOutputs();
                    break;
                }
                case COMPARE: {
                    result = this.getAllowedOutputs();
                    break;
                }
                case CONVERT: {
                    result = Collections.emptySet();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            result.remove((Object)OutputType.TRACES);
            return result;
        }

        private static Set<OutputType> set(Object ... outputTypes) {
            ArrayList<OutputType> types = new ArrayList<OutputType>();
            for (Object object : outputTypes) {
                if (object instanceof OutputType) {
                    types.add((OutputType)((Object)object));
                    continue;
                }
                if (!(object instanceof Collection)) continue;
                types.addAll((Collection)object);
            }
            return types.isEmpty() ? EnumSet.noneOf(OutputType.class) : EnumSet.copyOf(types);
        }

        static {
            PRODUCT = CommandType.set(new Object[]{OutputType.BASELINE, OutputType.COMMENTS, OutputType.EXPORTS, OutputType.LIBRARY});
            DATA = CommandType.set(new Object[]{OutputType.CONCEALED, OutputType.RESTRICTED, OutputType.EXPORTED, OutputType.LIBRARIES, OutputType.PACKAGES, OutputType.PROBLEMS, OutputType.TYPES});
            RECENT_USES = CommandType.set(new Object[]{OutputType.RECENT_EXPORTED, OutputType.RECENT_COMMENTED, OutputType.RECENT_CONCEALED, OutputType.RECENT_UNCOMMENTED, OutputType.RECENT_MIGRATED, OutputType.RECENT_MISSING});
            LOGS = CommandType.set(new Object[]{OutputType.ISSUES, OutputType.TRACES});
            BASELINES = CommandType.set(new Object[]{OutputType.NOTES, OutputType.WARNINGS, OutputType.ERRORS, OutputType.ERRORS_USED, OutputType.MATCHED, OutputType.SUBMITTED, OutputType.UNMATCHED, OutputType.DIFFERENCES});
        }
    }
}

