/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.jce.cert.X500Name;
import oracle.security.crypto.jce.cert.X509CRLEntryImpl;
import oracle.security.crypto.jce.cert.X509Impl;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLImpl
extends X509CRL
implements ASN1Object {
    private ASN1Sequence tbsCertList;
    private ASN1Sequence contents;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private Hashtable revokedCertificatesTable;
    private Set revokedCertificates;
    private int version;
    private PublicKey pubKey;
    private X500Name issuer;
    private Date thisUpdate;
    private Date nextUpdate;
    private Hashtable extensions;
    private Set criticalOIDs;
    private Set nonCriticalOIDs;
    private boolean unsupportedCriticalExtension;
    protected boolean decoded;

    public CRLImpl() {
    }

    public CRLImpl(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509") || this.revokedCertificatesTable == null) {
            return false;
        }
        try {
            X509Impl x509 = new X509Impl((InputStream)new UnsyncByteArrayInputStream(cert.getEncoded()));
            if (!this.revokedCertificatesTable.containsKey(x509.getSerialNumber())) {
                return false;
            }
        }
        catch (CertificateEncodingException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
        return true;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNo) {
        if (this.revokedCertificatesTable == null) {
            return null;
        }
        return (X509CRLEntry)this.revokedCertificatesTable.get(serialNo);
    }

    public Set getRevokedCertificates() {
        if (this.revokedCertificatesTable == null) {
            return null;
        }
        if (this.revokedCertificates != null) {
            return this.revokedCertificates;
        }
        this.revokedCertificates = new HashSet();
        if (this.revokedCertificatesTable != null) {
            Enumeration e = this.revokedCertificatesTable.elements();
            while (e.hasMoreElements()) {
                this.revokedCertificates.add(e.nextElement());
            }
        }
        return this.revokedCertificates;
    }

    public void input(InputStream is) throws IOException {
        AlgorithmIdentifier tbsSigAlgID;
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.tbsCertList = new ASN1Sequence((InputStream)sis);
        this.sigAlgID = new AlgorithmIdentifier((InputStream)sis);
        this.sigBytes = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
        ASN1SequenceInputStream tbs = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.tbsCertList));
        if (tbs.getCurrentTag() == 2) {
            BigInteger bigInteger = ASN1Integer.inputValue((InputStream)tbs);
        }
        if (!(tbsSigAlgID = new AlgorithmIdentifier((InputStream)tbs)).getOID().equals((Object)this.sigAlgID.getOID())) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name issuer2 = new X500Name((InputStream)tbs);
        if (this.issuer == null) {
            this.issuer = issuer2;
        } else if (!this.issuer.equals(issuer2)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + issuer2 + "}");
        }
        this.thisUpdate = ASN1Date.inputValue((InputStream)tbs);
        this.nextUpdate = tbs.getCurrentTag() == 23 || tbs.getCurrentTag() == 24 ? ASN1Date.inputValue((InputStream)tbs) : null;
        if (tbs.getCurrentTag() == 16) {
            ASN1SequenceInputStream crl = new ASN1SequenceInputStream((InputStream)tbs);
            this.revokedCertificatesTable = new Hashtable();
            while (crl.hasMoreData()) {
                X509CRLEntryImpl rc = new X509CRLEntryImpl((InputStream)crl);
                this.revokedCertificatesTable.put(rc.getSerialNumber(), rc);
            }
            crl.terminate();
        } else {
            this.revokedCertificatesTable = null;
        }
        this.unsupportedCriticalExtension = false;
        if (tbs.getCurrentTag() == 0) {
            ASN1ConstructedInputStream ext = new ASN1ConstructedInputStream((InputStream)tbs);
            ASN1SequenceInputStream extensionsStream = new ASN1SequenceInputStream((InputStream)ext);
            this.extensions = new Hashtable();
            this.criticalOIDs = new HashSet();
            this.nonCriticalOIDs = new HashSet();
            while (extensionsStream.hasMoreData()) {
                ASN1SequenceInputStream extension = new ASN1SequenceInputStream((InputStream)extensionsStream);
                String type = new ASN1ObjectID((InputStream)extension).toStringCompact();
                boolean critical = false;
                if (extension.getCurrentTag() == 1) {
                    critical = ASN1Boolean.inputValue((InputStream)extension);
                }
                if (critical) {
                    this.criticalOIDs.add(type);
                    this.unsupportedCriticalExtension = true;
                } else {
                    this.nonCriticalOIDs.add(type);
                }
                this.extensions.put(type, ASN1OctetString.inputValue((InputStream)extension));
                extension.terminate();
            }
            extensionsStream.terminate();
            ext.terminate();
        } else {
            this.extensions = null;
            this.criticalOIDs = null;
        }
        tbs.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.contents.output(os);
    }

    public int length() {
        return this.contents.length();
    }

    @Override
    public byte[] getEncoded() {
        return Utils.toBytes((Streamable)this.contents);
    }

    @Override
    public byte[] getTBSCertList() {
        return Utils.toBytes((Streamable)this.tbsCertList);
    }

    @Override
    public byte[] getSignature() {
        return this.sigBytes;
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sigObj = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        sigObj.initVerify(key);
        sigObj.update(this.getTBSCertList());
        sigObj.verify(this.getSignature());
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, (String)null);
    }

    @Override
    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    @Override
    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    @Override
    public Principal getIssuerDN() {
        return this.issuer;
    }

    @Override
    public String getSigAlgOID() {
        return this.sigAlgID.getOID().toStringCompact();
    }

    @Override
    public String getSigAlgName() {
        ASN1ObjectID oid = this.sigAlgID.getOID();
        if (oid.equals((Object)AlgID.md5WithRSAEncryption.getOID())) {
            return "MD5withRSA";
        }
        if (oid.equals((Object)AlgID.md2WithRSAEncryption.getOID())) {
            return "MD2withRSA";
        }
        if (oid.equals((Object)AlgID.sha_1WithRSAEncryption.getOID())) {
            return "SHA1withRSA";
        }
        if (oid.equals((Object)AlgID.dsaWithSHA1.getOID()) || oid.equals((Object)AlgID.dsaWithSHA.getOID()) || oid.equals((Object)AlgID.dsaWithSHA1Old.getOID())) {
            return "SHA1withDSA";
        }
        return "";
    }

    @Override
    public byte[] getSigAlgParams() {
        return Utils.toBytes((Streamable)this.sigAlgID.getParameters());
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public Set getCriticalExtensionOIDs() {
        return this.criticalOIDs;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.nonCriticalOIDs;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        return (byte[])this.extensions.get(oid);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCriticalExtension;
    }

    @Override
    public boolean equals(Object o) {
        try {
            if (o != null && o instanceof X509CRL) {
                return Utils.areEqual((byte[])this.getEncoded(), (byte[])((X509CRL)o).getEncoded());
            }
            return false;
        }
        catch (CRLException ex) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return new String(this.getEncoded()).hashCode();
    }

    @Override
    public String toString() {
        String s = "";
        s = s + "{ thisUpdate = " + this.thisUpdate;
        s = s + ", nextUpdate = " + this.nextUpdate;
        s = s + ", issuer = " + this.issuer;
        s = s + ", sigAlgOID = " + this.getSigAlgOID();
        s = s + " }";
        return s;
    }
}

