/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class StoragePropertiesValidator
extends AbstractChildDBObjectValidator<OracleStorageProperties> {
    public StoragePropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("tablespaceID");
        collection.add("tablespaceSet");
        collection.add("logging");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"percentFree"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"percentUsed"})
    public void validatePercentFree(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        Integer n = oracleStorageProperties2.getPercentFree();
        if (n != null && (n < 0 || n > 99)) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"PCTFREE", 0, 99}));
        }
        this.validateSumOfPctFreeAndPctUsed(oracleStorageProperties2);
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "percentFree");
    }

    @DBObjectValidator.PropertyValidator(value={"percentUsed"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"percentFree"})
    public void validatePercentUsed(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        Integer n = oracleStorageProperties2.getPercentUsed();
        if (n != null && (n < 0 || n > 99)) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"PCTUSED", 0, 99}));
        }
        this.validateSumOfPctFreeAndPctUsed(oracleStorageProperties2);
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "percentUsed");
    }

    @DBObjectValidator.PropertyValidator(value={"initrans"}, level=ValidationLevel.FULL)
    public void validateInitrans(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        Integer n = oracleStorageProperties2.getInitrans();
        if (n != null && (n < 1 || n > 255)) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"INITRANS", 1, 255}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "initrans");
    }

    @DBObjectValidator.PropertyValidator(value={"maxtrans"}, level=ValidationLevel.FULL)
    public void validateMaxtrans(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        Integer n = oracleStorageProperties2.getMaxtrans();
        if (n != null && (n < 1 || n > 255)) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"MAXTRANS", 1, 255}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "maxtrans");
    }

    @DBObjectValidator.PropertyValidator(value={"initialExtent"}, level=ValidationLevel.FULL)
    public void validateInitialExtent(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        BigInteger bigInteger = oracleStorageProperties2.getInitialExtent();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"INITIAL", 1}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "initialExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"nextExtent"}, level=ValidationLevel.FULL)
    public void validateNextExtent(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        BigInteger bigInteger = oracleStorageProperties2.getNextExtent();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"NEXT", 1}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "nextExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"minExtent"}, level=ValidationLevel.FULL)
    public void validateMinExtent(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        BigInteger bigInteger = oracleStorageProperties2.getMinExtent();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MINEXTENT", 1}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "minExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"maxExtent"}, level=ValidationLevel.FULL)
    public void validateMaxExtent(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        BigInteger bigInteger = oracleStorageProperties2.getMaxExtent();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MAXEXTENT", 0}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "maxExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"percentIncrease"}, level=ValidationLevel.FULL)
    public void validatePercentIncrease(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        Integer n = oracleStorageProperties2.getPercentIncrease();
        if (n != null && n < 0) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"PCTINCREASE", 0}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "percentIncrease");
    }

    @DBObjectValidator.PropertyValidator(value={"freelistGroups"}, level=ValidationLevel.FULL)
    public void validateFreelistGroups(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        Integer n = oracleStorageProperties2.getFreelistGroups();
        if (n != null && n < 1) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"FREELIST_GROUPS", 1}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "freelistGroups");
    }

    @DBObjectValidator.PropertyValidator(value={"freelists"}, level=ValidationLevel.FULL)
    public void validateFreelists(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
        Integer n = oracleStorageProperties2.getFreelists();
        if (n != null && n < 1) {
            throw new ValidationException((DBObject)oracleStorageProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"FREELISTS", 1}));
        }
        this.validateNonNullableProperty((DBObject)oracleStorageProperties, (DBObject)oracleStorageProperties2, "freelists");
    }

    @DBObjectValidator.PropertyValidator(value={"bufferMode"}, level=ValidationLevel.FULL)
    public void validateBufferMode(OracleStorageProperties oracleStorageProperties, OracleStorageProperties oracleStorageProperties2) throws ValidationException {
    }

    private void validateSumOfPctFreeAndPctUsed(OracleStorageProperties oracleStorageProperties) throws ValidationException {
        Integer n = oracleStorageProperties.getPercentFree();
        Integer n2 = oracleStorageProperties.getPercentUsed();
        if (n != null && n2 != null && n + n2 > 100) {
            throw new ValidationException((DBObject)oracleStorageProperties, APIBundle.get((String)"STORAGE_PROPERTY_ERROR_PCTFREE_PCTUSED_INVALID_VALUE"));
        }
    }
}

