/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.ora.sxml.SXMLCommentGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SXMLGenerator
extends SXMLFragmentGenerator {
    private static final String SXML_VERSION_1 = "1.0";
    protected static final String SXML_VERSION_CURRENT = "1.0";
    private DBObject m_obj;
    private static SXMLCommentGenerator s_commGen;

    public SXMLGenerator() {
        this(new SXMLMappings());
    }

    SXMLGenerator(SXMLMappings sXMLMappings) {
        super.setMappings(sXMLMappings);
    }

    public final boolean canGenerate(DBObject dBObject) {
        return this.canGenerate(dBObject.getType());
    }

    public final boolean canGenerate(String string) {
        return this.getMappings().hasMappings(string) || this.getMappings().getGenerators(string) != null;
    }

    public final void addMapping(String string, String string2, String string3, SXMLValueConverter sXMLValueConverter) {
        this.getMappings().cache(string, string2, string3, sXMLValueConverter);
    }

    public final void removeMapping(String string, String string2, String string3) {
        this.getMappings().uncache(string, string2, string3);
    }

    public final void addGenerator(String string, Class<? extends SXMLFragmentGenerator> clazz) {
        this.getMappings().registerGen(string, clazz);
    }

    public final Document generateSXML(DBObject dBObject) {
        XMLDocument xMLDocument = new XMLDocument();
        this.m_obj = dBObject;
        String string = this.getType(dBObject);
        xMLDocument.setEncoding("UTF-8");
        if (dBObject instanceof Table && (this.alwaysUseComposite() || ((Table)dBObject).getIndexes() != null && ((Table)dBObject).getIndexes().length > 0)) {
            this.populateCompositeDocForTable(xMLDocument, (Table)dBObject, string);
            string = "COMPOSITE";
        } else {
            this.populateDoc(xMLDocument, dBObject, string);
        }
        XMLSchema xMLSchema = this.getMappings().getXSD(string);
        if (xMLSchema != null) {
            xMLDocument.setSchema(xMLSchema);
        }
        for (SXMLCommentGenerator sXMLCommentGenerator : this.getCommentGenerators()) {
            String[] stringArray;
            for (String string2 : stringArray = sXMLCommentGenerator.getComments(dBObject)) {
                Comment comment = xMLDocument.createComment(string2);
                xMLDocument.insertBefore((Node)comment, (Node)xMLDocument.getDocumentElement());
            }
        }
        return xMLDocument;
    }

    public final boolean alwaysUseComposite() {
        return false;
    }

    public boolean isBuildParsedSQL() {
        return false;
    }

    private void populateDoc(XMLDocument xMLDocument, DBObject dBObject, String string) {
        Element element = xMLDocument.createElementNS("http://xmlns.oracle.com/ku", this.getMappings().getNodeName(string));
        element.setAttribute("version", "1.0");
        this.populateNode(element, (Document)xMLDocument, dBObject);
        xMLDocument.appendChild((Node)element);
    }

    private void populateCompositeDocForTable(XMLDocument xMLDocument, Table table, String string) {
        Element element = xMLDocument.createElementNS("http://xmlns.oracle.com/ku", "COMPOSITE");
        element.setAttribute("version", "1.0");
        xMLDocument.appendChild((Node)element);
        Element element2 = xMLDocument.createElementNS("http://xmlns.oracle.com/ku", "BASE_OBJECT");
        element.appendChild(element2);
        Element element3 = xMLDocument.createElementNS("http://xmlns.oracle.com/ku", "INDEX_LIST");
        element.appendChild(element3);
        Element element4 = xMLDocument.createElementNS("http://xmlns.oracle.com/ku", string.replaceAll(" ", "_"));
        this.populateNode(element4, (Document)xMLDocument, table);
        element2.appendChild(element4);
        element4.setAttribute("version", "1.0");
        for (Index index : table.getIndexes()) {
            Element element5 = xMLDocument.createElementNS("http://xmlns.oracle.com/ku", "INDEX");
            this.populateNode(element5, (Document)xMLDocument, index);
            element5.setAttribute("version", "1.0");
            element3.appendChild(element5);
        }
    }

    @Override
    protected final void populateNode(Node node, Document document, Object object) {
        String string = this.getType(object);
        this.populateNodeImpl(node, document, object, string);
    }

    void populateNodeImpl(Node node, Document document, Object object, String string) {
        Iterator<Class<? extends SXMLFragmentGenerator>> iterator;
        Iterator<SXMLMappings.Mapping> iterator2 = this.getMappings().getMappings(string);
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            this.processPropertyMapping(node, document, object, (SXMLMappings.Mapping)((Object)iterator));
        }
        iterator = this.getMappings().getGenerators(string);
        if (iterator != null) {
            while (iterator.hasNext()) {
                try {
                    SXMLFragmentGenerator sXMLFragmentGenerator = (SXMLFragmentGenerator)((Class)iterator.next()).newInstance();
                    sXMLFragmentGenerator.setParentGenerator(this);
                    sXMLFragmentGenerator.populateNode(node, document, object);
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        }
    }

    String getTopLevelObjectSchemaName() {
        String string = null;
        if (this.m_obj instanceof SchemaObject && ((SchemaObject)this.m_obj).getSchema() != null) {
            string = ((SchemaObject)this.m_obj).getSchema().getName();
        }
        return string;
    }

    @Override
    protected final void readNode(Node node, Object object) {
    }

    private List<SXMLCommentGenerator> getCommentGenerators() {
        ArrayList<SXMLCommentGenerator> arrayList = new ArrayList<SXMLCommentGenerator>();
        DBCore.getInstance().populateFactoryList(SXMLCommentGenerator.class, arrayList);
        if (s_commGen != null) {
            arrayList.add(s_commGen);
        }
        return arrayList;
    }

    @Deprecated
    public static void setCommentGenerator(SXMLCommentGenerator sXMLCommentGenerator) {
        s_commGen = sXMLCommentGenerator;
    }
}

