/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.ModelUtil;

public class OracleColumnPropertiesBuilder
extends OracleDBObjectBuilder<OracleColumnProperties> {
    public OracleColumnPropertiesBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "OracleColumnProperties");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    private OracleColumnProperties getOrCreateProperties(Column column) {
        OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
        if (oracleColumnProperties == null) {
            oracleColumnProperties = new OracleColumnProperties();
            column.setProperty("OracleColumnProperties", (Object)oracleColumnProperties);
        }
        return oracleColumnProperties;
    }

    private Column getColumn(OracleColumnProperties oracleColumnProperties) throws DBException {
        Column column = (Column)oracleColumnProperties.getParent();
        if (column == null) {
            throw new DBException((DBObject)oracleColumnProperties, "OracleColumnProperties must have a parent Column.");
        }
        return column;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"XMLTypeColumnProperties"})
    public void buildXMLProperties(OracleColumnProperties oracleColumnProperties) throws DBException {
        Relation relation;
        Column column = this.getColumn(oracleColumnProperties);
        DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage(), (boolean)false);
        if (dataType != null && XMLTypeColumnProperties.isXMLType((DataType)dataType) && (relation = column.getRelation()) != null) {
            this.buildAllXMLColumns(relation);
        }
    }

    private void buildAllXMLColumns(final Relation relation) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)relation, "SELECT /*OracleDictionaryQueries.ALL_XMLTYPE_COLUMN_PROPERTIES_QUERY*/ \n       XTC.COLUMN_NAME, XTC.SCHEMA_OWNER, XTC.XMLSCHEMA, XTC.ELEMENT_NAME \n,      XTC.STORAGE_TYPE, XTC.ANYSCHEMA, XTC.NONSCHEMA \nFROM   SYS.ALL_XML_TAB_COLS XTC \nWHERE  XTC.OWNER = ? \nAND    XTC.TABLE_NAME = ?", relation.getSchema(), relation);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string;
                        String string2;
                        XMLTypeColumnProperties xMLTypeColumnProperties = (XMLTypeColumnProperties)OracleColumnPropertiesBuilder.this.newObject(XMLTypeColumnProperties.class, null);
                        XMLTypeColumnProperties.StoreAs storeAs = null;
                        String string3 = resultSet.getString("STORAGE_TYPE");
                        storeAs = "BINARY".equals(string3) ? XMLTypeColumnProperties.StoreAs.BINARY_XML : ("OBJECT-RELATIONAL".equals(string3) ? XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL : XMLTypeColumnProperties.StoreAs.valueOf((String)string3));
                        xMLTypeColumnProperties.setStoreAs(storeAs);
                        String string4 = resultSet.getString("ELEMENT_NAME");
                        if (ModelUtil.hasLength((String)string4)) {
                            string2 = resultSet.getString("SCHEMA_OWNER");
                            string = resultSet.getString("XMLSCHEMA");
                            XMLSchema xMLSchema = (XMLSchema)OracleColumnPropertiesBuilder.this.getProvider().getObject("XML SCHEMA", OracleColumnPropertiesBuilder.this.getSchema(string2), string);
                            NameBasedID nameBasedID = new NameBasedID("XMLSchemaElement", string4, xMLSchema.getID());
                            xMLTypeColumnProperties.setElementID((DBObjectID)nameBasedID);
                        } else {
                            xMLTypeColumnProperties.setElementID(null);
                        }
                        xMLTypeColumnProperties.setAllowAnySchema(OracleColumnPropertiesBuilder.this.isYes(resultSet, "ANYSCHEMA"));
                        xMLTypeColumnProperties.setAllowNonSchema(OracleColumnPropertiesBuilder.this.isYes(resultSet, "NONSCHEMA"));
                        string2 = relation.getColumn(resultSet.getString("COLUMN_NAME"));
                        if (string2 == null) continue;
                        string = OracleColumnPropertiesBuilder.this.getOrCreateProperties((Column)string2);
                        string.setXMLTypeColumnProperties(xMLTypeColumnProperties);
                        xMLTypeColumnProperties.setID((DBObjectID)new NameBasedID((DBObject)xMLTypeColumnProperties, string.getID()));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)relation, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"nestedTableProperties"})
    public void buildNestedTableProperties(final OracleColumnProperties oracleColumnProperties) throws DBException {
        Column column = this.getColumn(oracleColumnProperties);
        Relation relation = column.getRelation();
        DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage(), (boolean)false);
        if (relation != null && OracleColumnPropertiesBuilder.isTableCollectionType(dataType)) {
            final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)relation, "SELECT /*OracleDictionaryQueries.ALL_COLUMN_NESTED_TAB_QUERY*/\n       ANT.TABLE_NAME NESTED_TABLE \n,      TRIM(ANT.RETURN_TYPE) \nFROM   SYS.ALL_NESTED_TABLES ANT \nWHERE  ANT.OWNER = ? \nAND    ANT.PARENT_TABLE_NAME = ? \nAND    ANT.PARENT_TABLE_COLUMN = ? \n", relation.getSchema(), relation, column);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            OracleNestedTableProperties oracleNestedTableProperties = (OracleNestedTableProperties)OracleColumnPropertiesBuilder.this.newObject(OracleNestedTableProperties.class, null);
                            oracleNestedTableProperties.setTableName(resultSet.getString(1));
                            String string = resultSet.getString(2);
                            if (string != null) {
                                if (string.equals(OracleNestedTableProperties.ReturnAs.LOCATOR.toString())) {
                                    oracleNestedTableProperties.setReturnAs(OracleNestedTableProperties.ReturnAs.LOCATOR);
                                } else {
                                    oracleNestedTableProperties.setReturnAs(OracleNestedTableProperties.ReturnAs.VALUE);
                                }
                            }
                            oracleColumnProperties.setNestedTableProperties(oracleNestedTableProperties);
                            oracleNestedTableProperties.setID((DBObjectID)new NameBasedID((DBObject)oracleNestedTableProperties, oracleColumnProperties.getID()));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"LOBProperties", "VAProperties"})
    public void buildLOBProperties(OracleColumnProperties oracleColumnProperties) throws DBException {
        Column column = this.getColumn(oracleColumnProperties);
        DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage(), (boolean)false);
        Relation relation = column.getRelation();
        if (relation != null && dataType != null && LOBDescriptor.isLOBType((DataType)dataType) || LOBDescriptor.isVARRAYType((DataType)dataType)) {
            this.buildAllLOBColumns(relation);
        }
    }

    private void buildAllLOBColumns(final Relation relation) throws DBException {
        String string = this.getLOBParametersQuery();
        if (string != null) {
            Schema schema = relation.getSchema();
            final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)relation, string, this.getDatabase().getExternalName(schema.getName(), "SCHEMA"), relation, schema, relation);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            LOBDescriptor lOBDescriptor = (LOBDescriptor)OracleColumnPropertiesBuilder.this.newObject(LOBDescriptor.class, null);
                            int n = resultSet.getInt("CHUNK");
                            lOBDescriptor.setChunk(resultSet.wasNull() ? null : Integer.valueOf(n));
                            lOBDescriptor.setLOBSegName(resultSet.getString("SEGMENT_NAME"));
                            int n2 = resultSet.getInt("PCTVERSION");
                            lOBDescriptor.setPctVersion(resultSet.wasNull() ? null : Integer.valueOf(n2));
                            lOBDescriptor.setStorageInRow(Boolean.valueOf(OracleColumnPropertiesBuilder.this.isYes(resultSet, "IN_ROW")));
                            int n3 = resultSet.getInt("FREEPOOLS");
                            lOBDescriptor.setFreepools(resultSet.wasNull() ? null : Integer.valueOf(n3));
                            if (lOBDescriptor.getPctVersion() == null) {
                                resultSet.getInt("RETENTION");
                                lOBDescriptor.setRetention(!resultSet.wasNull());
                            }
                            String string = resultSet.getString("CACHE");
                            if (!resultSet.wasNull() && string != null) {
                                OracleTableBuilder.setLOBCache(lOBDescriptor, string);
                            }
                            OracleStorageProperties oracleStorageProperties = OracleTableBuilder.getStorageProperties(resultSet);
                            lOBDescriptor.setStorage(oracleStorageProperties);
                            String string2 = resultSet.getString("TABLESPACE_NAME");
                            if (ModelUtil.hasLength((String)string2)) {
                                oracleStorageProperties.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleColumnPropertiesBuilder.this.getDatabase(), string2));
                            }
                            OracleTableBuilder.setLogging(resultSet, oracleStorageProperties);
                            Column column = relation.getColumn(resultSet.getString("COLUMN_NAME"));
                            if (column == null) continue;
                            OracleColumnProperties oracleColumnProperties = OracleColumnPropertiesBuilder.this.getOrCreateProperties(column);
                            if (LOBDescriptor.isLOBColumn((Column)column)) {
                                oracleColumnProperties.setLOBProperties(lOBDescriptor);
                            } else if (LOBDescriptor.isVARRAYColumn((Column)column)) {
                                oracleColumnProperties.setVAProperties(lOBDescriptor);
                            }
                            lOBDescriptor.setID((DBObjectID)new NameBasedID((DBObject)lOBDescriptor, oracleColumnProperties.getID()));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException((DBObject)relation, sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
        }
    }

    private String getLOBParametersQuery() {
        String string = null;
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        if ("Oracle Database".equals(baseOracleDatabase.getDatabaseType())) {
            string = "SELECT /*OracleDictionaryQueries.ALL_TABLE_LOB_PARMATERS_QUERY*/ \n       AL.COLUMN_NAME\n,      AL.SEGMENT_NAME\n,      AL.PCTVERSION\n,      AL.IN_ROW\n,      AL.CHUNK\n,      AL.FREEPOOLS\n,      AL.RETENTION\n,      PS.TABLESPACE_NAME\n,      AL.CACHE\n,      AL.LOGGING\n,      PS.INITIAL_EXTENT\n,      PS.NEXT_EXTENT\n,      PS.MIN_EXTENTS\n,      PS.MAX_EXTENTS\n,      PS.PCT_INCREASE\n,      PS.FREELISTS\n,      PS.FREELIST_GROUPS\n,      PS.BUFFER_POOL\nFROM   SYS.ALL_LOBS AL\n,      SYS.ALL_TABLES T\n,     (SELECT US.SEGMENT_NAME\n       ,      US.TABLESPACE_NAME\n       ,      US.INITIAL_EXTENT\n       ,      US.NEXT_EXTENT\n       ,      US.MIN_EXTENTS\n       ,      US.MAX_EXTENTS\n       ,      US.PCT_INCREASE\n       ,      US.FREELISTS\n       ,      US.FREELIST_GROUPS\n       ,      US.BUFFER_POOL\n       ,      US.PARTITION_NAME\n       FROM   SYS.USER_SEGMENTS US\n       ,      SYS.USER_LOBS UL\n       WHERE  US.SEGMENT_NAME = UL.SEGMENT_NAME\n       AND    US.PARTITION_NAME IS NULL\n       AND    US.SEGMENT_TYPE = 'LOBSEGMENT'\n       AND    USER = ?\n       AND    UL.TABLE_NAME = ?\n      ) PS\nWHERE AL.OWNER = ?\nAND   AL.TABLE_NAME = ?\nAND   AL.OWNER = T.OWNER\nAND   AL.TABLE_NAME = T.TABLE_NAME\nAND   T.PARTITIONED = 'NO'\nAND   AL.SEGMENT_NAME = PS.SEGMENT_NAME (+)";
            int n = baseOracleDatabase.getDatabaseVersion();
            if (n <= 82) {
                string = string.replaceFirst("AL.FREEPOOLS", "null FREEPOOLS").replaceFirst("AL.RETENTION", "null RETENTION");
            }
        }
        return string;
    }

    private boolean isYes(ResultSet resultSet, String string) throws SQLException {
        return "YES".equalsIgnoreCase(resultSet.getString(string));
    }

    private static boolean isTableCollectionType(DataType dataType) {
        boolean bl = false;
        if (dataType instanceof Type) {
            bl = "TABLE".equals(((Type)dataType).getCollectionType());
        }
        return bl;
    }

    static boolean needColumnProperties(BaseOracleDatabase baseOracleDatabase, Table table, Column column, DataType dataType) {
        boolean bl = false;
        if ("TABLE".equals(table.getType())) {
            if (OracleColumnPropertiesBuilder.isTableCollectionType(dataType)) {
                bl = true;
            }
            if ("Oracle Database".equals(baseOracleDatabase.getDatabaseType())) {
                if (LOBDescriptor.isLOBType((DataType)dataType) || LOBDescriptor.isVARRAYType((DataType)dataType)) {
                    bl = true;
                } else if (baseOracleDatabase.getDatabaseVersion() >= 110 && XMLTypeColumnProperties.isXMLType((DataType)dataType)) {
                    bl = true;
                }
            }
        }
        return bl;
    }
}

