/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain.completers;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;

public class CertificateCompleter
implements SemanticCompleter {
    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
        if (prefix.startsWith("\":") || prefix.startsWith(":")) {
            ArrayList list = new ArrayList(ctx.getVarMap().keySet());
            for (String l : list) {
                ret.add(new CompletionItem("\":" + l + "\"", CompletionItem.Type.USER));
            }
        } else {
            try (Statement stmt = ctx.getCurrentConnection().createStatement();
                 ResultSet rs = stmt.executeQuery("select certificate_id from ALL_CERTIFICATES");){
                while (rs.next()) {
                    ret.add(new CompletionItem(rs.getString(1), CompletionItem.Type.USER));
                }
            }
            catch (Throwable e) {
                BICException e1 = new BICException(new String[]{String.format(Messages.getString("BICEXP.COMPLETER_ERROR"), e.getMessage())});
                ctx.writeln(e1.getMessage());
            }
        }
        return ret;
    }
}

