/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.standalone.ElementMetadata;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.MetadataComponent;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;

public class StandaloneUtils {
    public static Map getMetadataMap(StandaloneMetadataFileRegistry registry, XmlKey key) {
        Map metadataMap = new HashMap(StandaloneUtils._getSharedMetadata(registry, key));
        MetadataComponent metadataComponent = StandaloneUtils._getMetadataComponent(registry, key);
        if (metadataComponent != null) {
            Map metadataComponentMap;
            if (key.getNodeType() == 1) {
                int lastIndex;
                List elementPath = key.getElementQNamePath();
                QualifiedName lastName = (QualifiedName)elementPath.get(lastIndex = elementPath.size() - 1);
                String identifier = lastName.getIdentifier();
                if (identifier != null) {
                    Map pseudoKeyMetadataMap = ((ElementMetadata)metadataComponent).getPseudoXmlKeyMetadataMap(identifier);
                    if (pseudoKeyMetadataMap != null) {
                        metadataMap.putAll(pseudoKeyMetadataMap);
                    }
                    return metadataMap;
                }
                String attrNS = lastName.getAttributeNamespace();
                String attrName = lastName.getAttributeName();
                String attrValue = lastName.getAttributeValue();
                if (attrName != null && attrValue != null) {
                    ElementMetadata elementMetadata = (ElementMetadata)metadataComponent;
                    Map fixedAttrMetadataMap = elementMetadata.getFixedAttributeMetadataMap(attrNS, attrName, attrValue);
                    if (fixedAttrMetadataMap != null) {
                        metadataMap.putAll(fixedAttrMetadataMap);
                    }
                    return metadataMap;
                }
            }
            if ((metadataComponentMap = metadataComponent.getMetadataMap()) != null) {
                metadataMap.putAll(metadataComponentMap);
            }
        }
        if (metadataMap.isEmpty()) {
            metadataMap = Collections.EMPTY_MAP;
        }
        return metadataMap;
    }

    public static Collection<XmlKey> getPseudoXmlKeys(XmlKey baseXmlKey, StandaloneMetadataFileRegistry registry) {
        Collection<String> pseudoKeyIdentifiers;
        MetadataComponent metadataComponent = StandaloneUtils._getMetadataComponent(registry, baseXmlKey);
        if (metadataComponent != null && metadataComponent instanceof ElementMetadata && !(pseudoKeyIdentifiers = ((ElementMetadata)metadataComponent).getPseudoXmlKeyIdentifiers()).isEmpty()) {
            List elementPath = baseXmlKey.getElementQNamePath();
            LinkedList<XmlKey> pseudoKeys = new LinkedList<XmlKey>();
            for (String pseudoKeyId : pseudoKeyIdentifiers) {
                XmlKey pseudoKey = ImmutableXmlKey.createPseudoElementKey(elementPath, pseudoKeyId);
                pseudoKeys.add(pseudoKey);
            }
            return pseudoKeys;
        }
        return Collections.emptyList();
    }

    private static Map _getSharedMetadata(StandaloneMetadataFileRegistry registry, XmlKey key) {
        String ns;
        MetadataComponent grammarComponent;
        if ((key.getNodeType() == 1 || key.getNodeType() == 2) && (grammarComponent = StandaloneUtils._getMetadataComponent(registry, ImmutableXmlKey.createNamespaceKey(ns = key.getTargetNamespace()))) != null && grammarComponent instanceof GrammarMetadata) {
            if (key.getNodeType() == 1) {
                return ((GrammarMetadata)grammarComponent).getSharedElementMetadata();
            }
            return ((GrammarMetadata)grammarComponent).getSharedAttributeMetadata();
        }
        return Collections.EMPTY_MAP;
    }

    private static GrammarMetadata _getGrammarMetadata(StandaloneMetadataFileRegistry registry, String namespace) {
        StandaloneMetadataFile grammarFile = registry.getStandaloneMetadataFileForNamespace(namespace);
        if (grammarFile != null) {
            return grammarFile.getGrammarMetadata();
        }
        return null;
    }

    private static ElementMetadata _getElementMetadata(StandaloneMetadataFileRegistry registry, XmlKey key) {
        List elementQNamePath = key.getElementQNamePath();
        ElementMetadata lastElementMd = null;
        if (elementQNamePath != null) {
            for (QualifiedName qName : elementQNamePath) {
                String namespace = qName.getNamespace();
                String localName = qName.getName();
                if (lastElementMd == null) {
                    GrammarMetadata gm = StandaloneUtils._getGrammarMetadata(registry, namespace);
                    if (gm != null) {
                        lastElementMd = gm.getElementMetadataByName(localName);
                    }
                } else {
                    lastElementMd = lastElementMd.getElementMetadataByName(QualifiedName.getQualifiedName(namespace, localName));
                }
                if (lastElementMd != null) continue;
                break;
            }
        }
        return lastElementMd;
    }

    private static final MetadataComponent _getMetadataComponent(StandaloneMetadataFileRegistry registry, XmlKey key) {
        MetadataComponent component = null;
        if (key != null) {
            String namespace = key.getTargetNamespace();
            switch (key.getNodeType()) {
                case 0: {
                    component = StandaloneUtils._getGrammarMetadata(registry, namespace);
                    break;
                }
                case 1: {
                    component = StandaloneUtils._getElementMetadata(registry, key);
                    break;
                }
                case 2: {
                    ElementMetadata elementMetadata = StandaloneUtils._getElementMetadata(registry, key);
                    QualifiedName attrName = key.getAttributeQName();
                    if (elementMetadata != null) {
                        component = elementMetadata.getAttributeMetadataByName(attrName);
                        break;
                    }
                    GrammarMetadata gm = StandaloneUtils._getGrammarMetadata(registry, attrName.getNamespace());
                    if (gm == null) break;
                    component = gm.getAttributeMetadataByName(attrName.getName());
                    break;
                }
            }
        }
        return component;
    }

    private StandaloneUtils() {
    }
}

