/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.functions;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataFunction;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataMethods;
import oracle.bali.xml.metadata.util.XmlPackageHintUtils;

public class GetTranslatedStringFunction
implements MetadataFunction {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.metadata.MetadataEvaluator");

    @Override
    public Object evaluate(Map implicitObjects, Object[] args) throws MetadataException {
        String resourceKey = (String)args[0];
        ResourceBundle bundle = GetTranslatedStringFunction.__getBundle(implicitObjects);
        return GetTranslatedStringFunction.__getFromBundle(resourceKey, bundle);
    }

    @Override
    public Class[] getArgumentTypes() {
        return new Class[]{String.class};
    }

    @Override
    public Class getReturnType() {
        return String.class;
    }

    @Override
    public boolean isMacro() {
        return true;
    }

    static String __getFromBundle(String resourceKey, ResourceBundle bundle) {
        if (bundle != null) {
            return bundle.getString(resourceKey);
        }
        return null;
    }

    static ResourceBundle __getBundle(Map implicitObjects) {
        MetadataEvaluator evaluator = (MetadataEvaluator)implicitObjects.get("evaluator");
        XmlKey key = (XmlKey)implicitObjects.get("key");
        Locale locale = (Locale)implicitObjects.get("locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        XmlKey nsKey = null;
        if (key != null) {
            nsKey = ImmutableXmlKey.createNamespaceKey(key.getTargetNamespace());
        } else {
            XmlKey ownerNSKey = (XmlKey)implicitObjects.get("ownerNS");
            if (ownerNSKey != null) {
                nsKey = ownerNSKey;
            }
        }
        String bundleName = XmlMetadataMethods.getDefaultBundle(evaluator, nsKey, null);
        ResourceBundle bundle = null;
        Set<ClassLoader> loaders = XmlPackageHintUtils.getClassLoaders(bundleName);
        for (ClassLoader loader : loaders) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale, loader);
            }
            catch (MissingResourceException mre) {
                bundle = null;
            }
            if (bundle == null) continue;
            return bundle;
        }
        if (bundleName != null && (bundle = ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader())) != null && GetTranslatedStringFunction._isDebug()) {
            _LOGGER.log(Level.SEVERE, "GetTranslatedStringFunction using context classloader to load resource {0}", GetTranslatedStringFunction._throwRuntimeException(bundleName));
        }
        if (bundle == null && _LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "No bundle found. Bundle name={0} Implicit Objects={1}", new Object[]{bundleName, implicitObjects});
        }
        return bundle;
    }

    private static boolean _isDebug() {
        return Boolean.getBoolean("ide.debugbuild");
    }

    private static RuntimeException _throwRuntimeException(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("The resource bundle ");
        sb.append(value);
        sb.append("\nwas loaded via the context classloader.");
        sb.append("The resource was specified in metadata, with no accompanying hints using the <xml-package-hint-hook> hook.");
        return new RuntimeException(sb.toString());
    }
}

