/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import java.util.List;
import java.util.Map;
import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.PropertyResolver;
import oracle.bali.xml.metadata.el.impl.LoggingUtils;
import oracle.bali.xml.metadata.el.impl.Lookups;

public final class DefaultPropertyResolver
extends PropertyResolver {
    private static final DefaultPropertyResolver _sInstance = new DefaultPropertyResolver();

    public static final DefaultPropertyResolver sharedInstance() {
        return _sInstance;
    }

    @Override
    public Object getValue(Object base, String name) throws ELException {
        if (base == null) {
            return null;
        }
        Object value = null;
        value = base instanceof Map ? Lookups.lookupMap((Map)base, name) : Lookups.lookupBean(base.getClass(), base, name);
        if (value == null) {
            LoggingUtils.getLogger().finer("Property '" + name + "' is null");
        }
        return value;
    }

    @Override
    public Object getValue(Object base, int index) throws ELException {
        if (base == null) {
            return null;
        }
        Object value = null;
        if (base instanceof List) {
            value = Lookups.lookupList((List)base, index);
        } else if (base.getClass().isArray()) {
            value = Lookups.lookupArray(base, index);
        }
        if (value == null) {
            LoggingUtils.getLogger().finer("Property index " + index + " is null");
        }
        return value;
    }

    @Override
    public void setValue(Object base, String name, Object value) throws ELException {
        if (base == null) {
            return;
        }
        if (base instanceof Map) {
            Lookups.updateMap((Map)base, name, value);
        } else {
            Lookups.updateBean(base.getClass(), base, name, value);
        }
    }

    @Override
    public void setValue(Object base, int index, Object value) throws ELException {
        if (base == null) {
            return;
        }
        if (base instanceof List) {
            Lookups.updateList((List)base, index, value);
        } else if (base.getClass().isArray()) {
            Lookups.updateArray(base, index, value);
        } else {
            throw new ELException("Property index " + index + " not found on " + value);
        }
    }

    @Override
    public boolean isReadOnly(Object base, String name) throws ELException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            return false;
        }
        return Lookups.isBeanReadOnly(base.getClass(), base, name);
    }

    @Override
    public boolean isReadOnly(Object base, int index) throws ELException {
        return false;
    }

    @Override
    public Class getType(Object base, String name) throws ELException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            return null;
        }
        return Lookups.getBeanType(base.getClass(), base, name);
    }

    @Override
    public Class getType(Object base, int index) throws ELException {
        if (base.getClass().isArray()) {
            return base.getClass().getComponentType();
        }
        return null;
    }
}

