/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import org.w3c.dom.Element;

public final class DerivedXmlKey
extends XmlKey {
    private final QualifiedName _attributeQName;
    private final List _elementQNamePath;

    @Override
    public final List getElementQNamePath() {
        return this._elementQNamePath;
    }

    @Override
    public final QualifiedName getAttributeQName() {
        return this._attributeQName;
    }

    public static final XmlKey createElementKey(GrammarResolver grammarResolver, XmlKey baseKey, Element element) {
        String fVal;
        FixedAttributeElementDef variant;
        QualifiedName fAttrName;
        Grammar g;
        ElementDef parentDef;
        if (element == null) {
            throw new IllegalArgumentException("Error: createElementKey() param element must not be null");
        }
        String namespace = element.getNamespaceURI();
        String localName = DomUtils.getLocalName(element);
        QualifiedName elementQName = null;
        ElementDef elementDef = null;
        if (baseKey != null && baseKey.getNodeType() == 1 && (parentDef = GrammarUtils.getElementDef(grammarResolver, baseKey)) != null) {
            elementDef = parentDef.getElementDefByName(namespace, localName);
        }
        if (elementDef == null && (g = grammarResolver.getGrammarForNamespace(namespace)) != null) {
            elementDef = g.getElementDefByName(localName);
        }
        if (elementDef != null && (fAttrName = grammarResolver.getFixedAttributeName(elementDef)) != null && (variant = grammarResolver.getFixedAttributeElementDef(element, elementDef, fAttrName, fVal = element.getAttributeNS(fAttrName.getNamespace(), fAttrName.getName()))) != null) {
            elementQName = variant.getQualifiedName();
        }
        if (elementQName == null) {
            elementQName = QualifiedName.getQualifiedName(namespace, localName);
        }
        return DerivedXmlKey.createElementKey(grammarResolver, baseKey, elementQName);
    }

    public static final XmlKey createElementKey(GrammarResolver grammarResolver, XmlKey baseKey, ElementDef elementDef) {
        QualifiedName elementQName = elementDef.getQualifiedName();
        if (GrammarUtils.isElementDefGloballyDefined(grammarResolver, elementDef)) {
            return ImmutableXmlKey.createElementKey(elementQName);
        }
        return DerivedXmlKey.createElementKey(grammarResolver, baseKey, elementQName);
    }

    public static final XmlKey createElementKey(GrammarResolver grammarResolver, XmlKey baseKey, QualifiedName elementQName) {
        if (elementQName == null) {
            throw new IllegalArgumentException("Error: createElementKey() elementQName must not be null");
        }
        List elementQNamePath = DerivedXmlKey._createElementNamePath(grammarResolver, baseKey, elementQName, null, null);
        if (elementQNamePath == null) {
            return null;
        }
        return new DerivedXmlKey(baseKey, elementQNamePath, null);
    }

    public static final XmlKey createElementKey(GrammarResolver grammarResolver, XmlKey baseKey, List elementQNamePath) {
        if (elementQNamePath == null || elementQNamePath.size() == 0) {
            throw new IllegalArgumentException("Error: createElementKey() elementNamePath must not be null or empty");
        }
        if ((elementQNamePath = DerivedXmlKey._createElementNamePath(grammarResolver, baseKey, null, elementQNamePath, null)) == null) {
            return null;
        }
        return new DerivedXmlKey(baseKey, elementQNamePath, null);
    }

    public static final XmlKey createAttributeKey(GrammarResolver grammarResolver, XmlKey baseKey, String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Error: createAttributeKey() attributeName must not be null");
        }
        return DerivedXmlKey.createAttributeKey(grammarResolver, baseKey, QualifiedName.getQualifiedName(null, attributeName));
    }

    public static final XmlKey createAttributeKey(GrammarResolver grammarResolver, XmlKey baseKey, QualifiedName attributeQName) {
        if (attributeQName == null) {
            throw new IllegalArgumentException("Error: createAttributeKey() attributeName must not be null");
        }
        List elementQNamePath = DerivedXmlKey._createElementNamePath(grammarResolver, baseKey, null, null, attributeQName);
        if (elementQNamePath == null) {
            return null;
        }
        return new DerivedXmlKey(baseKey, elementQNamePath, attributeQName);
    }

    public static final XmlKey createAttributeKey(GrammarResolver grammarResolver, XmlKey baseKey, QualifiedName elementQName, String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Error: createAttributeKey() attributeName must not be null");
        }
        return DerivedXmlKey.createAttributeKey(grammarResolver, baseKey, elementQName, QualifiedName.getQualifiedName(null, attributeName));
    }

    public static final XmlKey createAttributeKey(GrammarResolver grammarResolver, XmlKey baseKey, QualifiedName elementQName, QualifiedName attributeQName) {
        List elementQNamePath = DerivedXmlKey._createElementNamePath(grammarResolver, baseKey, elementQName, null, attributeQName);
        if (elementQNamePath == null) {
            return null;
        }
        return new DerivedXmlKey(baseKey, elementQNamePath, attributeQName);
    }

    public static final XmlKey createAttributeKey(GrammarResolver grammarResolver, XmlKey baseKey, List elementQNamePath, String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Error: createAttributeKey() attributeName must not be null");
        }
        return DerivedXmlKey.createAttributeKey(grammarResolver, baseKey, elementQNamePath, QualifiedName.getQualifiedName(null, attributeName));
    }

    public static final XmlKey createAttributeKey(GrammarResolver grammarResolver, XmlKey baseKey, List elementNamePath, QualifiedName attributeQName) {
        if (attributeQName == null) {
            throw new IllegalArgumentException("Error: createAttributeKey() attributeName must not be null");
        }
        return new DerivedXmlKey(baseKey, elementNamePath, attributeQName);
    }

    private static List _createElementNamePath(GrammarResolver gResolver, XmlKey baseKey, QualifiedName elementQName, List elementQNamePath, QualifiedName attributeQName) {
        ArrayList<Object> derivedElementNamePath;
        int basePathSize;
        int elementNamePathSize;
        List basePath = baseKey != null ? baseKey.getElementQNamePath() : null;
        int n = elementNamePathSize = elementQNamePath != null ? elementQNamePath.size() : 0;
        if (elementNamePathSize == 0 && elementQName == null && attributeQName != null && attributeQName.getAttributeNamespace() != null) {
            return basePath;
        }
        int combinedPathSize = basePathSize = basePath != null ? basePath.size() : 0;
        if (elementNamePathSize != 0) {
            combinedPathSize += elementNamePathSize;
        } else if (elementQName != null) {
            ++combinedPathSize;
        }
        ArrayList<Object> combinedPath = new ArrayList<Object>(combinedPathSize);
        if (basePathSize > 0) {
            combinedPath.addAll(basePath);
        }
        if (elementNamePathSize != 0) {
            combinedPath.addAll(elementQNamePath);
        } else if (elementQName != null) {
            combinedPath.add(elementQName);
        }
        int startPathIndex = 0;
        ElementDef currentDef = null;
        QualifiedName currQName = null;
        for (int i = 0; i < combinedPathSize; ++i) {
            Grammar currGrammar;
            ElementDef tempDef = null;
            currQName = (QualifiedName)combinedPath.get(i);
            String currNamespace = currQName.getNamespace();
            String currLocalName = currQName.getName();
            if (currentDef != null) {
                tempDef = currentDef.getElementDefByName(currNamespace, currLocalName);
            }
            if (tempDef == null && (currGrammar = gResolver.getGrammarForNamespace(currNamespace)) != null) {
                tempDef = currGrammar.getElementDefByName(currLocalName);
                startPathIndex = i;
            }
            if (tempDef != null) {
                QualifiedName fAttrQName;
                FixedAttributeElementDef variant;
                String fAttrNS = currQName.getAttributeNamespace();
                String fAttrName = currQName.getAttributeName();
                String fAttrValue = currQName.getAttributeValue();
                if (fAttrName != null && fAttrValue != null && (variant = gResolver.getFixedAttributeElementDef(tempDef, fAttrQName = QualifiedName.getQualifiedName(fAttrNS, fAttrName), fAttrValue)) != null) {
                    tempDef = variant;
                }
            }
            if ((currentDef = tempDef) == null) {
                startPathIndex = i + 1;
            }
            combinedPath.set(i, currentDef);
        }
        if (attributeQName != null) {
            boolean isGlobalAttr = false;
            boolean hasNamespace = false;
            boolean hasNamespaceGrammar = false;
            AttributeDef globalDef = null;
            AttributeDef localDef = null;
            String attrNamespace = attributeQName.getNamespace();
            if (attrNamespace != null && attrNamespace.length() != 0) {
                hasNamespace = true;
                Grammar attrGrammar = gResolver.getGrammarForNamespace(attrNamespace);
                if (attrGrammar != null) {
                    hasNamespaceGrammar = true;
                    globalDef = attrGrammar.getAttributeDefByName(attributeQName.getName());
                }
            }
            if (currentDef != null && (localDef = currentDef.getAttributeDefByName(attributeQName)) != null && localDef.isReference()) {
                localDef = localDef.getReferencedAttributeDef();
            }
            if (localDef != null) {
                if (globalDef != null) {
                    isGlobalAttr = localDef == globalDef;
                }
            } else {
                isGlobalAttr = hasNamespace;
                if (isGlobalAttr && hasNamespaceGrammar && globalDef == null && combinedPathSize > 0) {
                    isGlobalAttr = false;
                }
            }
            if (isGlobalAttr) {
                return Collections.EMPTY_LIST;
            }
        }
        if (startPathIndex == combinedPathSize) {
            return Collections.singletonList(currQName);
        }
        int globalStartIndex = GrammarUtils.getMinimalElementDefPathStartIndex(gResolver, combinedPath, startPathIndex);
        if (globalStartIndex == 0) {
            derivedElementNamePath = combinedPath;
        } else {
            int pathSize = combinedPath.size();
            derivedElementNamePath = new ArrayList(pathSize - globalStartIndex);
        }
        GrammarUtils.copyElementQNamesFromElementDefs(combinedPath, globalStartIndex, derivedElementNamePath);
        return Collections.unmodifiableList(derivedElementNamePath);
    }

    private DerivedXmlKey(XmlKey baseKey, List elementQNamePath, QualifiedName attributeQName) {
        if (baseKey != null && baseKey.getAttributeQName() != null) {
            throw new IllegalStateException("Can not extend attribute key:" + baseKey);
        }
        if (elementQNamePath == null) {
            throw new IllegalArgumentException("No element path specified");
        }
        this._attributeQName = attributeQName;
        this._elementQNamePath = elementQNamePath;
    }
}

