/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.IdentityConstraint;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.schema.OracleElementDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDIdentity;
import org.w3c.dom.Node;

public class OracleIdentityConstraint
implements IdentityConstraint {
    public static final int IDENTITY_UNIQUE = 22;
    public static final int IDENTITY_KEY = 23;
    public static final int IDENTITY_KEYREF = 24;
    private QualifiedName _name;
    private IdentityConstraint.ConstraintType _type;
    private Collection<String> _fields;
    private QualifiedName _refer;
    private String _selector;
    private OracleElementDef _parentElementDef;
    private OracleSchemaFactory _factory;
    private Map<String, String> _prefixNamespaceMap;

    public OracleIdentityConstraint(XSDIdentity xsdIdentity, OracleSchemaFactory factory, OracleElementDef parentElementDef, XSDElement xsdElement) {
        this._name = xsdIdentity.getName().indexOf(":") > 0 ? QualifiedName.getQualifiedName(xsdIdentity.getName()) : QualifiedName.getQualifiedName(parentElementDef.getTargetNamespace(), xsdIdentity.getName());
        if (xsdIdentity.getNodeType() == 22) {
            this._type = IdentityConstraint.ConstraintType.UNIQUE;
        } else if (xsdIdentity.getNodeType() == 23) {
            this._type = IdentityConstraint.ConstraintType.KEY;
        } else if (xsdIdentity.getNodeType() == 24) {
            this._type = IdentityConstraint.ConstraintType.KEYREF;
        }
        this._parentElementDef = parentElementDef;
        this._factory = factory;
        this._fields = new ArrayList<String>();
        for (String fieldExpr : xsdIdentity.getFields()) {
            if (fieldExpr == null) continue;
            this._fields.add(fieldExpr);
        }
        if (xsdIdentity.getRefer() != null) {
            this._refer = xsdIdentity.getRefer().indexOf(":") > -1 ? QualifiedName.getQualifiedName(xsdIdentity.getRefer()) : QualifiedName.getQualifiedName(parentElementDef.getTargetNamespace(), xsdIdentity.getRefer());
        }
        this._selector = xsdIdentity.getSelector();
        this._prefixNamespaceMap = NamespaceUtils.getPrefixesInScope((Node)xsdElement.getDomNode());
    }

    @Override
    public QualifiedName getName() {
        return this._name;
    }

    @Override
    public IdentityConstraint.ConstraintType getType() {
        return this._type;
    }

    @Override
    public Collection<String> getFields() {
        return this._fields;
    }

    @Override
    public QualifiedName getRefer() {
        return this._refer;
    }

    @Override
    public String getSelector() {
        String selectExpr = this._selector;
        if (selectExpr == null) {
            return null;
        }
        return selectExpr;
    }

    @Override
    public ElementDef getParentElementDef() {
        return this._parentElementDef;
    }

    @Override
    public IdentityConstraint getKeyIdentityConstraint() {
        if (this.getRefer() == null) {
            return null;
        }
        return this._factory.getKeyIdentityConstraint(this.getRefer());
    }

    @Override
    public Map<String, String> getPrefixNamespaceMap() {
        return this._prefixNamespaceMap;
    }
}

