/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.ref;

import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.ref.NonAttrNodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AttrNodeRef
extends NodeRef {
    private final NodeRef _parentRef;
    private final String _namespace;
    private final String _localName;

    AttrNodeRef(Attr attr) {
        this(NodeRefFactory.getNodeRef(attr.getOwnerElement()), attr.getNamespaceURI(), DomUtils.getLocalName(attr));
    }

    AttrNodeRef(NodeRef parentRef, String namespace, String localName) {
        if (parentRef instanceof AttrNodeRef) {
            throw new IllegalArgumentException("Parent node ref for an attr can not refer to another attr!");
        }
        this._parentRef = parentRef;
        this._namespace = namespace;
        this._localName = localName;
    }

    @Override
    public Node getCorrespondingNode(Document doc) {
        Element parent = (Element)this._parentRef.getCorrespondingNode(doc);
        return parent.getAttributeNodeNS(this._namespace, this._localName);
    }

    @Override
    public void putCorrespondingNode(Document doc, Node newNode) {
        Element parent = (Element)this._parentRef.getCorrespondingNode(doc);
        parent.setAttributeNodeNS((Attr)newNode);
    }

    @Override
    public NodeRef getChildNodeRef(Node child) {
        throw new UnsupportedOperationException("AttrNode refs can not have children");
    }

    @Override
    public String getJavaExpression(String docExpr) {
        StringBuffer buf = new StringBuffer();
        buf.append("((Element) ");
        buf.append(this._parentRef.getJavaExpression(docExpr));
        buf.append(").getAttributeNodeNS(");
        if (this._namespace == null) {
            buf.append("null");
        } else {
            buf.append("\"");
            buf.append(this._namespace);
            buf.append("\"");
        }
        buf.append(", \"");
        buf.append(this._localName);
        buf.append("\")");
        return buf.toString();
    }

    public String toString() {
        String ns = this._namespace == null ? "" : this._namespace + ":";
        return ns + this._localName + "@" + this._parentRef;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonAttrNodeRef)) {
            return false;
        }
        AttrNodeRef other = (AttrNodeRef)o;
        if (!this._parentRef.equals(other._parentRef)) {
            return false;
        }
        return this._eq(this._namespace, other._namespace) && this._eq(this._localName, other._localName);
    }

    private boolean _eq(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

