/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ideimpl.gallery.GalleryElementReference;
import oracle.javatools.data.HashStructure;

public final class NewMenuCustomizationHook
extends HashStructureHook {
    private boolean initialized = false;
    private List<GalleryElementReference> _galleryItems;
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/customization", "new-menu-customizations");

    public void start(ElementStartContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.start(context);
        }
    }

    public void end(ElementEndContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.end(context);
        }
    }

    public List<GalleryElementReference> getGalleryItems() {
        if (!this.initialized) {
            this.initialize();
        }
        return Collections.unmodifiableList(this._galleryItems);
    }

    public static NewMenuCustomizationHook get() {
        return (NewMenuCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    Logger.getLogger(NewMenuCustomizationHook.class.getName()).log(Level.SEVERE, "The new-menu-customizations-hook can be used once in the role file.");
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    HashStructure hash = e.getCombinedHashStructure();
                    List galleryItems = hash.getAsList("gallery-item");
                    if (galleryItems == null) {
                        NewMenuCustomizationHook.this._galleryItems = Collections.emptyList();
                        return;
                    }
                    NewMenuCustomizationHook.this._galleryItems = new ArrayList<GalleryElementReference>(galleryItems.size());
                    for (HashStructure itemHash : galleryItems) {
                        GalleryElementReference elementReference = GalleryElementReference.getInstance(itemHash);
                        if (!elementReference.getBoolean("add-to-new-menu", false)) continue;
                        NewMenuCustomizationHook.this._galleryItems.add(elementReference);
                    }
                }
            });
        }
    }
}

