/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;

public class GalleryFolder
implements Folder,
Comparable {
    protected static final Collator COLLATOR = Collator.getInstance();
    private String _label;
    private String _name;
    private List _children = new ArrayList(10);
    private boolean _unsorted;
    private boolean _expanded;

    public GalleryFolder() {
    }

    public GalleryFolder(String name) {
        this();
        this._name = name;
    }

    public List getList() {
        return Collections.unmodifiableList(this.getChildrenDirectly());
    }

    public void setList(List list) {
        List children = this.getChildrenDirectly();
        children.clear();
        if (list != null) {
            for (Object next : list) {
                if (!(next instanceof Element)) continue;
                this.add((Element)next);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean getUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean unsorted) {
        this._unsorted = unsorted;
    }

    public void setLabel(String translatedLabel) {
        if (this._label == null && translatedLabel != null) {
            this._label = translatedLabel;
        }
    }

    public String getLabel() {
        return this._label;
    }

    public GalleryFolder getFolder(String folderName) {
        return this.findFolder(folderName, false);
    }

    public GalleryFolder createFolder(String folderName) {
        GalleryFolder f = this.getFolder(folderName);
        if (f == null) {
            f = new GalleryFolder(folderName);
            this.add((Element)f);
        }
        return f;
    }

    @Deprecated
    public GalleryFolder getGalleryFolder(String folderName) {
        try {
            return this.findFolder(folderName);
        }
        catch (Exception ex) {
            Assert.println((String)("GalleryFolder.getGalleryFolder Exception: " + ex.toString()));
            return null;
        }
    }

    public GalleryElement getGalleryElement(String elementName) {
        List children = this.getChildrenDirectly();
        for (Element e : children) {
            String label;
            if (e instanceof GalleryFolder) {
                GalleryElement ge = ((GalleryFolder)e).getGalleryElement(elementName);
                if (ge == null) continue;
                return ge;
            }
            if (!(e instanceof GalleryElement) || (label = e.getShortLabel()) == null || !ModelUtil.areEqual((Object)label, (Object)elementName)) continue;
            return (GalleryElement)e;
        }
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        return this.getList().iterator();
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public boolean canAdd(Element element) {
        return false;
    }

    public boolean add(Element element) {
        List children = this.getChildrenDirectly();
        return children.add(element);
    }

    public boolean canRemove(Element element) {
        return false;
    }

    public boolean remove(Element element) {
        List children = this.getChildrenDirectly();
        return children.remove(element);
    }

    public void removeAll() {
        List children = this.getChildrenDirectly();
        children.clear();
    }

    public boolean containsChild(Element element) {
        List children = this.getChildrenDirectly();
        return children.contains(element);
    }

    public int size() {
        List children = this.getChildrenDirectly();
        return children.size();
    }

    public String getShortLabel() {
        return this.getLabel() != null ? this.getLabel() : this.getName();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this._name;
    }

    public Icon getIcon() {
        return null;
    }

    public String toString() {
        return this.getLongLabel();
    }

    public Object getData() {
        return this;
    }

    public int compareTo(Object o) {
        if (o instanceof GalleryElement) {
            return -1;
        }
        if (o instanceof GalleryFolder) {
            GalleryFolder f = (GalleryFolder)o;
            if (this.getUnsorted() != f.getUnsorted()) {
                return this.getUnsorted() ? -1 : 1;
            }
            if (this.getUnsorted() && f.getUnsorted()) {
                return 0;
            }
            return GalleryFolder.compareImpl(this.getShortLabel(), f.getShortLabel());
        }
        return GalleryFolder.compareImpl(this.getShortLabel(), o.toString());
    }

    private static int compareImpl(String strForThis, String strForOther) {
        if (strForThis == null) {
            return strForOther == null ? 0 : -1;
        }
        if (strForOther == null) {
            return 1;
        }
        return COLLATOR.compare(strForThis, strForOther);
    }

    @Deprecated
    public int getSize() {
        return this.size();
    }

    @Deprecated
    public Object getElementAt(int index) {
        List children = this.getChildrenDirectly();
        return children.get(index);
    }

    protected boolean isExpanded() {
        return this._expanded;
    }

    protected void setExpanded(boolean expanded) {
        this._expanded = expanded;
    }

    protected List getChildrenDirectly() {
        return this._children;
    }

    protected void setChildrenDirectly(List children) {
        this._children = children;
    }

    protected GalleryElement[] getElementChildren() {
        Collection elements = this.getChildrenByClass(GalleryElement.class);
        return elements.toArray(new GalleryElement[elements.size()]);
    }

    protected GalleryElement[] getSortedElementChildren() {
        Object[] children = this.getElementChildren();
        Arrays.sort(children);
        return children;
    }

    protected GalleryFolder[] getFolderChildren() {
        Collection folders = this.getChildrenByClass(GalleryFolder.class);
        return folders.toArray(new GalleryFolder[folders.size()]);
    }

    protected GalleryFolder findFolder(String folderName) {
        return this.findFolder(folderName, true);
    }

    boolean addElement(ElementInfo info) {
        GalleryElement ele = this.getGalleryElement(info.getName());
        if (ele == null) {
            ele = info.createElement();
            this.add(ele);
            return true;
        }
        return false;
    }

    boolean removeElement(ElementInfo info) {
        GalleryElement ele = info.createElement();
        if ((ele = this.getGalleryElement(ele.getShortLabel())) != null) {
            this.remove(ele);
            return true;
        }
        return false;
    }

    boolean isAvailable(Context context) {
        if (context == null) {
            return false;
        }
        for (Object next : this.getChildrenDirectly()) {
            if (!(next instanceof GalleryFolder ? ((GalleryFolder)next).isAvailable(context) : next instanceof GalleryElement && ((GalleryElement)next).isAvailable(context))) continue;
            return true;
        }
        return false;
    }

    void debugLogTechnologies(PrintStream log, String path, Map techMap) {
        Object[] elements = this.getElementChildren();
        if (elements.length > 0) {
            log.println();
            log.println(path + ":");
            Arrays.sort(elements);
            for (int i = 0; i < elements.length; ++i) {
                Object e = elements[i];
                String[] technologyKeys = ((GalleryElement)e).getTechnologyKeys();
                String tech = GalleryFolder.getTechnologyString(technologyKeys);
                log.println("  " + ((GalleryElement)e).getShortLabel() + " [" + tech + "]");
                ArrayList<CallSite> l = (ArrayList<CallSite>)techMap.get(tech);
                if (l == null) {
                    l = new ArrayList<CallSite>();
                    techMap.put(tech, l);
                }
                l.add((CallSite)((Object)(path + ": " + ((GalleryElement)e).getShortLabel())));
            }
        }
        Object[] folders = this.getFolderChildren();
        Arrays.sort(folders);
        for (int i = 0; i < folders.length; ++i) {
            Object f = folders[i];
            String label = ((GalleryFolder)f).getShortLabel();
            String newPath = path != null ? path + " -> " + label : label;
            ((GalleryFolder)f).debugLogTechnologies(log, newPath, techMap);
        }
    }

    private static String getTechnologyString(String[] technologyKeys) {
        if (technologyKeys == null || technologyKeys.length == 0) {
            return "<none>";
        }
        Arrays.sort(technologyKeys);
        TechnologyRegistry techRegistry = TechnologyRegistry.getInstance();
        TreeSet<TechId> ancestorTechs = new TreeSet<TechId>();
        Object key = "";
        for (int i = 0; i < technologyKeys.length; ++i) {
            TechId[] dependencies;
            TechId techId;
            String technologyKey = technologyKeys[i];
            key = (String)key + technologyKey;
            if (i < technologyKeys.length - 1) {
                key = (String)key + " + ";
            }
            if ((techId = techRegistry.getTechId(technologyKey)) == null) continue;
            for (TechId dependency : dependencies = techRegistry.getDependenciesFor(techId)) {
                if (dependency == null) continue;
                ancestorTechs.add(dependency);
            }
        }
        if (!ancestorTechs.isEmpty()) {
            key = (String)key + " (depends on ";
            Iterator it = ancestorTechs.iterator();
            while (it.hasNext()) {
                TechId techId = (TechId)it.next();
                key = (String)key + techId.getKey();
                if (!it.hasNext()) continue;
                key = (String)key + " + ";
            }
            key = (String)key + ")";
        }
        return key;
    }

    private Collection getChildrenByClass(Class clazz) {
        List children = this.getChildrenDirectly();
        ArrayList classChildren = new ArrayList();
        for (Object next : children) {
            if (clazz != null && !clazz.isAssignableFrom(next.getClass())) continue;
            classChildren.add(next);
        }
        return classChildren;
    }

    private GalleryFolder findFolder(String folderName, boolean recurse) {
        GalleryFolder[] folders = this.getFolderChildren();
        for (int i = 0; i < folders.length; ++i) {
            GalleryFolder f;
            GalleryFolder folder = folders[i];
            if (folder.getName().equals(folderName)) {
                return folder;
            }
            if (!recurse || (f = folder.findFolder(folderName, recurse)) == null) continue;
            return f;
        }
        return null;
    }
}

