/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy.stmtlogging;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.raptor.proxy.ProxyRegistry;

public class TableCellWithTooltip
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            if (object instanceof Integer) {
                this.setToolTip(jLabel, ((Integer)object).toString());
            } else if (object != null) {
                jLabel.setIcon(null);
                String string = object.toString();
                if (string != null) {
                    int n3 = jTable.convertColumnIndexToModel(n2);
                    if (ProxyRegistry.DEBUG_BUILD) {
                        switch (n3) {
                            case 3: 
                            case 6: {
                                jLabel.setText(TableCellWithTooltip.scrubClass(string));
                            }
                        }
                    } else {
                        switch (n3) {
                            case 4: {
                                jLabel.setText(TableCellWithTooltip.scrubClass(string));
                            }
                        }
                    }
                    this.setToolTip(jLabel, string);
                }
            }
        }
        return component;
    }

    public static String scrubClass(String string) {
        if (string != null) {
            return string.replaceAll("oracle[.]", "o.").replaceAll("raptor[.]", "r.").replaceAll("javatools[.]", "jt.").replaceAll("java[.]", "j.").replaceAll("dbtools[.]", "d.");
        }
        return string;
    }

    private void setToolTip(JLabel jLabel, String string) {
        Object object = string.toString();
        if (((String)object).length() > 200) {
            object = ((String)object).substring(0, 200) + "\n...";
        }
        jLabel.setToolTipText("<html>" + ((String)object).replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>") + "</html>");
    }
}

